/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.AlertPluginInstanceService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.vo.AlertPluginInstanceVO;
import org.apache.dolphinscheduler.common.enums.AlertPluginInstanceType;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.AlertGroup;
import org.apache.dolphinscheduler.dao.entity.AlertPluginInstance;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.AlertGroupMapper;
import org.apache.dolphinscheduler.dao.mapper.AlertPluginInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.PluginDefineMapper;
import org.apache.dolphinscheduler.extract.alert.IAlertOperator;
import org.apache.dolphinscheduler.extract.alert.request.AlertSendResponse;
import org.apache.dolphinscheduler.extract.alert.request.AlertTestSendRequest;
import org.apache.dolphinscheduler.extract.base.client.SingletonJdkDynamicRpcClientProxyFactory;
import org.apache.dolphinscheduler.extract.base.utils.Host;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.spi.params.PluginParamsTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Lazy
public class AlertPluginInstanceServiceImpl
extends BaseServiceImpl
implements AlertPluginInstanceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertPluginInstanceServiceImpl.class);
    @Autowired
    private AlertPluginInstanceMapper alertPluginInstanceMapper;
    @Autowired
    private PluginDefineMapper pluginDefineMapper;
    @Autowired
    private AlertGroupMapper alertGroupMapper;
    private final Integer GLOBAL_ALERT_GROUP_ID = 2;
    @Autowired
    private RegistryClient registryClient;

    @Override
    public AlertPluginInstance create(User loginUser, int pluginDefineId, String instanceName, AlertPluginInstanceType instanceType, WarningType warningType, String pluginInstanceParams) {
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.ALERT_PLUGIN_INSTANCE, "security:alert-plugin:create")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        AlertPluginInstance alertPluginInstance = new AlertPluginInstance();
        String paramsMapJson = this.parsePluginParamsMap(pluginInstanceParams);
        alertPluginInstance.setPluginInstanceParams(paramsMapJson);
        alertPluginInstance.setInstanceName(instanceName);
        alertPluginInstance.setPluginDefineId(pluginDefineId);
        alertPluginInstance.setInstanceType(instanceType);
        alertPluginInstance.setWarningType(warningType);
        if (this.alertPluginInstanceMapper.existInstanceName(alertPluginInstance.getInstanceName()) == Boolean.TRUE) {
            throw new ServiceException(Status.PLUGIN_INSTANCE_ALREADY_EXISTS);
        }
        int i = this.alertPluginInstanceMapper.insert((Object)alertPluginInstance);
        if (i > 0) {
            log.info("Create alert plugin instance complete, name:{}", (Object)alertPluginInstance.getInstanceName());
            if (instanceType == AlertPluginInstanceType.GLOBAL) {
                AlertGroup globalAlertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)this.GLOBAL_ALERT_GROUP_ID);
                if (StringUtils.isEmpty((CharSequence)globalAlertGroup.getAlertInstanceIds())) {
                    globalAlertGroup.setAlertInstanceIds(String.valueOf(alertPluginInstance.getId()));
                } else {
                    List ids = Arrays.stream(globalAlertGroup.getAlertInstanceIds().split(",")).map(s -> Integer.parseInt(s.trim())).collect(Collectors.toList());
                    ids.add(alertPluginInstance.getId());
                    globalAlertGroup.setAlertInstanceIds(StringUtils.join(ids, (String)","));
                }
                this.alertGroupMapper.updateById((Object)globalAlertGroup);
            }
            return alertPluginInstance;
        }
        throw new ServiceException(Status.SAVE_ERROR);
    }

    @Override
    public AlertPluginInstance updateById(User loginUser, int pluginInstanceId, String instanceName, WarningType warningType, String pluginInstanceParams) {
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.ALERT_PLUGIN_INSTANCE, "security:alert-plugin:update")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        String paramsMapJson = this.parsePluginParamsMap(pluginInstanceParams);
        AlertPluginInstance alertPluginInstance = new AlertPluginInstance(pluginInstanceId, paramsMapJson, instanceName, warningType, new Date());
        int i = this.alertPluginInstanceMapper.updateById((Object)alertPluginInstance);
        if (i > 0) {
            log.info("Update alert plugin instance complete, instanceId:{}, name:{}", (Object)alertPluginInstance.getId(), (Object)alertPluginInstance.getInstanceName());
            return alertPluginInstance;
        }
        throw new ServiceException(Status.SAVE_ERROR);
    }

    @Override
    @Transactional
    public void deleteById(User loginUser, int alertPluginInstanceId) {
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.ALERT_PLUGIN_INSTANCE, "security:alert-plugin:delete")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        AlertPluginInstance alertPluginInstance = (AlertPluginInstance)this.alertPluginInstanceMapper.selectById((Serializable)Integer.valueOf(alertPluginInstanceId));
        if (alertPluginInstance.getInstanceType() == AlertPluginInstanceType.GLOBAL) {
            AlertGroup globalAlertGroup = (AlertGroup)this.alertGroupMapper.selectById((Serializable)this.GLOBAL_ALERT_GROUP_ID);
            List ids = Arrays.stream(globalAlertGroup.getAlertInstanceIds().split(",")).map(s -> Integer.parseInt(s.trim())).collect(Collectors.toList());
            ids = ids.stream().filter(x -> x != alertPluginInstanceId).collect(Collectors.toList());
            globalAlertGroup.setAlertInstanceIds(StringUtils.join(ids, (String)","));
            this.alertGroupMapper.updateById((Object)globalAlertGroup);
            log.info("Remove global alert plugin instance from global alert group automatically, name:{}", (Object)alertPluginInstance.getInstanceName());
        } else {
            boolean hasAssociatedAlertGroup = this.checkHasAssociatedAlertGroup(String.valueOf(alertPluginInstanceId));
            if (hasAssociatedAlertGroup) {
                throw new ServiceException(Status.DELETE_ALERT_PLUGIN_INSTANCE_ERROR_HAS_ALERT_GROUP_ASSOCIATED);
            }
        }
        this.alertPluginInstanceMapper.deleteById((Serializable)Integer.valueOf(alertPluginInstanceId));
    }

    @Override
    public AlertPluginInstance getById(User loginUser, int id) {
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.ALERT_PLUGIN_INSTANCE, "security:alert-plugin:view")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        return (AlertPluginInstance)this.alertPluginInstanceMapper.selectById((Serializable)Integer.valueOf(id));
    }

    @Override
    public List<AlertPluginInstanceVO> queryAll() {
        List alertPluginInstances = this.alertPluginInstanceMapper.queryAllAlertPluginInstanceList();
        return this.buildPluginInstanceVOList(alertPluginInstances);
    }

    @Override
    public boolean checkExistPluginInstanceName(String pluginInstanceName) {
        return this.alertPluginInstanceMapper.existInstanceName(pluginInstanceName) == Boolean.TRUE;
    }

    @Override
    public PageInfo<AlertPluginInstanceVO> listPaging(User loginUser, String searchVal, int pageNo, int pageSize) {
        IPage alertPluginInstanceIPage = this.alertPluginInstanceMapper.queryByInstanceNamePage(new Page((long)pageNo, (long)pageSize), searchVal);
        PageInfo<AlertPluginInstanceVO> pageInfo = new PageInfo<AlertPluginInstanceVO>(pageNo, pageSize);
        pageInfo.setTotal((int)alertPluginInstanceIPage.getTotal());
        pageInfo.setTotalList(this.buildPluginInstanceVOList(alertPluginInstanceIPage.getRecords()));
        return pageInfo;
    }

    private List<AlertPluginInstanceVO> buildPluginInstanceVOList(List<AlertPluginInstance> alertPluginInstances) {
        ArrayList<AlertPluginInstanceVO> alertPluginInstanceVOS = new ArrayList<AlertPluginInstanceVO>();
        if (CollectionUtils.isEmpty(alertPluginInstances)) {
            return alertPluginInstanceVOS;
        }
        List pluginDefineList = this.pluginDefineMapper.queryAllPluginDefineList();
        if (CollectionUtils.isEmpty((Collection)pluginDefineList)) {
            return alertPluginInstanceVOS;
        }
        Map pluginDefineMap = pluginDefineList.stream().collect(Collectors.toMap(PluginDefine::getId, Function.identity()));
        alertPluginInstances.forEach(alertPluginInstance -> {
            PluginDefine pluginDefine;
            AlertPluginInstanceVO alertPluginInstanceVO = new AlertPluginInstanceVO();
            alertPluginInstanceVO.setCreateTime(alertPluginInstance.getCreateTime());
            alertPluginInstanceVO.setUpdateTime(alertPluginInstance.getUpdateTime());
            alertPluginInstanceVO.setPluginDefineId(alertPluginInstance.getPluginDefineId());
            alertPluginInstanceVO.setInstanceName(alertPluginInstance.getInstanceName());
            alertPluginInstanceVO.setId(alertPluginInstance.getId());
            alertPluginInstanceVO.setInstanceType(alertPluginInstance.getInstanceType().getDescp());
            if (alertPluginInstance.getWarningType() != null) {
                alertPluginInstanceVO.setWarningType(alertPluginInstance.getWarningType().getDescp().toUpperCase());
            }
            if (null == (pluginDefine = (PluginDefine)pluginDefineMap.get(alertPluginInstance.getPluginDefineId()))) {
                return;
            }
            alertPluginInstanceVO.setAlertPluginName(pluginDefine.getPluginName());
            String pluginParamsMapString = alertPluginInstance.getPluginInstanceParams();
            String uiPluginParams = this.parseToPluginUiParams(pluginParamsMapString, pluginDefine.getPluginParams());
            alertPluginInstanceVO.setPluginInstanceParams(uiPluginParams);
            alertPluginInstanceVOS.add(alertPluginInstanceVO);
        });
        return alertPluginInstanceVOS;
    }

    private String parsePluginParamsMap(String pluginParams) {
        Map paramsMap = PluginParamsTransfer.getPluginParamsMap((String)pluginParams);
        return JSONUtils.toJsonString((Object)paramsMap);
    }

    private String parseToPluginUiParams(String pluginParamsMapString, String pluginUiParams) {
        List pluginParamsList = PluginParamsTransfer.generatePluginParams((String)pluginParamsMapString, (String)pluginUiParams);
        return JSONUtils.toJsonString((Object)pluginParamsList);
    }

    private boolean checkHasAssociatedAlertGroup(String id) {
        List idsList = this.alertGroupMapper.queryInstanceIdsList();
        if (CollectionUtils.isEmpty((Collection)idsList)) {
            return false;
        }
        Optional<String> first = idsList.stream().filter(k -> null != k && Arrays.asList(k.split(",")).contains(id)).findFirst();
        return first.isPresent();
    }

    public Optional<Host> getAlertServerAddress() {
        List serverList = this.registryClient.getServerList(RegistryNodeType.ALERT_SERVER);
        if (CollectionUtils.isEmpty((Collection)serverList)) {
            return Optional.empty();
        }
        Server server = (Server)serverList.get(0);
        return Optional.of(new Host(server.getHost(), server.getPort()));
    }

    @Override
    public void testSend(int pluginDefineId, String pluginInstanceParams) {
        AlertSendResponse alertSendResponse;
        Optional<Host> alertServerAddressOptional = this.getAlertServerAddress();
        if (!alertServerAddressOptional.isPresent()) {
            throw new ServiceException(Status.ALERT_SERVER_NOT_EXIST);
        }
        Host alertServerAddress = alertServerAddressOptional.get();
        AlertTestSendRequest alertTestSendRequest = new AlertTestSendRequest(pluginDefineId, pluginInstanceParams);
        try {
            IAlertOperator alertOperator = (IAlertOperator)SingletonJdkDynamicRpcClientProxyFactory.getProxyClient((String)alertServerAddress.getAddress(), IAlertOperator.class);
            alertSendResponse = alertOperator.sendTestAlert(alertTestSendRequest);
            log.info("Send alert to: {} successfully, response: {}", (Object)alertServerAddress, (Object)alertSendResponse);
        }
        catch (Exception e) {
            log.error("Send alert: {} to: {} failed", new Object[]{alertTestSendRequest, alertServerAddress, e});
            throw new ServiceException(Status.ALERT_TEST_SENDING_FAILED, e.getMessage());
        }
        if (alertSendResponse.isSuccess()) {
            throw new ServiceException(Status.ALERT_TEST_SENDING_FAILED, ((AlertSendResponse.AlertSendResponseResult)alertSendResponse.getResResults().get(0)).getMessage());
        }
    }
}

