/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.ClusterDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.k8s.K8sManager;
import org.apache.dolphinscheduler.api.service.ClusterService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.dao.entity.Cluster;
import org.apache.dolphinscheduler.dao.entity.K8sNamespace;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ClusterMapper;
import org.apache.dolphinscheduler.dao.mapper.K8sNamespaceMapper;
import org.apache.dolphinscheduler.service.utils.ClusterConfUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClusterServiceImpl
extends BaseServiceImpl
implements ClusterService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterServiceImpl.class);
    @Autowired
    private ClusterMapper clusterMapper;
    @Autowired
    private K8sManager k8sManager;
    @Autowired
    private K8sNamespaceMapper k8sNamespaceMapper;

    @Override
    @Transactional
    public Long createCluster(User loginUser, String name, String config, String desc) {
        if (this.isNotAdmin(loginUser)) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        this.checkParams(name, config);
        Cluster clusterExistByName = this.clusterMapper.queryByClusterName(name);
        if (clusterExistByName != null) {
            throw new ServiceException(Status.CLUSTER_NAME_EXISTS, name);
        }
        Cluster cluster = new Cluster();
        cluster.setName(name);
        cluster.setConfig(config);
        cluster.setDescription(desc);
        cluster.setOperator(loginUser.getId());
        cluster.setCreateTime(new Date());
        cluster.setUpdateTime(new Date());
        cluster.setCode(Long.valueOf(CodeGenerateUtils.getInstance().genCode()));
        if (this.clusterMapper.insert((Object)cluster) > 0) {
            return cluster.getCode();
        }
        throw new ServiceException(Status.CREATE_CLUSTER_ERROR);
    }

    @Override
    public PageInfo<ClusterDto> queryClusterListPaging(Integer pageNo, Integer pageSize, String searchVal) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage clusterIPage = this.clusterMapper.queryClusterListPaging((IPage)page, searchVal);
        PageInfo<ClusterDto> pageInfo = new PageInfo<ClusterDto>(pageNo, pageSize);
        pageInfo.setTotal((int)clusterIPage.getTotal());
        if (CollectionUtils.isEmpty((Collection)clusterIPage.getRecords())) {
            return pageInfo;
        }
        List dtoList = clusterIPage.getRecords().stream().map(cluster -> {
            ClusterDto dto = new ClusterDto();
            BeanUtils.copyProperties((Object)cluster, (Object)dto);
            return dto;
        }).collect(Collectors.toList());
        pageInfo.setTotalList(dtoList);
        return pageInfo;
    }

    @Override
    public List<ClusterDto> queryAllClusterList() {
        List clusterList = this.clusterMapper.queryAllClusterList();
        if (CollectionUtils.isEmpty((Collection)clusterList)) {
            return Collections.emptyList();
        }
        return clusterList.stream().map(cluster -> {
            ClusterDto dto = new ClusterDto();
            BeanUtils.copyProperties((Object)cluster, (Object)dto);
            return dto;
        }).collect(Collectors.toList());
    }

    @Override
    public ClusterDto queryClusterByCode(Long code) {
        Cluster cluster = this.clusterMapper.queryByClusterCode(code);
        if (cluster == null) {
            throw new ServiceException(Status.QUERY_CLUSTER_BY_CODE_ERROR, code);
        }
        ClusterDto dto = new ClusterDto();
        BeanUtils.copyProperties((Object)cluster, (Object)dto);
        return dto;
    }

    @Override
    public ClusterDto queryClusterByName(String name) {
        Cluster cluster = this.clusterMapper.queryByClusterName(name);
        if (cluster == null) {
            throw new ServiceException(Status.QUERY_CLUSTER_BY_NAME_ERROR, name);
        }
        ClusterDto dto = new ClusterDto();
        BeanUtils.copyProperties((Object)cluster, (Object)dto);
        return dto;
    }

    @Override
    public void deleteClusterByCode(User loginUser, Long code) {
        if (this.isNotAdmin(loginUser)) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        Long relatedNamespaceNumber = this.k8sNamespaceMapper.selectCount((Wrapper)new QueryWrapper().lambda().eq(K8sNamespace::getClusterCode, (Object)code));
        if (relatedNamespaceNumber > 0L) {
            throw new ServiceException(Status.DELETE_CLUSTER_RELATED_NAMESPACE_EXISTS);
        }
        int delete = this.clusterMapper.deleteByCode(code);
        if (delete > 0) {
            return;
        }
        throw new ServiceException(Status.DELETE_CLUSTER_ERROR);
    }

    @Override
    public Cluster updateClusterByCode(User loginUser, Long code, String name, String config, String desc) {
        if (this.isNotAdmin(loginUser)) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        if (this.checkDescriptionLength(desc)) {
            throw new ServiceException(Status.DESCRIPTION_TOO_LONG_ERROR);
        }
        this.checkParams(name, config);
        Cluster clusterExistByName = this.clusterMapper.queryByClusterName(name);
        if (clusterExistByName != null && !clusterExistByName.getCode().equals(code)) {
            throw new ServiceException(Status.CLUSTER_NAME_EXISTS, name);
        }
        Cluster clusterExist = this.clusterMapper.queryByClusterCode(code);
        if (clusterExist == null) {
            throw new ServiceException(Status.CLUSTER_NOT_EXISTS, name);
        }
        if (!Constants.K8S_LOCAL_TEST_CLUSTER_CODE.equals(clusterExist.getCode()) && !config.equals(ClusterConfUtils.getK8sConfig((String)clusterExist.getConfig()))) {
            try {
                this.k8sManager.getAndUpdateK8sClient(code, true);
            }
            catch (Exception e) {
                throw new ServiceException(Status.K8S_CLIENT_OPS_ERROR, name);
            }
        }
        clusterExist.setConfig(config);
        clusterExist.setName(name);
        clusterExist.setDescription(desc);
        this.clusterMapper.updateById((Object)clusterExist);
        return clusterExist;
    }

    @Override
    public void verifyCluster(String clusterName) {
        if (StringUtils.isEmpty((CharSequence)clusterName)) {
            throw new ServiceException(Status.CLUSTER_NAME_IS_NULL);
        }
        Cluster cluster = this.clusterMapper.queryByClusterName(clusterName);
        if (cluster != null) {
            throw new ServiceException(Status.CLUSTER_NAME_EXISTS);
        }
    }

    protected void checkParams(String name, String config) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new ServiceException(Status.CLUSTER_NAME_IS_NULL);
        }
        if (StringUtils.isEmpty((CharSequence)config)) {
            throw new ServiceException(Status.CLUSTER_CONFIG_IS_NULL);
        }
    }
}

