/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.ProjectPreferenceService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectPreference;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectPreferenceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectPreferenceServiceImpl
extends BaseServiceImpl
implements ProjectPreferenceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectPreferenceServiceImpl.class);
    @Autowired
    private ProjectPreferenceMapper projectPreferenceMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ProjectMapper projectMapper;

    @Override
    public Result updateProjectPreference(User loginUser, long projectCode, String preferences) {
        Result<ProjectPreference> result = new Result<ProjectPreference>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result);
        if (!hasProjectAndWritePerm) {
            return result;
        }
        ProjectPreference projectPreference = (ProjectPreference)this.projectPreferenceMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(ProjectPreference::getProjectCode, (Object)projectCode));
        Date now = new Date();
        if (Objects.isNull(projectPreference)) {
            projectPreference = new ProjectPreference();
            projectPreference.setProjectCode(projectCode);
            projectPreference.setPreferences(preferences);
            projectPreference.setUserId(loginUser.getId());
            projectPreference.setCode(CodeGenerateUtils.getInstance().genCode());
            projectPreference.setState(1);
            projectPreference.setCreateTime(now);
            projectPreference.setUpdateTime(now);
            if (this.projectPreferenceMapper.insert((Object)projectPreference) > 0) {
                log.info("Project preference is created and id is :{}", (Object)projectPreference.getId());
                result.setData(projectPreference);
                this.putMsg(result, Status.SUCCESS, new Object[0]);
            } else {
                log.error("Project preference create error, projectCode:{}.", (Object)projectPreference.getProjectCode());
                this.putMsg(result, Status.CREATE_PROJECT_PREFERENCE_ERROR, new Object[0]);
            }
        } else {
            projectPreference.setPreferences(preferences);
            projectPreference.setUserId(loginUser.getId());
            projectPreference.setUpdateTime(now);
            if (this.projectPreferenceMapper.updateById((Object)projectPreference) > 0) {
                log.info("Project preference is updated and id is :{}", (Object)projectPreference.getId());
                result.setData(projectPreference);
                this.putMsg(result, Status.SUCCESS, new Object[0]);
            } else {
                log.error("Project preference update error, projectCode:{}.", (Object)projectPreference.getProjectCode());
                this.putMsg(result, Status.UPDATE_PROJECT_PREFERENCE_ERROR, new Object[0]);
            }
        }
        return result;
    }

    @Override
    public Result queryProjectPreferenceByProjectCode(User loginUser, long projectCode) {
        Result<ProjectPreference> result = new Result<ProjectPreference>();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndPerm = this.projectService.hasProjectAndPerm(loginUser, project, result, "project:view");
        if (!hasProjectAndPerm) {
            return result;
        }
        ProjectPreference projectPreference = (ProjectPreference)this.projectPreferenceMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(ProjectPreference::getProjectCode, (Object)projectCode));
        result.setData(projectPreference);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Result enableProjectPreference(User loginUser, long projectCode, int state) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result);
        if (!hasProjectAndWritePerm) {
            return result;
        }
        ProjectPreference projectPreference = (ProjectPreference)this.projectPreferenceMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(ProjectPreference::getProjectCode, (Object)projectCode));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        if (Objects.nonNull(projectPreference) && projectPreference.getState() != state) {
            projectPreference.setState(state);
            projectPreference.setUpdateTime(new Date());
            if (this.projectPreferenceMapper.updateById((Object)projectPreference) > 0) {
                log.info("The state of the project preference is updated and id is :{}", (Object)projectPreference.getId());
            } else {
                log.error("Failed to update the state of the project preference, projectCode:{}.", (Object)projectPreference.getProjectCode());
                this.putMsg(result, Status.UPDATE_PROJECT_PREFERENCE_STATE_ERROR, new Object[0]);
            }
        }
        return result;
    }
}

