/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.task.TaskCreateRequest;
import org.apache.dolphinscheduler.api.dto.task.TaskFilterRequest;
import org.apache.dolphinscheduler.api.dto.task.TaskUpdateRequest;
import org.apache.dolphinscheduler.api.dto.taskRelation.TaskRelationUpdateUpstreamRequest;
import org.apache.dolphinscheduler.api.dto.workflow.WorkflowUpdateRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.permission.PermissionCheck;
import org.apache.dolphinscheduler.api.service.ProcessDefinitionService;
import org.apache.dolphinscheduler.api.service.ProcessTaskRelationService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.TaskDefinitionService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.api.vo.TaskDefinitionVO;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.ConditionType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.TaskExecuteType;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.TaskMainInfo;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.repository.ProcessTaskRelationLogDao;
import org.apache.dolphinscheduler.dao.repository.TaskDefinitionDao;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginManager;
import org.apache.dolphinscheduler.plugin.task.api.parameters.ParametersNode;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskDefinitionServiceImpl
extends BaseServiceImpl
implements TaskDefinitionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskDefinitionServiceImpl.class);
    private static final String RELEASESTATE = "releaseState";
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private TaskDefinitionDao taskDefinitionDao;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private ProcessTaskRelationMapper processTaskRelationMapper;
    @Autowired
    private ProcessTaskRelationLogDao processTaskRelationLogDao;
    @Autowired
    private ProcessTaskRelationService processTaskRelationService;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private ProcessService processService;
    @Autowired
    private TaskPluginManager taskPluginManager;
    @Autowired
    private ProcessDefinitionService processDefinitionService;
    @Autowired
    private ProcessDefinitionLogMapper processDefinitionLogMapper;

    @Override
    @Transactional
    public Map<String, Object> createTaskDefinition(User loginUser, long projectCode, String taskDefinitionJson) {
        HashMap<String, Object> result;
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result = new HashMap<String, Object>());
        if (!hasProjectAndWritePerm) {
            return result;
        }
        List taskDefinitionLogs = JSONUtils.toList((String)taskDefinitionJson, TaskDefinitionLog.class);
        if (CollectionUtils.isEmpty((Collection)taskDefinitionLogs)) {
            log.warn("Parameter taskDefinitionJson is invalid.");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskDefinitionJson);
            return result;
        }
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogs) {
            if (this.taskPluginManager.checkTaskParameters(ParametersNode.builder().taskType(taskDefinitionLog.getTaskType()).taskParams(taskDefinitionLog.getTaskParams()).dependence(taskDefinitionLog.getDependence()).build())) continue;
            log.warn("Task definition {} parameters are invalid.", (Object)taskDefinitionLog.getName());
            this.putMsg(result, Status.PROCESS_NODE_S_PARAMETER_INVALID, taskDefinitionLog.getName());
            return result;
        }
        int saveTaskResult = this.processService.saveTaskDefine(loginUser, projectCode, taskDefinitionLogs, Boolean.TRUE);
        if (saveTaskResult == -1) {
            log.error("Create task definition error, projectCode:{}.", (Object)projectCode);
            this.putMsg(result, Status.CREATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.CREATE_TASK_DEFINITION_ERROR);
        }
        HashMap<String, Object> resData = new HashMap<String, Object>();
        resData.put("total", taskDefinitionLogs.size());
        resData.put("code", StringUtils.join((Iterable)taskDefinitionLogs.stream().map(TaskDefinition::getCode).collect(Collectors.toList()), (String)","));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", resData);
        return result;
    }

    private TaskDefinitionLog persist2TaskDefinitionLog(User user, TaskDefinition taskDefinition) {
        TaskDefinitionLog taskDefinitionLog = new TaskDefinitionLog(taskDefinition);
        taskDefinitionLog.setOperator(user.getId().intValue());
        taskDefinitionLog.setOperateTime(new Date());
        int result = this.taskDefinitionLogMapper.insert((Object)taskDefinitionLog);
        if (result <= 0) {
            throw new ServiceException(Status.CREATE_TASK_DEFINITION_LOG_ERROR, taskDefinitionLog.getName());
        }
        return taskDefinitionLog;
    }

    private void checkTaskDefinitionValid(User user, TaskDefinition taskDefinition, String permissions) {
        Project project = this.projectMapper.queryByCode(taskDefinition.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(user, project, permissions);
        if (!this.taskPluginManager.checkTaskParameters(ParametersNode.builder().taskType(taskDefinition.getTaskType()).taskParams(taskDefinition.getTaskParams()).dependence(taskDefinition.getDependence()).build())) {
            throw new ServiceException(Status.PROCESS_NODE_S_PARAMETER_INVALID, taskDefinition.getName());
        }
    }

    private List<ProcessTaskRelation> updateTaskUpstreams(User user, long workflowCode, long taskCode, String upstreamCodes) {
        TaskRelationUpdateUpstreamRequest taskRelationUpdateUpstreamRequest = new TaskRelationUpdateUpstreamRequest();
        taskRelationUpdateUpstreamRequest.setWorkflowCode(workflowCode);
        if (upstreamCodes != null) {
            taskRelationUpdateUpstreamRequest.setUpstreams(upstreamCodes);
        }
        return this.processTaskRelationService.updateUpstreamTaskDefinitionWithSyncDag(user, taskCode, Boolean.FALSE, taskRelationUpdateUpstreamRequest);
    }

    private ProcessDefinition updateWorkflowLocation(User user, ProcessDefinition processDefinition) {
        WorkflowUpdateRequest workflowUpdateRequest = new WorkflowUpdateRequest();
        workflowUpdateRequest.setLocation(null);
        return this.processDefinitionService.updateSingleProcessDefinition(user, processDefinition.getCode(), workflowUpdateRequest);
    }

    @Override
    @Transactional
    public TaskDefinition createTaskDefinitionV2(User loginUser, TaskCreateRequest taskCreateRequest) {
        long taskDefinitionCode;
        TaskDefinition taskDefinition = taskCreateRequest.convert2TaskDefinition();
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(taskCreateRequest.getWorkflowCode());
        if (processDefinition == null) {
            throw new ServiceException(Status.PROCESS_DEFINE_NOT_EXIST, taskCreateRequest.getWorkflowCode());
        }
        if (taskDefinition.getProjectCode() == 0L) {
            taskDefinition.setProjectCode(processDefinition.getProjectCode());
        }
        this.checkTaskDefinitionValid(loginUser, taskDefinition, "project:task-definition:create");
        try {
            taskDefinitionCode = CodeGenerateUtils.getInstance().genCode();
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            throw new ServiceException(Status.INTERNAL_SERVER_ERROR_ARGS);
        }
        taskDefinition.setCode(taskDefinitionCode);
        int create = this.taskDefinitionMapper.insert((Object)taskDefinition);
        if (create <= 0) {
            throw new ServiceException(Status.CREATE_TASK_DEFINITION_ERROR);
        }
        this.persist2TaskDefinitionLog(loginUser, taskDefinition);
        this.updateTaskUpstreams(loginUser, taskCreateRequest.getWorkflowCode(), taskDefinition.getCode(), taskCreateRequest.getUpstreamTasksCodes());
        this.updateWorkflowLocation(loginUser, processDefinition);
        return taskDefinition;
    }

    @Override
    @Transactional
    public Map<String, Object> createTaskBindsWorkFlow(User loginUser, long projectCode, long processDefinitionCode, String taskDefinitionJsonObj, String upstreamCodes) {
        HashMap<String, Object> result;
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result = new HashMap<String, Object>());
        if (!hasProjectAndWritePerm) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null || projectCode != processDefinition.getProjectCode()) {
            log.error("Process definition does not exist, processDefinitionCode:{}.", (Object)processDefinitionCode);
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, String.valueOf(processDefinitionCode));
            return result;
        }
        if (processDefinition.getReleaseState() == ReleaseState.ONLINE) {
            log.warn("Task definition can not be created due to process definition is {}, processDefinitionCode:{}.", (Object)ReleaseState.ONLINE.getDescp(), (Object)processDefinition.getCode());
            this.putMsg(result, Status.PROCESS_DEFINE_STATE_ONLINE, String.valueOf(processDefinitionCode));
            return result;
        }
        TaskDefinitionLog taskDefinition = (TaskDefinitionLog)JSONUtils.parseObject((String)taskDefinitionJsonObj, TaskDefinitionLog.class);
        if (taskDefinition == null) {
            log.warn("Parameter taskDefinitionJsonObj is invalid json.");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskDefinitionJsonObj);
            return result;
        }
        if (!this.taskPluginManager.checkTaskParameters(ParametersNode.builder().taskType(taskDefinition.getTaskType()).taskParams(taskDefinition.getTaskParams()).dependence(taskDefinition.getDependence()).build())) {
            log.error("Task definition {} parameters are invalid", (Object)taskDefinition.getName());
            this.putMsg(result, Status.PROCESS_NODE_S_PARAMETER_INVALID, taskDefinition.getName());
            return result;
        }
        long taskCode = taskDefinition.getCode();
        if (taskCode == 0L) {
            taskDefinition.setCode(CodeGenerateUtils.getInstance().genCode());
        }
        List processTaskRelationLogList = this.processTaskRelationMapper.queryByProcessCode(processDefinitionCode).stream().map(ProcessTaskRelationLog::new).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)upstreamCodes)) {
            Set upstreamTaskCodes = Arrays.stream(upstreamCodes.split(",")).map(Long::parseLong).collect(Collectors.toSet());
            List upstreamTaskDefinitionList = this.taskDefinitionMapper.queryByCodeList(upstreamTaskCodes);
            Set queryUpStreamTaskCodes = upstreamTaskDefinitionList.stream().map(TaskDefinition::getCode).collect(Collectors.toSet());
            Set diffCode = upstreamTaskCodes.stream().filter(code -> !queryUpStreamTaskCodes.contains(code)).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(diffCode)) {
                String taskCodes = StringUtils.join(diffCode, (String)",");
                log.error("Some task definitions with parameter upstreamCodes do not exist, taskDefinitionCodes:{}.", (Object)taskCodes);
                this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, taskCodes);
                return result;
            }
            for (TaskDefinition upstreamTask : upstreamTaskDefinitionList) {
                ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog();
                processTaskRelationLog.setPreTaskCode(upstreamTask.getCode());
                processTaskRelationLog.setPreTaskVersion(upstreamTask.getVersion());
                processTaskRelationLog.setPostTaskCode(taskCode);
                processTaskRelationLog.setPostTaskVersion(1);
                processTaskRelationLog.setConditionType(ConditionType.NONE);
                processTaskRelationLog.setConditionParams("{}");
                processTaskRelationLogList.add(processTaskRelationLog);
            }
        } else {
            ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog();
            processTaskRelationLog.setPreTaskCode(0L);
            processTaskRelationLog.setPreTaskVersion(0);
            processTaskRelationLog.setPostTaskCode(taskCode);
            processTaskRelationLog.setPostTaskVersion(1);
            processTaskRelationLog.setConditionType(ConditionType.NONE);
            processTaskRelationLog.setConditionParams("{}");
            processTaskRelationLogList.add(processTaskRelationLog);
        }
        int insertResult = this.processService.saveTaskRelation(loginUser, projectCode, processDefinition.getCode(), processDefinition.getVersion(), processTaskRelationLogList, (List)Lists.newArrayList(), Boolean.TRUE);
        if (insertResult != 0) {
            log.error("Save new version process task relations error, processDefinitionCode:{}, processDefinitionVersion:{}.", (Object)processDefinition.getCode(), (Object)processDefinition.getVersion());
            this.putMsg(result, Status.CREATE_PROCESS_TASK_RELATION_ERROR, new Object[0]);
            throw new ServiceException(Status.CREATE_PROCESS_TASK_RELATION_ERROR);
        }
        log.info("Save new version process task relations complete, processDefinitionCode:{}, processDefinitionVersion:{}.", (Object)processDefinition.getCode(), (Object)processDefinition.getVersion());
        int saveTaskResult = this.processService.saveTaskDefine(loginUser, projectCode, (List)Lists.newArrayList((Object[])new TaskDefinitionLog[]{taskDefinition}), Boolean.TRUE);
        if (saveTaskResult == -1) {
            log.error("Save task definition error, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskDefinition.getCode());
            this.putMsg(result, Status.CREATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.CREATE_TASK_DEFINITION_ERROR);
        }
        log.info("Save task definition complete, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskDefinition.getCode());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", taskDefinition);
        return result;
    }

    @Override
    public Map<String, Object> queryTaskDefinitionByName(User loginUser, long projectCode, long processCode, String taskName) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:view");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByName(project.getCode(), processCode, taskName);
        if (taskDefinition == null) {
            log.error("Task definition does not exist, taskName:{}.", (Object)taskName);
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, taskName);
        } else {
            result.put("data", taskDefinition);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    private void taskCanDeleteValid(User user, TaskDefinition taskDefinition, User loginUser) {
        Project project = this.projectMapper.queryByCode(taskDefinition.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(user, project, "project:task-definition:delete");
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result);
        if (!hasProjectAndWritePerm) {
            throw new ServiceException(Status.TASK_DEFINE_STATE_ONLINE, taskDefinition.getCode());
        }
        if (this.processService.isTaskOnline(taskDefinition.getCode()) && taskDefinition.getFlag() == Flag.YES) {
            throw new ServiceException(Status.TASK_DEFINE_STATE_ONLINE, taskDefinition.getCode());
        }
        List processTaskRelationList = this.processTaskRelationMapper.queryDownstreamByTaskCode(taskDefinition.getCode());
        if (CollectionUtils.isNotEmpty((Collection)processTaskRelationList)) {
            Set postTaskCodes = processTaskRelationList.stream().map(ProcessTaskRelation::getPostTaskCode).collect(Collectors.toSet());
            String postTaskCodesStr = StringUtils.join(postTaskCodes, (String)",");
            throw new ServiceException(Status.TASK_HAS_DOWNSTREAM, postTaskCodesStr);
        }
    }

    @Override
    @Transactional
    public void deleteTaskDefinitionByCode(User loginUser, long taskCode) {
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            throw new ServiceException(Status.TASK_DEFINE_NOT_EXIST, taskCode);
        }
        this.taskCanDeleteValid(loginUser, taskDefinition, loginUser);
        int delete = this.taskDefinitionMapper.deleteByCode(taskCode);
        if (delete <= 0) {
            throw new ServiceException(Status.DELETE_TASK_DEFINE_BY_CODE_MSG_ERROR, taskDefinition.getCode());
        }
        List taskRelationList = this.processTaskRelationMapper.queryUpstreamByCode(taskDefinition.getProjectCode(), taskCode);
        if (CollectionUtils.isNotEmpty((Collection)taskRelationList)) {
            log.debug("Task definition has upstream tasks, start handle them after delete task, taskDefinitionCode:{}.", (Object)taskCode);
            long processDefinitionCode = ((ProcessTaskRelation)taskRelationList.get(0)).getProcessDefinitionCode();
            List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(processDefinitionCode);
            List<ProcessTaskRelation> relationList = processTaskRelations.stream().filter(r -> r.getPostTaskCode() != taskCode).collect(Collectors.toList());
            this.updateDag(loginUser, processDefinitionCode, relationList, Lists.newArrayList());
        }
    }

    public void updateDag(User loginUser, long processDefinitionCode, List<ProcessTaskRelation> processTaskRelationList, List<TaskDefinitionLog> taskDefinitionLogs) {
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null) {
            log.error("Process definition does not exist, processDefinitionCode:{}.", (Object)processDefinitionCode);
            throw new ServiceException(Status.PROCESS_DEFINE_NOT_EXIST);
        }
        int insertVersion = this.processService.saveProcessDefine(loginUser, processDefinition, Boolean.TRUE, Boolean.TRUE);
        if (insertVersion <= 0) {
            log.error("Update process definition error, projectCode:{}, processDefinitionCode:{}.", (Object)processDefinition.getProjectCode(), (Object)processDefinitionCode);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        log.info("Save new version process definition complete, projectCode:{}, processDefinitionCode:{}, newVersion:{}.", new Object[]{processDefinition.getProjectCode(), processDefinitionCode, insertVersion});
        List relationLogs = processTaskRelationList.stream().map(ProcessTaskRelationLog::new).collect(Collectors.toList());
        int insertResult = this.processService.saveTaskRelation(loginUser, processDefinition.getProjectCode(), processDefinition.getCode(), insertVersion, relationLogs, taskDefinitionLogs, Boolean.TRUE);
        if (insertResult != 0) {
            log.error("Update task relations error, projectCode:{}, processDefinitionCode:{}.", (Object)processDefinition.getProjectCode(), (Object)processDefinitionCode);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        log.info("Save new version task relations complete, projectCode:{}, processDefinitionCode:{}, newVersion:{}.", new Object[]{processDefinition.getProjectCode(), processDefinitionCode, insertVersion});
    }

    @Override
    @Transactional
    public Map<String, Object> updateTaskDefinition(User loginUser, long projectCode, long taskCode, String taskDefinitionJsonObj) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TaskDefinitionLog taskDefinitionToUpdate = this.updateTask(loginUser, projectCode, taskCode, taskDefinitionJsonObj, result);
        if (taskDefinitionToUpdate == null) {
            return result;
        }
        List taskRelationList = this.processTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
        if (CollectionUtils.isNotEmpty((Collection)taskRelationList)) {
            log.info("Task definition has upstream tasks, start handle them after update task, taskDefinitionCode:{}.", (Object)taskCode);
            long processDefinitionCode = ((ProcessTaskRelation)taskRelationList.get(0)).getProcessDefinitionCode();
            List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(processDefinitionCode);
            this.updateDag(loginUser, processDefinitionCode, processTaskRelations, Lists.newArrayList((Object[])new TaskDefinitionLog[]{taskDefinitionToUpdate}));
        }
        log.info("Update task definition complete, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskCode);
        result.put("data", taskCode);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void TaskDefinitionUpdateValid(TaskDefinition taskDefinitionOriginal, TaskDefinition taskDefinitionUpdate) {
        if (this.processService.isTaskOnline(taskDefinitionOriginal.getCode()) && taskDefinitionOriginal.getFlag() == Flag.YES && taskDefinitionOriginal.getTaskExecuteType() != TaskExecuteType.STREAM) {
            throw new ServiceException(Status.NOT_SUPPORT_UPDATE_TASK_DEFINITION);
        }
        if (taskDefinitionOriginal.equals((Object)taskDefinitionUpdate)) {
            throw new ServiceException(Status.TASK_DEFINITION_NOT_CHANGE, taskDefinitionOriginal.getCode());
        }
        Integer version = this.taskDefinitionLogMapper.queryMaxVersionForDefinition(taskDefinitionOriginal.getCode());
        if (version == null || version == 0) {
            throw new ServiceException(Status.DATA_IS_NOT_VALID, taskDefinitionOriginal.getCode());
        }
    }

    @Override
    @Transactional
    public TaskDefinition updateTaskDefinitionV2(User loginUser, long taskCode, TaskUpdateRequest taskUpdateRequest) {
        TaskDefinition taskDefinitionUpdate;
        TaskDefinition taskDefinitionOriginal = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinitionOriginal == null) {
            throw new ServiceException(Status.TASK_DEFINITION_NOT_EXISTS, taskCode);
        }
        try {
            taskDefinitionUpdate = taskUpdateRequest.mergeIntoTaskDefinition(taskDefinitionOriginal);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ServiceException(Status.REQUEST_PARAMS_NOT_VALID_ERROR, taskUpdateRequest.toString());
        }
        this.checkTaskDefinitionValid(loginUser, taskDefinitionUpdate, "project:task-definition:edit");
        this.TaskDefinitionUpdateValid(taskDefinitionOriginal, taskDefinitionUpdate);
        int update = this.taskDefinitionMapper.updateById((Object)taskDefinitionUpdate);
        if (update <= 0) {
            throw new ServiceException(Status.UPDATE_TASK_DEFINITION_ERROR);
        }
        TaskDefinitionLog taskDefinitionLog = this.persist2TaskDefinitionLog(loginUser, taskDefinitionUpdate);
        List taskRelationList = this.processTaskRelationMapper.queryUpstreamByCode(taskDefinitionUpdate.getProjectCode(), taskCode);
        if (CollectionUtils.isNotEmpty((Collection)taskRelationList)) {
            log.info("Task definition has upstream tasks, start handle them after update task, taskDefinitionCode:{}.", (Object)taskCode);
            long processDefinitionCode = ((ProcessTaskRelation)taskRelationList.get(0)).getProcessDefinitionCode();
            List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(processDefinitionCode);
            this.updateDag(loginUser, processDefinitionCode, processTaskRelations, Lists.newArrayList((Object[])new TaskDefinitionLog[]{taskDefinitionLog}));
        }
        this.updateTaskUpstreams(loginUser, taskUpdateRequest.getWorkflowCode(), taskDefinitionUpdate.getCode(), taskUpdateRequest.getUpstreamTasksCodes());
        return taskDefinitionUpdate;
    }

    @Override
    public TaskDefinition getTaskDefinition(User loginUser, long taskCode) {
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            throw new ServiceException(Status.TASK_DEFINE_NOT_EXIST, taskCode);
        }
        Project project = this.projectMapper.queryByCode(taskDefinition.getProjectCode());
        this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:task-definition:view");
        return taskDefinition;
    }

    @Override
    public PageInfo<TaskDefinition> filterTaskDefinition(User loginUser, TaskFilterRequest taskFilterRequest) {
        TaskDefinition taskDefinition = taskFilterRequest.convert2TaskDefinition();
        if (taskDefinition.getProjectName() != null) {
            Project project = this.projectMapper.queryByName(taskDefinition.getProjectName());
            this.projectService.checkProjectAndAuthThrowException(loginUser, project, "project:definition:list");
            taskDefinition.setProjectCode(project.getCode());
        }
        Page page = new Page((long)taskFilterRequest.getPageNo().intValue(), (long)taskFilterRequest.getPageSize().intValue());
        IPage taskDefinitionIPage = this.taskDefinitionMapper.filterTaskDefinition((IPage)page, taskDefinition);
        PageInfo<TaskDefinition> pageInfo = new PageInfo<TaskDefinition>(taskFilterRequest.getPageNo(), taskFilterRequest.getPageSize());
        pageInfo.setTotal((int)taskDefinitionIPage.getTotal());
        pageInfo.setTotalList(taskDefinitionIPage.getRecords());
        return pageInfo;
    }

    private TaskDefinitionLog updateTask(User loginUser, long projectCode, long taskCode, String taskDefinitionJsonObj, Map<String, Object> result) {
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result);
        if (!hasProjectAndWritePerm) {
            return null;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            log.error("Task definition does not exist, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
            return null;
        }
        if (this.processService.isTaskOnline(taskCode) && taskDefinition.getFlag() == Flag.YES && taskDefinition.getTaskExecuteType() != TaskExecuteType.STREAM) {
            log.warn("Only {} type task can be updated without online check, taskDefinitionCode:{}.", (Object)TaskExecuteType.STREAM, (Object)taskCode);
            this.putMsg(result, Status.NOT_SUPPORT_UPDATE_TASK_DEFINITION, new Object[0]);
            return null;
        }
        TaskDefinitionLog taskDefinitionToUpdate = (TaskDefinitionLog)JSONUtils.parseObject((String)taskDefinitionJsonObj, TaskDefinitionLog.class);
        if (TimeoutFlag.CLOSE == taskDefinition.getTimeoutFlag()) {
            taskDefinition.setTimeoutNotifyStrategy(null);
        }
        if (taskDefinition.equals((Object)taskDefinitionToUpdate)) {
            log.warn("Task definition does not need update because no change, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.TASK_DEFINITION_NOT_MODIFY_ERROR, String.valueOf(taskCode));
            return null;
        }
        if (taskDefinitionToUpdate == null) {
            log.warn("Parameter taskDefinitionJson is invalid.");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskDefinitionJsonObj);
            return null;
        }
        if (!this.taskPluginManager.checkTaskParameters(ParametersNode.builder().taskType(taskDefinitionToUpdate.getTaskType()).taskParams(taskDefinitionToUpdate.getTaskParams()).dependence(taskDefinitionToUpdate.getDependence()).build())) {
            log.warn("Task definition parameters are invalid, taskDefinitionName:{}.", (Object)taskDefinitionToUpdate.getName());
            this.putMsg(result, Status.PROCESS_NODE_S_PARAMETER_INVALID, taskDefinitionToUpdate.getName());
            return null;
        }
        Integer version = this.taskDefinitionLogMapper.queryMaxVersionForDefinition(taskCode);
        if (version == null || version == 0) {
            log.error("Max version task definitionLog can not be found in database, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskCode);
            return null;
        }
        Date now = new Date();
        taskDefinitionToUpdate.setCode(taskCode);
        taskDefinitionToUpdate.setId(taskDefinition.getId());
        taskDefinitionToUpdate.setProjectCode(projectCode);
        taskDefinitionToUpdate.setUserId(taskDefinition.getUserId());
        version = version + 1;
        taskDefinitionToUpdate.setVersion(version.intValue());
        taskDefinitionToUpdate.setTaskType(taskDefinitionToUpdate.getTaskType().toUpperCase());
        taskDefinitionToUpdate.setResourceIds(this.processService.getResourceIds((TaskDefinition)taskDefinitionToUpdate));
        taskDefinitionToUpdate.setUpdateTime(now);
        int update = this.taskDefinitionMapper.updateById((Object)taskDefinitionToUpdate);
        taskDefinitionToUpdate.setOperator(loginUser.getId().intValue());
        taskDefinitionToUpdate.setOperateTime(now);
        taskDefinitionToUpdate.setCreateTime(now);
        taskDefinitionToUpdate.setId(null);
        int insert = this.taskDefinitionLogMapper.insert((Object)taskDefinitionToUpdate);
        if ((update & insert) != 1) {
            log.error("Update task definition or definitionLog error, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskCode);
            this.putMsg(result, Status.UPDATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_TASK_DEFINITION_ERROR);
        }
        log.info("Update task definition and definitionLog complete, projectCode:{}, taskDefinitionCode:{}, newTaskVersion:{}.", new Object[]{projectCode, taskCode, taskDefinitionToUpdate.getVersion()});
        List processTaskRelations = this.processTaskRelationMapper.queryProcessTaskRelationByTaskCodeAndTaskVersion(taskDefinitionToUpdate.getCode(), (long)taskDefinition.getVersion());
        if (CollectionUtils.isNotEmpty((Collection)processTaskRelations)) {
            Map<Long, List<ProcessTaskRelation>> processTaskRelationGroupList = processTaskRelations.stream().collect(Collectors.groupingBy(ProcessTaskRelation::getProcessDefinitionCode));
            for (Map.Entry<Long, List<ProcessTaskRelation>> processTaskRelationMap : processTaskRelationGroupList.entrySet()) {
                Long processDefinitionCode = processTaskRelationMap.getKey();
                int processDefinitionVersion = this.processDefinitionLogMapper.queryMaxVersionForDefinition(processDefinitionCode.longValue()) + 1;
                List<ProcessTaskRelation> processTaskRelationList = processTaskRelationMap.getValue();
                for (ProcessTaskRelation processTaskRelation : processTaskRelationList) {
                    if (taskCode == processTaskRelation.getPreTaskCode()) {
                        processTaskRelation.setPreTaskVersion(version.intValue());
                    } else if (taskCode == processTaskRelation.getPostTaskCode()) {
                        processTaskRelation.setPostTaskVersion(version.intValue());
                    }
                    processTaskRelation.setProcessDefinitionVersion(processDefinitionVersion);
                    int updateProcessDefinitionVersionCount = this.processTaskRelationMapper.updateProcessTaskRelationTaskVersion(processTaskRelation);
                    if (updateProcessDefinitionVersionCount != 1) {
                        log.error("batch update process task relation error, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskCode);
                        this.putMsg(result, Status.PROCESS_TASK_RELATION_BATCH_UPDATE_ERROR, new Object[0]);
                        throw new ServiceException(Status.PROCESS_TASK_RELATION_BATCH_UPDATE_ERROR);
                    }
                    ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog(processTaskRelation);
                    processTaskRelationLog.setOperator(loginUser.getId().intValue());
                    processTaskRelationLog.setId(null);
                    processTaskRelationLog.setOperateTime(now);
                    int insertProcessTaskRelationLogCount = this.processTaskRelationLogDao.insert((Object)processTaskRelationLog);
                    if (insertProcessTaskRelationLogCount == 1) continue;
                    log.error("batch update process task relation error, projectCode:{}, taskDefinitionCode:{}.", (Object)projectCode, (Object)taskCode);
                    this.putMsg(result, Status.CREATE_PROCESS_TASK_RELATION_LOG_ERROR, new Object[0]);
                    throw new ServiceException(Status.CREATE_PROCESS_TASK_RELATION_LOG_ERROR);
                }
                ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode.longValue());
                processDefinition.setVersion(processDefinitionVersion);
                processDefinition.setUpdateTime(now);
                processDefinition.setUserId(loginUser.getId().intValue());
                int updateProcessDefinitionCount = this.processDefinitionMapper.updateById(processDefinition);
                ProcessDefinitionLog processDefinitionLog = new ProcessDefinitionLog(processDefinition);
                processDefinitionLog.setOperateTime(now);
                processDefinitionLog.setId(null);
                processDefinitionLog.setOperator(loginUser.getId().intValue());
                int insertProcessDefinitionLogCount = this.processDefinitionLogMapper.insert((Object)processDefinitionLog);
                if ((updateProcessDefinitionCount & insertProcessDefinitionLogCount) == 1) continue;
                this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
                throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
            }
        }
        return taskDefinitionToUpdate;
    }

    @Override
    public Map<String, Object> updateTaskWithUpstream(User loginUser, long projectCode, long taskCode, String taskDefinitionJsonObj, String upstreamCodes) {
        Map<Object, Object> queryUpStreamTaskCodeMap;
        HashMap<String, Object> result = new HashMap<String, Object>();
        TaskDefinitionLog taskDefinitionToUpdate = this.updateTask(loginUser, projectCode, taskCode, taskDefinitionJsonObj, result);
        List upstreamTaskRelations = this.processTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
        Set upstreamCodeSet = upstreamTaskRelations.stream().map(ProcessTaskRelation::getPreTaskCode).collect(Collectors.toSet());
        Set upstreamTaskCodes = Collections.emptySet();
        if (StringUtils.isNotEmpty((CharSequence)upstreamCodes)) {
            upstreamTaskCodes = Arrays.stream(upstreamCodes.split(",")).map(Long::parseLong).collect(Collectors.toSet());
        }
        if (CollectionUtils.isEqualCollection(upstreamCodeSet, upstreamTaskCodes) && taskDefinitionToUpdate == null) {
            this.putMsg(result, Status.SUCCESS, new Object[0]);
            return result;
        }
        if (CollectionUtils.isNotEmpty(upstreamTaskCodes)) {
            List upstreamTaskDefinitionList = this.taskDefinitionMapper.queryByCodeList(upstreamTaskCodes);
            queryUpStreamTaskCodeMap = upstreamTaskDefinitionList.stream().collect(Collectors.toMap(TaskDefinition::getCode, taskDefinition -> taskDefinition));
            upstreamTaskCodes.removeAll(queryUpStreamTaskCodeMap.keySet());
            if (CollectionUtils.isNotEmpty(upstreamTaskCodes)) {
                String notExistTaskCodes = StringUtils.join(upstreamTaskCodes, (String)",");
                log.error("Some task definitions in parameter upstreamTaskCodes do not exist, notExistTaskCodes:{}.", (Object)notExistTaskCodes);
                this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, notExistTaskCodes);
                return result;
            }
        } else {
            queryUpStreamTaskCodeMap = new HashMap();
        }
        if (MapUtils.isNotEmpty(queryUpStreamTaskCodeMap)) {
            ProcessTaskRelation taskRelation = (ProcessTaskRelation)upstreamTaskRelations.get(0);
            List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(taskRelation.getProcessDefinitionCode());
            this.updateUpstreamTask(new HashSet<Object>(queryUpStreamTaskCodeMap.keySet()), taskCode, projectCode, taskRelation.getProcessDefinitionCode(), loginUser);
            ArrayList processTaskRelationList = Lists.newArrayList((Iterable)processTaskRelations);
            ArrayList relationList = Lists.newArrayList();
            for (ProcessTaskRelation processTaskRelation : processTaskRelationList) {
                if (processTaskRelation.getPostTaskCode() != taskCode) continue;
                if (queryUpStreamTaskCodeMap.containsKey(processTaskRelation.getPreTaskCode()) && processTaskRelation.getPreTaskCode() != 0L) {
                    queryUpStreamTaskCodeMap.remove(processTaskRelation.getPreTaskCode());
                    continue;
                }
                processTaskRelation.setPreTaskCode(0L);
                processTaskRelation.setPreTaskVersion(0);
                relationList.add(processTaskRelation);
            }
            processTaskRelationList.removeAll(relationList);
            for (Map.Entry entry : queryUpStreamTaskCodeMap.entrySet()) {
                taskRelation.setPreTaskCode(((Long)entry.getKey()).longValue());
                taskRelation.setPreTaskVersion(((TaskDefinition)entry.getValue()).getVersion());
                processTaskRelationList.add(taskRelation);
            }
            if (MapUtils.isEmpty(queryUpStreamTaskCodeMap) && CollectionUtils.isNotEmpty((Collection)processTaskRelationList)) {
                processTaskRelationList.add(processTaskRelationList.get(0));
            }
        }
        log.info("Update task with upstream tasks complete, projectCode:{}, taskDefinitionCode:{}, upstreamTaskCodes:{}.", new Object[]{projectCode, taskCode, upstreamTaskCodes});
        result.put("data", taskCode);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void updateUpstreamTask(Set<Long> allPreTaskCodeSet, long taskCode, long projectCode, long processDefinitionCode, User loginUser) {
        List hadProcessTaskRelationList = this.processTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
        HashSet<Long> removePreTaskSet = new HashSet<Long>();
        ArrayList<ProcessTaskRelation> removePreTaskList = new ArrayList<ProcessTaskRelation>();
        HashSet<Long> addPreTaskSet = new HashSet<Long>();
        ArrayList<ProcessTaskRelation> addPreTaskList = new ArrayList<ProcessTaskRelation>();
        ArrayList<ProcessTaskRelationLog> processTaskRelationLogList = new ArrayList<ProcessTaskRelationLog>();
        if (CollectionUtils.isNotEmpty((Collection)hadProcessTaskRelationList)) {
            for (ProcessTaskRelation processTaskRelation : hadProcessTaskRelationList) {
                if (processTaskRelation.getPreTaskCode() == 0L) continue;
                if (allPreTaskCodeSet.contains(processTaskRelation.getPreTaskCode())) {
                    allPreTaskCodeSet.remove(processTaskRelation.getPreTaskCode());
                    continue;
                }
                removePreTaskSet.add(processTaskRelation.getPreTaskCode());
                processTaskRelation.setPreTaskCode(0L);
                processTaskRelation.setPreTaskVersion(0);
                removePreTaskList.add(processTaskRelation);
                processTaskRelationLogList.add(this.createProcessTaskRelationLog(loginUser, processTaskRelation));
            }
        }
        if (allPreTaskCodeSet.size() != 0) {
            addPreTaskSet.addAll(allPreTaskCodeSet);
        }
        allPreTaskCodeSet.add(taskCode);
        List taskDefinitionList = this.taskDefinitionMapper.queryByCodeList(allPreTaskCodeSet);
        Map taskCodeMap = taskDefinitionList.stream().collect(Collectors.toMap(TaskDefinition::getCode, Function.identity(), (a, b) -> a));
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        TaskDefinition taskDefinition = (TaskDefinition)taskCodeMap.get(taskCode);
        for (Long preTaskCode : addPreTaskSet) {
            TaskDefinition preTaskRelation = (TaskDefinition)taskCodeMap.get(preTaskCode);
            ProcessTaskRelation processTaskRelation = new ProcessTaskRelation(null, processDefinition.getVersion(), projectCode, processDefinition.getCode(), preTaskRelation.getCode(), preTaskRelation.getVersion(), taskDefinition.getCode(), taskDefinition.getVersion(), ConditionType.NONE, "{}");
            addPreTaskList.add(processTaskRelation);
            processTaskRelationLogList.add(this.createProcessTaskRelationLog(loginUser, processTaskRelation));
        }
        int insert = 0;
        int remove = 0;
        int log = 0;
        if (CollectionUtils.isNotEmpty(addPreTaskList)) {
            insert = this.processTaskRelationMapper.batchInsert(addPreTaskList);
        }
        if (CollectionUtils.isNotEmpty(removePreTaskList)) {
            for (ProcessTaskRelation processTaskRelation : removePreTaskList) {
                remove += this.processTaskRelationMapper.updateById(processTaskRelation);
            }
        }
        if (CollectionUtils.isNotEmpty(processTaskRelationLogList)) {
            log = this.processTaskRelationLogDao.batchInsert(processTaskRelationLogList);
        }
        if (insert + remove != log) {
            throw new RuntimeException("updateUpstreamTask error");
        }
    }

    private ProcessTaskRelationLog createProcessTaskRelationLog(User loginUser, ProcessTaskRelation processTaskRelation) {
        Date now = new Date();
        ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog(processTaskRelation);
        processTaskRelationLog.setOperator(loginUser.getId().intValue());
        processTaskRelationLog.setOperateTime(now);
        processTaskRelationLog.setCreateTime(now);
        processTaskRelationLog.setUpdateTime(now);
        return processTaskRelationLog;
    }

    @Override
    @Transactional
    public Map<String, Object> switchVersion(User loginUser, long projectCode, long taskCode, int version) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:definition:version:switch");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (this.processService.isTaskOnline(taskCode)) {
            log.warn("Task definition version can not be switched due to process definition is {}, taskDefinitionCode:{}.", (Object)ReleaseState.ONLINE.getDescp(), (Object)taskCode);
            this.putMsg(result, Status.PROCESS_DEFINE_STATE_ONLINE, new Object[0]);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null || projectCode != taskDefinition.getProjectCode()) {
            log.error("Task definition does not exist, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
            return result;
        }
        TaskDefinitionLog taskDefinitionUpdate = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskCode, version);
        taskDefinitionUpdate.setUserId(loginUser.getId().intValue());
        taskDefinitionUpdate.setUpdateTime(new Date());
        taskDefinitionUpdate.setId(taskDefinition.getId());
        int switchVersion = this.taskDefinitionMapper.updateById((Object)taskDefinitionUpdate);
        if (switchVersion > 0) {
            List taskRelationList = this.processTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
            if (CollectionUtils.isNotEmpty((Collection)taskRelationList)) {
                log.info("Task definition has upstream tasks, start handle them after switch task, taskDefinitionCode:{}.", (Object)taskCode);
                long processDefinitionCode = ((ProcessTaskRelation)taskRelationList.get(0)).getProcessDefinitionCode();
                List processTaskRelations = this.processTaskRelationMapper.queryByProcessCode(processDefinitionCode);
                this.updateDag(loginUser, processDefinitionCode, processTaskRelations, Lists.newArrayList((Object[])new TaskDefinitionLog[]{taskDefinitionUpdate}));
            } else {
                log.info("Task definition version switch complete, switch task version to {}, taskDefinitionCode:{}.", (Object)version, (Object)taskCode);
                this.putMsg(result, Status.SUCCESS, new Object[0]);
            }
        } else {
            log.error("Task definition version switch error, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.SWITCH_TASK_DEFINITION_VERSION_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Result queryTaskDefinitionVersions(User loginUser, long projectCode, long taskCode, int pageNo, int pageSize) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:version");
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            this.putMsg(result, resultStatus, new Object[0]);
            return result;
        }
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage taskDefinitionVersionsPaging = this.taskDefinitionLogMapper.queryTaskDefinitionVersionsPaging(page, taskCode, projectCode);
        List taskDefinitionLogs = taskDefinitionVersionsPaging.getRecords();
        pageInfo.setTotalList(taskDefinitionLogs);
        pageInfo.setTotal((int)taskDefinitionVersionsPaging.getTotal());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> deleteByCodeAndVersion(User loginUser, long projectCode, long taskCode, int version) {
        HashMap<String, Object> result;
        Project project = this.projectMapper.queryByCode(projectCode);
        boolean hasProjectAndWritePerm = this.projectService.hasProjectAndWritePerm(loginUser, project, result = new HashMap<String, Object>());
        if (!hasProjectAndWritePerm) {
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            log.error("Task definition does not exist, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
        } else {
            if (taskDefinition.getVersion() == version) {
                log.warn("Task definition can not be deleted due to version is being used, projectCode:{}, taskDefinitionCode:{}, version:{}.", new Object[]{projectCode, taskCode, version});
                this.putMsg(result, Status.MAIN_TABLE_USING_VERSION, new Object[0]);
                return result;
            }
            int delete = this.taskDefinitionLogMapper.deleteByCodeAndVersion(taskCode, version);
            if (delete > 0) {
                log.info("Task definition version delete complete, projectCode:{}, taskDefinitionCode:{}, version:{}.", new Object[]{projectCode, taskCode, version});
                this.putMsg(result, Status.SUCCESS, new Object[0]);
            } else {
                log.error("Task definition version delete error, projectCode:{}, taskDefinitionCode:{}, version:{}.", new Object[]{projectCode, taskCode, version});
                this.putMsg(result, Status.DELETE_TASK_DEFINITION_VERSION_ERROR, new Object[0]);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> queryTaskDefinitionDetail(User loginUser, long projectCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:view");
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null || projectCode != taskDefinition.getProjectCode()) {
            log.error("Task definition does not exist, taskDefinitionCode:{}.", (Object)taskCode);
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(taskCode));
        } else {
            List taskRelationList = this.processTaskRelationMapper.queryByCode(projectCode, 0L, 0L, taskCode);
            if (CollectionUtils.isNotEmpty((Collection)taskRelationList)) {
                taskRelationList = taskRelationList.stream().filter(v -> v.getPreTaskCode() != 0L).collect(Collectors.toList());
            }
            TaskDefinitionVO taskDefinitionVo = TaskDefinitionVO.fromTaskDefinition(taskDefinition);
            taskDefinitionVo.setProcessTaskRelationList(taskRelationList);
            result.put("data", (Object)taskDefinitionVo);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Result queryTaskDefinitionListPaging(User loginUser, long projectCode, String searchTaskName, String taskType, TaskExecuteType taskExecuteType, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, "project:task-definition:view");
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            this.putMsg(result, resultStatus, new Object[0]);
            return result;
        }
        taskType = taskType == null ? "" : taskType;
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage taskMainInfoIPage = this.taskDefinitionMapper.queryDefineListPaging((IPage)page, projectCode, searchTaskName, taskType, taskExecuteType);
        this.fillRecords(projectCode, (IPage<TaskMainInfo>)taskMainInfoIPage);
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal((int)taskMainInfoIPage.getTotal());
        pageInfo.setTotalList(taskMainInfoIPage.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void fillRecords(long projectCode, IPage<TaskMainInfo> taskMainInfoIPage) {
        List records = Collections.emptyList();
        if (CollectionUtils.isNotEmpty((Collection)taskMainInfoIPage.getRecords())) {
            records = this.taskDefinitionMapper.queryDefineListByCodeList(projectCode, taskMainInfoIPage.getRecords().stream().map(TaskMainInfo::getTaskCode).collect(Collectors.toList()));
        }
        taskMainInfoIPage.setRecords(Collections.emptyList());
        if (CollectionUtils.isNotEmpty(records)) {
            HashMap<Long, TaskMainInfo> taskMainInfoMap = new HashMap<Long, TaskMainInfo>();
            for (TaskMainInfo info : records) {
                taskMainInfoMap.compute(info.getTaskCode(), (k, v) -> {
                    if (v == null) {
                        HashMap<Long, String> upstreamTaskMap = new HashMap<Long, String>();
                        if (info.getUpstreamTaskCode() != 0L) {
                            upstreamTaskMap.put(info.getUpstreamTaskCode(), info.getUpstreamTaskName());
                            info.setUpstreamTaskCode(0L);
                            info.setUpstreamTaskName("");
                        }
                        info.setUpstreamTaskMap(upstreamTaskMap);
                        v = info;
                    }
                    if (info.getUpstreamTaskCode() != 0L) {
                        v.getUpstreamTaskMap().put(info.getUpstreamTaskCode(), info.getUpstreamTaskName());
                    }
                    return v;
                });
            }
            ArrayList resultRecords = Lists.newArrayList(taskMainInfoMap.values());
            resultRecords.sort((o1, o2) -> o2.getTaskUpdateTime().compareTo(o1.getTaskUpdateTime()));
            taskMainInfoIPage.setRecords((List)resultRecords);
        }
    }

    private void fillWorkflowInfo(long projectCode, IPage<TaskMainInfo> taskMainInfoIPage) {
    }

    @Override
    public Map<String, Object> genTaskCodeList(Integer genNum) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (genNum == null || genNum < 1 || genNum > 100) {
            log.warn("Parameter genNum must be great than 1 and less than 100.");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, genNum);
            return result;
        }
        ArrayList<Long> taskCodes = new ArrayList<Long>();
        try {
            for (int i = 0; i < genNum; ++i) {
                taskCodes.add(CodeGenerateUtils.getInstance().genCode());
            }
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            log.error("Generate task definition code error.", (Throwable)e);
            this.putMsg(result, Status.INTERNAL_SERVER_ERROR_ARGS, "Error generating task definition code");
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", taskCodes);
        return result;
    }

    @Override
    @Transactional
    public Map<String, Object> releaseTaskDefinition(User loginUser, long projectCode, long code, ReleaseState releaseState) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode, null);
        Status resultStatus = (Status)((Object)result.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return result;
        }
        if (null == releaseState) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, RELEASESTATE);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(code);
        if (taskDefinition == null || projectCode != taskDefinition.getProjectCode()) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(code));
            return result;
        }
        TaskDefinitionLog taskDefinitionLog = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(code, taskDefinition.getVersion());
        if (taskDefinitionLog == null) {
            log.error("Task definition does not exist, taskDefinitionCode:{}.", (Object)code);
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, String.valueOf(code));
            return result;
        }
        switch (releaseState) {
            case OFFLINE: {
                taskDefinition.setFlag(Flag.NO);
                taskDefinitionLog.setFlag(Flag.NO);
                break;
            }
            case ONLINE: {
                String resourceIds = taskDefinition.getResourceIds();
                if (StringUtils.isNotBlank((CharSequence)resourceIds)) {
                    Integer[] resourceIdArray = (Integer[])Arrays.stream(resourceIds.split(",")).map(Integer::parseInt).toArray(Integer[]::new);
                    PermissionCheck<Integer> permissionCheck = new PermissionCheck<Integer>(AuthorizationType.RESOURCE_FILE_ID, this.processService, resourceIdArray, (int)loginUser.getId(), log);
                    try {
                        permissionCheck.checkPermission();
                    }
                    catch (Exception e) {
                        log.error("Resources permission check error, resourceIds:{}.", (Object)resourceIds, (Object)e);
                        this.putMsg(result, Status.RESOURCE_NOT_EXIST_OR_NO_PERMISSION, new Object[0]);
                        return result;
                    }
                }
                taskDefinition.setFlag(Flag.YES);
                taskDefinitionLog.setFlag(Flag.YES);
                break;
            }
            default: {
                log.warn("Parameter releaseState is invalid.");
                this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, RELEASESTATE);
                return result;
            }
        }
        int update = this.taskDefinitionMapper.updateById((Object)taskDefinition);
        int updateLog = this.taskDefinitionLogMapper.updateById(taskDefinitionLog);
        if (update == 0 && updateLog == 1 || update == 1 && updateLog == 0) {
            log.error("Update taskDefinition state or taskDefinitionLog state error, taskDefinitionCode:{}.", (Object)code);
            this.putMsg(result, Status.UPDATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_TASK_DEFINITION_ERROR);
        }
        log.error("Update taskDefinition state or taskDefinitionLog state to complete, taskDefinitionCode:{}.", (Object)code);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public void deleteTaskByWorkflowDefinitionCode(long workflowDefinitionCode, int workflowDefinitionVersion) {
        List<ProcessTaskRelation> processTaskRelations = this.processTaskRelationService.queryByWorkflowDefinitionCode(workflowDefinitionCode, workflowDefinitionVersion);
        if (CollectionUtils.isEmpty(processTaskRelations)) {
            return;
        }
        HashSet<Long> needToDeleteTaskDefinitionCodes = new HashSet<Long>();
        for (ProcessTaskRelation processTaskRelation : processTaskRelations) {
            needToDeleteTaskDefinitionCodes.add(processTaskRelation.getPreTaskCode());
            needToDeleteTaskDefinitionCodes.add(processTaskRelation.getPostTaskCode());
        }
        this.taskDefinitionDao.deleteByTaskDefinitionCodes(needToDeleteTaskDefinitionCodes);
        this.processTaskRelationService.deleteByWorkflowDefinitionCode(workflowDefinitionCode, workflowDefinitionVersion);
    }
}

