/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.service.TaskGroupQueueService;
import org.apache.dolphinscheduler.api.service.TaskGroupService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.TaskGroup;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectUserMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskGroupMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskGroupServiceImpl
extends BaseServiceImpl
implements TaskGroupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskGroupServiceImpl.class);
    @Autowired
    private TaskGroupMapper taskGroupMapper;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectUserMapper projectUserMapper;
    @Autowired
    private TaskGroupQueueService taskGroupQueueService;
    @Autowired
    private ExecutorService executorService;

    @Override
    @Transactional
    public Map<String, Object> createTaskGroup(User loginUser, Long projectCode, String name, String description, int groupSize) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.hasProjectPerm(loginUser, projectCode, result, true)) {
            return result;
        }
        if (this.checkDescriptionLength(description)) {
            log.warn("Parameter description is too long.");
            this.putMsg(result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        if (name == null) {
            log.warn("Parameter name can ot be null.");
            this.putMsg(result, Status.NAME_NULL, new Object[0]);
            return result;
        }
        if (groupSize <= 0) {
            log.warn("Parameter task group size is must bigger than 1.");
            this.putMsg(result, Status.TASK_GROUP_SIZE_ERROR, new Object[0]);
            return result;
        }
        TaskGroup taskGroup1 = this.taskGroupMapper.queryByName(loginUser.getId().intValue(), name);
        if (taskGroup1 != null) {
            log.warn("Task group with the same name already exists, taskGroupName:{}.", (Object)taskGroup1.getName());
            this.putMsg(result, Status.TASK_GROUP_NAME_EXSIT, new Object[0]);
            return result;
        }
        Date now = new Date();
        TaskGroup taskGroup = TaskGroup.builder().name(name).projectCode(projectCode.longValue()).description(description).groupSize(groupSize).userId(loginUser.getId().intValue()).status(Flag.YES).createTime(now).updateTime(now).build();
        if (this.taskGroupMapper.insert((Object)taskGroup) <= 0) {
            log.error("Create task group error, taskGroupName:{}.", (Object)taskGroup.getName());
            this.putMsg(result, Status.CREATE_TASK_GROUP_ERROR, new Object[0]);
            return result;
        }
        log.info("Create task group complete, taskGroupName:{}.", (Object)taskGroup.getName());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> updateTaskGroup(User loginUser, int id, String name, String description, int groupSize) {
        int i;
        HashMap<String, Object> result = new HashMap<String, Object>();
        TaskGroup taskGroup = (TaskGroup)this.taskGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (!this.hasProjectPerm(loginUser, taskGroup.getProjectCode(), result, true)) {
            return result;
        }
        if (this.checkDescriptionLength(description)) {
            log.warn("Parameter description is too long.");
            this.putMsg(result, Status.DESCRIPTION_TOO_LONG_ERROR, new Object[0]);
            return result;
        }
        if (name == null) {
            log.warn("Parameter name can ot be null.");
            this.putMsg(result, Status.NAME_NULL, new Object[0]);
            return result;
        }
        if (groupSize <= 0) {
            log.warn("Parameter task group size is must bigger than 1.");
            this.putMsg(result, Status.TASK_GROUP_SIZE_ERROR, new Object[0]);
            return result;
        }
        Long exists = this.taskGroupMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(TaskGroup::getName, (Object)name)).eq(TaskGroup::getUserId, (Object)loginUser.getId())).ne(TaskGroup::getId, (Object)id));
        if (exists > 0L) {
            log.error("Task group with the same name already exists.");
            this.putMsg(result, Status.TASK_GROUP_NAME_EXSIT, new Object[0]);
            return result;
        }
        if (taskGroup.getStatus() != Flag.YES) {
            log.warn("Task group has been closed, taskGroupId:{}.", (Object)id);
            this.putMsg(result, Status.TASK_GROUP_STATUS_ERROR, new Object[0]);
            return result;
        }
        taskGroup.setGroupSize(groupSize);
        taskGroup.setDescription(description);
        taskGroup.setUpdateTime(new Date());
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            taskGroup.setName(name);
        }
        if ((i = this.taskGroupMapper.updateById((Object)taskGroup)) > 0) {
            log.info("Update task group complete, taskGroupId:{}.", (Object)id);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            log.error("Update task group error, taskGroupId:{}.", (Object)id);
            this.putMsg(result, Status.UPDATE_TASK_GROUP_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Object> queryAllTaskGroup(User loginUser, String name, Integer status, int pageNo, int pageSize) {
        return this.doQuery(loginUser, pageNo, pageSize, loginUser.getId(), name, status);
    }

    @Override
    public Map<String, Object> queryTaskGroupByStatus(User loginUser, int pageNo, int pageSize, int status) {
        return this.doQuery(loginUser, pageNo, pageSize, loginUser.getId(), null, status);
    }

    @Override
    public Map<String, Object> queryTaskGroupByProjectCode(User loginUser, int pageNo, int pageSize, Long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.hasProjectPerm(loginUser, projectCode, result, false)) {
            return result;
        }
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage taskGroupPaging = this.taskGroupMapper.queryTaskGroupPagingByProjectCode(page, projectCode);
        return this.getStringObjectMap(pageNo, pageSize, result, (IPage<TaskGroup>)taskGroupPaging);
    }

    private Map<String, Object> getStringObjectMap(int pageNo, int pageSize, Map<String, Object> result, IPage<TaskGroup> taskGroupPaging) {
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        int total = taskGroupPaging == null ? 0 : (int)taskGroupPaging.getTotal();
        List list = taskGroupPaging == null ? new ArrayList() : taskGroupPaging.getRecords();
        pageInfo.setTotal(total);
        pageInfo.setTotalList(list);
        result.put("data", pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryTaskGroupById(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TaskGroup taskGroup = (TaskGroup)this.taskGroupMapper.selectById((Serializable)Integer.valueOf(id));
        result.put("data", taskGroup);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> doQuery(User loginUser, int pageNo, int pageSize, int userId, String name, Integer status) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage taskGroupPaging = this.taskGroupMapper.queryTaskGroupPaging((IPage)page, name, status);
        return this.getStringObjectMap(pageNo, pageSize, result, (IPage<TaskGroup>)taskGroupPaging);
    }

    @Override
    public Map<String, Object> closeTaskGroup(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean canOperatorPermissions = this.canOperatorPermissions(loginUser, null, AuthorizationType.TASK_GROUP, "resources:task-group:close");
        if (!canOperatorPermissions) {
            this.putMsg(result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        TaskGroup taskGroup = (TaskGroup)this.taskGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (taskGroup.getStatus() == Flag.NO) {
            log.info("Task group has been closed, taskGroupId:{}.", (Object)id);
            this.putMsg(result, Status.TASK_GROUP_STATUS_CLOSED, new Object[0]);
            return result;
        }
        taskGroup.setStatus(Flag.NO);
        int update = this.taskGroupMapper.updateById((Object)taskGroup);
        if (update > 0) {
            log.info("Task group close complete, taskGroupId:{}.", (Object)id);
        } else {
            log.error("Task group close error, taskGroupId:{}.", (Object)id);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> startTaskGroup(User loginUser, int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean canOperatorPermissions = this.canOperatorPermissions(loginUser, null, AuthorizationType.TASK_GROUP, "resources:task-group:close");
        if (!canOperatorPermissions) {
            this.putMsg(result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        TaskGroup taskGroup = (TaskGroup)this.taskGroupMapper.selectById((Serializable)Integer.valueOf(id));
        if (taskGroup.getStatus() == Flag.YES) {
            log.info("Task group has been started, taskGroupId:{}.", (Object)id);
            this.putMsg(result, Status.TASK_GROUP_STATUS_OPENED, new Object[0]);
            return result;
        }
        taskGroup.setStatus(Flag.YES);
        taskGroup.setUpdateTime(new Date(System.currentTimeMillis()));
        int update = this.taskGroupMapper.updateById((Object)taskGroup);
        if (update > 0) {
            log.info("Task group start complete, taskGroupId:{}.", (Object)id);
        } else {
            log.error("Task group start error, taskGroupId:{}.", (Object)id);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> forceStartTask(User loginUser, int queueId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean canOperatorPermissions = this.canOperatorPermissions(loginUser, null, AuthorizationType.TASK_GROUP, "resources:task-group-queue:start");
        if (!canOperatorPermissions) {
            this.putMsg(result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        return this.executorService.forceStartTaskInstance(loginUser, queueId);
    }

    @Override
    public Map<String, Object> modifyPriority(User loginUser, Integer queueId, Integer priority) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean canOperatorPermissions = this.canOperatorPermissions(loginUser, null, AuthorizationType.TASK_GROUP, "resources:task-group-queue:priority");
        if (!canOperatorPermissions) {
            this.putMsg(result, Status.NO_CURRENT_OPERATING_PERMISSION, new Object[0]);
            return result;
        }
        this.taskGroupQueueService.modifyPriority(queueId, priority);
        log.info("Modify task group queue priority complete, queueId:{}, priority:{}.", (Object)queueId, (Object)priority);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public void deleteTaskGroupByProjectCode(long projectCode) {
        List taskGroups = this.taskGroupMapper.selectByProjectCode(projectCode);
        if (CollectionUtils.isEmpty((Collection)taskGroups)) {
            return;
        }
        List<Integer> taskGroupIds = taskGroups.stream().map(TaskGroup::getId).collect(Collectors.toList());
        this.taskGroupQueueService.deleteByTaskGroupIds(taskGroupIds);
        this.taskGroupMapper.deleteBatchIds(taskGroupIds);
    }

    private boolean hasProjectPerm(User loginUser, long projectCode, Map<String, Object> result, boolean writePermission) {
        Project project = this.projectMapper.queryByCode(projectCode);
        if (project == null) {
            log.warn("Project does not exist");
            this.putMsg(result, Status.PROJECT_NOT_FOUND, "");
        }
        if (loginUser.getUserType() == UserType.ADMIN_USER) {
            return true;
        }
        if (project.getUserId().equals(loginUser.getId())) {
            return true;
        }
        ProjectUser projectUser = this.projectUserMapper.queryProjectRelation(project.getId().intValue(), loginUser.getId().intValue());
        if (projectUser == null) {
            log.warn("User {} does not have operation permission for project {}", (Object)loginUser.getUserName(), (Object)project.getCode());
            this.putMsg(result, Status.USER_NO_OPERATION_PROJECT_PERM, loginUser.getUserName(), project.getCode());
            return false;
        }
        if (writePermission && projectUser.getPerm() != 7) {
            log.warn("User {} does not have write permission for project {}", (Object)loginUser.getUserName(), (Object)project.getCode());
            this.putMsg(result, Status.USER_NO_WRITE_PROJECT_PERM, loginUser.getUserName(), project.getCode());
            return false;
        }
        return true;
    }
}

