/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.log.remote;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogHandler;
import org.apache.dolphinscheduler.common.log.remote.RemoteLogUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsRemoteLogHandler
implements RemoteLogHandler,
Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GcsRemoteLogHandler.class);
    private Storage gcsStorage;
    private String bucketName;
    private String credential;
    private static GcsRemoteLogHandler instance;

    private GcsRemoteLogHandler() {
    }

    public static synchronized GcsRemoteLogHandler getInstance() {
        if (instance == null) {
            instance = new GcsRemoteLogHandler();
            instance.init();
        }
        return instance;
    }

    public void init() {
        try {
            this.credential = this.readCredentials();
            this.bucketName = this.readBucketName();
            this.gcsStorage = this.buildGcsStorage(this.credential);
            this.checkBucketNameExists(this.bucketName);
        }
        catch (IOException e) {
            log.error("GCS Remote Log Handler init failed", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.gcsStorage != null) {
                this.gcsStorage.close();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void sendRemoteLog(String logPath) {
        String objectName = RemoteLogUtils.getObjectNameFromLogPath(logPath);
        try {
            log.info("send remote log {} to GCS {}", (Object)logPath, (Object)objectName);
            BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)BlobId.of((String)this.bucketName, (String)objectName)).build();
            this.gcsStorage.create(blobInfo, Files.readAllBytes(Paths.get(logPath, new String[0])), new Storage.BlobTargetOption[0]);
        }
        catch (Exception e) {
            log.error("error while sending remote log {} to GCS {}", new Object[]{logPath, objectName, e});
        }
    }

    @Override
    public void getRemoteLog(String logPath) {
        String objectName = RemoteLogUtils.getObjectNameFromLogPath(logPath);
        try {
            log.info("get remote log on GCS {} to {}", (Object)objectName, (Object)logPath);
            Blob blob = this.gcsStorage.get(BlobId.of((String)this.bucketName, (String)objectName));
            blob.downloadTo(Paths.get(logPath, new String[0]));
        }
        catch (Exception e) {
            log.error("error while getting remote log on GCS {} to {}", new Object[]{objectName, logPath, e});
        }
    }

    protected Storage buildGcsStorage(String credential) throws IOException {
        return (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)Files.newInputStream(Paths.get(credential, new String[0]), new OpenOption[0])))).build().getService();
    }

    protected String readCredentials() {
        return PropertyUtils.getString("remote.logging.google.cloud.storage.credential");
    }

    protected String readBucketName() {
        return PropertyUtils.getString("remote.logging.google.cloud.storage.bucket.name");
    }

    public void checkBucketNameExists(String bucketName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("remote.logging.google.cloud.storage.bucket.name is blank");
        }
        boolean exist = false;
        for (Bucket bucket : this.gcsStorage.list(new Storage.BucketListOption[0]).iterateAll()) {
            if (!bucketName.equals(bucket.getName())) continue;
            exist = true;
            break;
        }
        if (!exist) {
            log.error("bucketName: {} does not exist, you need to create them by yourself", (Object)bucketName);
        } else {
            log.info("bucketName: {} has been found", (Object)bucketName);
        }
    }
}

