/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.dolphinscheduler.common.shell.ShellExecutor;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;

public final class OSUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OSUtils.class);
    private static final SystemInfo SI = new SystemInfo();
    private static final HardwareAbstractionLayer hal = SI.getHardware();
    private static final Pattern PATTERN = Pattern.compile("\\s+");

    public static long getTotalSystemMemory() {
        return hal.getMemory().getTotal();
    }

    public static long getSystemAvailableMemoryUsed() {
        return hal.getMemory().getAvailable();
    }

    public static List<String> getUserList() {
        try {
            if (SystemUtils.IS_OS_MAC) {
                return OSUtils.getUserListFromMac();
            }
            if (SystemUtils.IS_OS_WINDOWS) {
                return OSUtils.getUserListFromWindows();
            }
            return OSUtils.getUserListFromLinux();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<String> getUserListFromLinux() throws IOException {
        ArrayList<String> userList = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("/etc/passwd")));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (!line.contains(":")) continue;
                String[] userInfo = line.split(":");
                userList.add(userInfo[0]);
            }
        }
        return userList;
    }

    private static List<String> getUserListFromMac() throws IOException {
        String result = OSUtils.exeCmd("dscl . list /users");
        if (!StringUtils.isEmpty((CharSequence)result)) {
            return Arrays.asList(result.split("\n"));
        }
        return Collections.emptyList();
    }

    private static List<String> getUserListFromWindows() throws IOException {
        String result = OSUtils.exeCmd("net user");
        String[] lines = result.split("\n");
        int startPos = 0;
        int endPos = lines.length - 2;
        for (int i = 0; i < lines.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)lines[i])) continue;
            int count = 0;
            if (lines[i].charAt(0) == '-') {
                for (int j = 0; j < lines[i].length(); ++j) {
                    if (lines[i].charAt(i) != '-') continue;
                    ++count;
                }
            }
            if (count != lines[i].length()) continue;
            startPos = i + 1;
            break;
        }
        ArrayList<String> users = new ArrayList<String>();
        while (startPos <= endPos) {
            users.addAll(Arrays.asList(PATTERN.split(lines[startPos])));
            ++startPos;
        }
        return users;
    }

    public static boolean existTenantCodeInLinux(String tenantCode) {
        try {
            String result = OSUtils.exeCmd("id " + tenantCode);
            if (!StringUtils.isEmpty((CharSequence)result)) {
                return result.contains("uid=");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static void createUserIfAbsent(String userName) {
        if (!OSUtils.getUserList().contains(userName)) {
            boolean isSuccess = OSUtils.createUser(userName);
            log.info("create user {} {}", (Object)userName, (Object)(isSuccess ? "success" : "fail"));
        }
    }

    public static boolean createUser(String userName) {
        try {
            String userGroup = OSUtils.getGroup();
            if (StringUtils.isEmpty((CharSequence)userGroup)) {
                String errorLog = String.format("%s group does not exist for this operating system.", userGroup);
                log.error(errorLog);
                return false;
            }
            if (SystemUtils.IS_OS_MAC) {
                OSUtils.createMacUser(userName, userGroup);
            } else if (SystemUtils.IS_OS_WINDOWS) {
                OSUtils.createWindowsUser(userName, userGroup);
            } else {
                OSUtils.createLinuxUser(userName, userGroup);
            }
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static void createLinuxUser(String userName, String userGroup) throws IOException {
        log.info("create linux os user: {}", (Object)userName);
        String cmd = String.format("sudo useradd -g %s %s", userGroup, userName);
        log.info("execute cmd: {}", (Object)cmd);
        OSUtils.exeCmd(cmd);
    }

    private static void createMacUser(String userName, String userGroup) throws IOException {
        log.info("create mac os user: {}", (Object)userName);
        String createUserCmd = String.format("sudo sysadminctl -addUser %s -password %s", userName, userName);
        log.info("create user command: {}", (Object)createUserCmd);
        OSUtils.exeCmd(createUserCmd);
        String appendGroupCmd = String.format("sudo dseditgroup -o edit -a %s -t user %s", userName, userGroup);
        log.info("append user to group: {}", (Object)appendGroupCmd);
        OSUtils.exeCmd(appendGroupCmd);
    }

    private static void createWindowsUser(String userName, String userGroup) throws IOException {
        log.info("create windows os user: {}", (Object)userName);
        String userCreateCmd = String.format("net user \"%s\" /add", userName);
        log.info("execute create user command: {}", (Object)userCreateCmd);
        OSUtils.exeCmd(userCreateCmd);
        String appendGroupCmd = String.format("net localgroup \"%s\" \"%s\" /add", userGroup, userName);
        log.info("execute append user to group: {}", (Object)appendGroupCmd);
        OSUtils.exeCmd(appendGroupCmd);
    }

    public static String getGroup() throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            String currentProcUserName = System.getProperty("user.name");
            String result = OSUtils.exeCmd(String.format("net user \"%s\"", currentProcUserName));
            String line = result.split("\n")[22];
            String group = PATTERN.split(line)[1];
            if (group.charAt(0) == '*') {
                return group.substring(1);
            }
            return group;
        }
        String result = OSUtils.exeCmd("groups");
        if (!StringUtils.isEmpty((CharSequence)result)) {
            String[] groupInfo = result.split(" ");
            return groupInfo[0];
        }
        return null;
    }

    public static String getSudoCmd(String tenantCode, String command) {
        if (!OSUtils.isSudoEnable() || StringUtils.isEmpty((CharSequence)tenantCode)) {
            return command;
        }
        return String.format("sudo -u %s %s", tenantCode, command);
    }

    public static boolean isSudoEnable() {
        return PropertyUtils.getBoolean("sudo.enable", true);
    }

    public static String exeCmd(String command) throws IOException {
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdArray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArray[i] = st.nextToken();
            ++i;
        }
        return OSUtils.exeShell(cmdArray);
    }

    public static String exeShell(String[] command) throws IOException {
        return ShellExecutor.execCommand(command);
    }

    public static int getProcessID() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return Integer.parseInt(runtimeMXBean.getName().split("@")[0]);
    }

    public static Boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    @Generated
    private OSUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

