/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.dao.mapper.PluginDefineMapper;
import org.apache.dolphinscheduler.plugin.task.api.TaskPluginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginDao.class);
    @Autowired
    private PluginDefineMapper pluginDefineMapper;

    public boolean checkPluginDefineTableExist() {
        return this.pluginDefineMapper.checkTableExist() > 0;
    }

    public int addOrUpdatePluginDefine(@NonNull PluginDefine pluginDefine) {
        PluginDefine currPluginDefine;
        block7: {
            if (pluginDefine == null) {
                throw new NullPointerException("pluginDefine is marked non-null but is null");
            }
            Objects.requireNonNull(pluginDefine.getPluginName(), "pluginName is null");
            Objects.requireNonNull(pluginDefine.getPluginType(), "pluginType is null");
            currPluginDefine = this.pluginDefineMapper.queryByNameAndType(pluginDefine.getPluginName(), pluginDefine.getPluginType());
            if (currPluginDefine == null) {
                try {
                    if (this.pluginDefineMapper.insert(pluginDefine) == 1 && pluginDefine.getId() != null) {
                        return pluginDefine.getId();
                    }
                    throw new TaskPluginException(String.format("Failed to insert plugin definition, pluginName: %s, pluginType: %s", pluginDefine.getPluginName(), pluginDefine.getPluginType()));
                }
                catch (TaskPluginException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    log.error("Insert plugin definition error, there may already exist a plugin", (Throwable)ex);
                    currPluginDefine = this.pluginDefineMapper.queryByNameAndType(pluginDefine.getPluginName(), pluginDefine.getPluginType());
                    if (currPluginDefine != null) break block7;
                    throw new TaskPluginException(String.format("Failed to insert plugin definition, pluginName: %s, pluginType: %s", pluginDefine.getPluginName(), pluginDefine.getPluginType()));
                }
            }
        }
        if (!Objects.equals(currPluginDefine.getPluginParams(), pluginDefine.getPluginParams())) {
            currPluginDefine.setUpdateTime(pluginDefine.getUpdateTime());
            currPluginDefine.setPluginParams(pluginDefine.getPluginParams());
            this.pluginDefineMapper.updateById(currPluginDefine);
        }
        return currPluginDefine.getId();
    }

    public PluginDefine getPluginDefineById(int pluginDefineId) {
        return (PluginDefine)this.pluginDefineMapper.selectById(Integer.valueOf(pluginDefineId));
    }
}

