/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.utils;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperate;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCacheUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskCacheUtils.class);
    public static final String MERGE_TAG = "-";

    private TaskCacheUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String generateCacheKey(TaskInstance taskInstance, TaskExecutionContext taskExecutionContext, StorageOperate storageOperate) {
        ArrayList<String> keyElements = new ArrayList<String>();
        keyElements.add(String.valueOf(taskInstance.getTaskCode()));
        keyElements.add(String.valueOf(taskInstance.getTaskDefinitionVersion()));
        keyElements.add(String.valueOf(taskInstance.getIsCache().getCode()));
        keyElements.add(String.valueOf(taskInstance.getEnvironmentConfig()));
        keyElements.add(TaskCacheUtils.getTaskInputVarPoolData(taskInstance, taskExecutionContext, storageOperate));
        String data = StringUtils.join(keyElements, (String)"_");
        return DigestUtils.sha256Hex((String)data);
    }

    public static String generateTagCacheKey(Integer sourceTaskId, String cacheKey) {
        return sourceTaskId + MERGE_TAG + cacheKey;
    }

    public static Pair<Integer, String> revertCacheKey(String tagCacheKey) {
        if (tagCacheKey == null) {
            Pair taskIdAndCacheKey = Pair.of((Object)-1, (Object)"");
            return taskIdAndCacheKey;
        }
        if (tagCacheKey.contains(MERGE_TAG)) {
            String[] split = tagCacheKey.split(MERGE_TAG);
            Pair taskIdAndCacheKey = split.length == 2 ? Pair.of((Object)Integer.parseInt(split[0]), (Object)split[1]) : Pair.of((Object)-1, (Object)"");
            return taskIdAndCacheKey;
        }
        return Pair.of((Object)-1, (Object)tagCacheKey);
    }

    public static String getTaskInputVarPoolData(TaskInstance taskInstance, TaskExecutionContext context, StorageOperate storageOperate) {
        ObjectNode taskParams = JSONUtils.parseObject((String)taskInstance.getTaskParams());
        Set propertyInSet = JSONUtils.toList((String)taskParams.get("localParams").toString(), Property.class).stream().filter(property -> property.getDirect().equals((Object)Direct.IN)).map(Property::getProp).collect(Collectors.toSet());
        propertyInSet.addAll(TaskCacheUtils.getScriptVarInSet(taskInstance));
        List<Property> varPool = JSONUtils.toList((String)taskInstance.getVarPool(), Property.class);
        HashMap fileCheckSumMap = new HashMap();
        List<Property> fileInput = varPool.stream().filter(property -> property.getType().equals((Object)DataType.FILE)).collect(Collectors.toList());
        fileInput.forEach(property -> fileCheckSumMap.put(property.getProp(), TaskCacheUtils.getValCheckSum(property, context, storageOperate)));
        if (context.getPrepareParamsMap() != null) {
            Set taskVarPoolSet = varPool.stream().map(Property::getProp).collect(Collectors.toSet());
            List globalContextVarPool = context.getPrepareParamsMap().entrySet().stream().filter(entry -> !taskVarPoolSet.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            varPool.addAll(globalContextVarPool);
        }
        varPool = varPool.stream().filter(property -> property.getDirect().equals((Object)Direct.IN)).filter(property -> propertyInSet.contains(property.getProp())).sorted(Comparator.comparing(Property::getProp)).collect(Collectors.toList());
        varPool.forEach(property -> {
            if (property.getType() == DataType.FILE) {
                property.setValue((String)fileCheckSumMap.get(property.getValue()));
            }
        });
        return JSONUtils.toJsonString(varPool);
    }

    public static String getValCheckSum(Property fileProperty, TaskExecutionContext context, StorageOperate storageOperate) {
        String resourceCRCPath = fileProperty.getValue() + ".crc";
        String resourceCRCWholePath = storageOperate.getResourceFullName(context.getTenantCode(), resourceCRCPath);
        String targetPath = String.format("%s/%s", context.getExecutePath(), resourceCRCPath);
        log.info("{} --- Remote:{} to Local:{}", new Object[]{"CRC file", resourceCRCWholePath, targetPath});
        String crcString = "";
        try {
            storageOperate.download(resourceCRCWholePath, targetPath, true);
            crcString = FileUtils.readFile2Str((InputStream)new FileInputStream(targetPath));
            fileProperty.setValue(crcString);
        }
        catch (IOException e) {
            log.error("Replace checksum failed for file property {}.", (Object)fileProperty.getProp());
        }
        return crcString;
    }

    public static List<String> getScriptVarInSet(TaskInstance taskInstance) {
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(taskInstance.getTaskParams());
        ArrayList<String> varInSet = new ArrayList<String>();
        while (matcher.find()) {
            varInSet.add(matcher.group(1));
        }
        return varInSet;
    }
}

