/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.data.quality.execution;

import org.apache.dolphinscheduler.data.quality.config.Config;
import org.apache.dolphinscheduler.data.quality.execution.SparkBatchExecution;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class SparkRuntimeEnvironment {
    private static final String TYPE = "type";
    private static final String BATCH = "batch";
    private SparkSession sparkSession;
    private Config config = new Config();

    public SparkRuntimeEnvironment(Config config) {
        if (config != null) {
            this.config = config;
        }
        this.prepare();
    }

    public Config getConfig() {
        return this.config;
    }

    public void prepare() {
        this.sparkSession = SparkSession.builder().config(this.createSparkConf()).enableHiveSupport().getOrCreate();
    }

    private SparkConf createSparkConf() {
        SparkConf conf = new SparkConf();
        this.config.entrySet().forEach(entry -> conf.set((String)entry.getKey(), String.valueOf(entry.getValue())));
        conf.set("spark.sql.crossJoin.enabled", "true");
        return conf;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public boolean isBatch() {
        return BATCH.equalsIgnoreCase(this.config.getString(TYPE));
    }

    public SparkBatchExecution getBatchExecution() {
        return new SparkBatchExecution(this);
    }
}

