/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.data.quality.flow.batch.writer.file;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dolphinscheduler.data.quality.config.Config;
import org.apache.dolphinscheduler.data.quality.config.ValidateResult;
import org.apache.dolphinscheduler.data.quality.execution.SparkRuntimeEnvironment;
import org.apache.dolphinscheduler.data.quality.flow.batch.BatchWriter;
import org.apache.dolphinscheduler.data.quality.utils.ConfigUtils;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public abstract class BaseFileWriter
implements BatchWriter {
    public static final String PARTITION_BY = "partition_by";
    public static final String SERIALIZER = "serializer";
    public static final String PATH = "path";
    private final Config config;

    protected BaseFileWriter(Config config) {
        this.config = config;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public void prepare(SparkRuntimeEnvironment prepareEnv) {
        HashMap<String, Object> defaultConfig = new HashMap<String, Object>();
        defaultConfig.put(PARTITION_BY, Collections.emptyList());
        defaultConfig.put("save_mode", "error");
        defaultConfig.put(SERIALIZER, "csv");
        this.config.merge(defaultConfig);
    }

    protected ValidateResult checkConfigImpl(List<String> allowedUri) {
        if (Boolean.TRUE.equals(this.config.has(PATH)) && !Strings.isNullOrEmpty((String)this.config.getString(PATH))) {
            String dir = this.config.getString(PATH);
            if (dir.startsWith("/") || this.uriInAllowedSchema(dir, allowedUri)) {
                return new ValidateResult(true, "");
            }
            return new ValidateResult(false, "invalid path URI, please set the following allowed schemas: " + String.join((CharSequence)",", allowedUri));
        }
        return new ValidateResult(false, "please specify [path] as non-empty string");
    }

    protected boolean uriInAllowedSchema(String uri, List<String> allowedUri) {
        return allowedUri.stream().map(uri::startsWith).reduce(true, (a, b) -> a != false && b != false);
    }

    protected String buildPathWithDefaultSchema(String uri, String defaultUriSchema) {
        return uri.startsWith("/") ? defaultUriSchema + uri : uri;
    }

    protected void outputImpl(Dataset<Row> df, String defaultUriSchema) {
        Config fileConfig;
        DataFrameWriter writer = df.write().mode(this.config.getString("save_mode"));
        if (CollectionUtils.isNotEmpty(this.config.getStringList(PARTITION_BY))) {
            List<String> partitionKeys = this.config.getStringList(PARTITION_BY);
            writer.partitionBy(partitionKeys.toArray(new String[0]));
        }
        if ((fileConfig = ConfigUtils.extractSubConfig(this.config, "options.", false)).isNotEmpty()) {
            HashMap optionMap = new HashMap(16);
            fileConfig.entrySet().forEach(x -> optionMap.put(x.getKey(), String.valueOf(x.getValue())));
            writer.options(optionMap);
        }
        String path = this.buildPathWithDefaultSchema(this.config.getString(PATH), defaultUriSchema);
        switch (this.config.getString(SERIALIZER)) {
            case "csv": {
                writer.csv(path);
                break;
            }
            case "json": {
                writer.json(path);
                break;
            }
            case "parquet": {
                writer.parquet(path);
                break;
            }
            case "text": {
                writer.text(path);
                break;
            }
            case "orc": {
                writer.orc(path);
                break;
            }
        }
    }
}

