/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.data.quality.flow.batch.reader;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.dolphinscheduler.data.quality.config.Config;
import org.apache.dolphinscheduler.data.quality.config.ValidateResult;
import org.apache.dolphinscheduler.data.quality.execution.SparkRuntimeEnvironment;
import org.apache.dolphinscheduler.data.quality.flow.batch.BatchReader;
import org.apache.dolphinscheduler.data.quality.utils.ConfigUtils;
import org.apache.dolphinscheduler.data.quality.utils.ParserUtils;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class JdbcReader
implements BatchReader {
    private final Config config;

    public JdbcReader(Config config) {
        this.config = config;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public ValidateResult validateConfig() {
        return this.validate(Arrays.asList("url", "table", "user", "password"));
    }

    @Override
    public void prepare(SparkRuntimeEnvironment prepareEnv) {
    }

    @Override
    public Dataset<Row> read(SparkRuntimeEnvironment env) {
        return this.jdbcReader(env.sparkSession()).load();
    }

    private DataFrameReader jdbcReader(SparkSession sparkSession) {
        DataFrameReader reader = sparkSession.read().format("jdbc").option("url", this.config.getString("url")).option("dbtable", this.config.getString("database") + "." + this.config.getString("table")).option("user", this.config.getString("user")).option("password", ParserUtils.decode(this.config.getString("password"))).option("driver", this.config.getString("driver"));
        Config jdbcConfig = ConfigUtils.extractSubConfig(this.config, "jdbc.", false);
        if (!this.config.isEmpty()) {
            HashMap optionMap = new HashMap(16);
            jdbcConfig.entrySet().forEach(x -> optionMap.put(x.getKey(), String.valueOf(x.getValue())));
            reader.options(optionMap);
        }
        return reader;
    }
}

