/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.data.quality.flow.batch.reader;

import java.util.ArrayList;
import java.util.List;
import org.apache.dolphinscheduler.data.quality.config.Config;
import org.apache.dolphinscheduler.data.quality.config.ReaderConfig;
import org.apache.dolphinscheduler.data.quality.enums.ReaderType;
import org.apache.dolphinscheduler.data.quality.exception.DataQualityException;
import org.apache.dolphinscheduler.data.quality.execution.SparkRuntimeEnvironment;
import org.apache.dolphinscheduler.data.quality.flow.batch.BatchReader;
import org.apache.dolphinscheduler.data.quality.flow.batch.reader.HiveReader;
import org.apache.dolphinscheduler.data.quality.flow.batch.reader.JdbcReader;

public class ReaderFactory {
    public static ReaderFactory getInstance() {
        return Singleton.instance;
    }

    public List<BatchReader> getReaders(SparkRuntimeEnvironment sparkRuntimeEnvironment, List<ReaderConfig> readerConfigs) throws DataQualityException {
        ArrayList<BatchReader> readerList = new ArrayList<BatchReader>();
        for (ReaderConfig readerConfig : readerConfigs) {
            BatchReader reader = this.getReader(readerConfig);
            if (reader == null) continue;
            reader.validateConfig();
            reader.prepare(sparkRuntimeEnvironment);
            readerList.add(reader);
        }
        return readerList;
    }

    private BatchReader getReader(ReaderConfig readerConfig) throws DataQualityException {
        ReaderType readerType = ReaderType.getType(readerConfig.getType());
        Config config = new Config(readerConfig.getConfig());
        if (readerType != null) {
            switch (readerType) {
                case JDBC: {
                    return new JdbcReader(config);
                }
                case HIVE: {
                    return new HiveReader(config);
                }
            }
            throw new DataQualityException("reader type " + (Object)((Object)readerType) + " is not supported!");
        }
        return null;
    }

    private static class Singleton {
        static ReaderFactory instance = new ReaderFactory();

        private Singleton() {
        }
    }
}

