/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.data.quality.flow.batch.writer;

import com.google.common.base.Strings;
import java.util.Arrays;
import org.apache.dolphinscheduler.data.quality.config.Config;
import org.apache.dolphinscheduler.data.quality.config.ValidateResult;
import org.apache.dolphinscheduler.data.quality.execution.SparkRuntimeEnvironment;
import org.apache.dolphinscheduler.data.quality.flow.batch.BatchWriter;
import org.apache.dolphinscheduler.data.quality.utils.ParserUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class JdbcWriter
implements BatchWriter {
    private final Config config;

    public JdbcWriter(Config config) {
        this.config = config;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public ValidateResult validateConfig() {
        return this.validate(Arrays.asList("url", "table", "user", "password"));
    }

    @Override
    public void prepare(SparkRuntimeEnvironment prepareEnv) {
        if (Strings.isNullOrEmpty((String)this.config.getString("save_mode"))) {
            this.config.put("save_mode", "append");
        }
    }

    @Override
    public void write(Dataset<Row> data, SparkRuntimeEnvironment env) {
        if (!Strings.isNullOrEmpty((String)this.config.getString("sql"))) {
            data = env.sparkSession().sql(this.config.getString("sql"));
        }
        data.write().format("jdbc").option("driver", this.config.getString("driver")).option("url", this.config.getString("url")).option("dbtable", this.config.getString("database") + "." + this.config.getString("table")).option("user", this.config.getString("user")).option("password", ParserUtils.decode(this.config.getString("password"))).mode(this.config.getString("save_mode")).save();
    }
}

