/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.data.quality.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Strings;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).setTimeZone(TimeZone.getDefault()).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    private JsonUtils() {
        throw new UnsupportedOperationException("Construct JSONUtils");
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        if (Strings.isNullOrEmpty((String)json)) {
            return null;
        }
        try {
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (Exception e) {
            log.error("parse object exception!", (Throwable)e);
            return null;
        }
    }
}

