/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.datasource.hive;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDatasourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.hive.HiveConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.hive.HiveDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.CommonUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;

public class HiveDatasourceProcessor
extends AbstractDatasourceProcessor {
    @Override
    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        String[] hostPortArray;
        HiveDataSourceParamDTO hiveDataSourceParamDTO = new HiveDataSourceParamDTO();
        HiveConnectionParam hiveConnectionParam = (HiveConnectionParam)this.createConnectionParams(connectionJson);
        hiveDataSourceParamDTO.setDatabase(hiveConnectionParam.getDatabase());
        hiveDataSourceParamDTO.setUserName(hiveConnectionParam.getUser());
        hiveDataSourceParamDTO.setOther(this.parseOther(hiveConnectionParam.getOther()));
        hiveDataSourceParamDTO.setLoginUserKeytabUsername(hiveConnectionParam.getLoginUserKeytabUsername());
        hiveDataSourceParamDTO.setLoginUserKeytabPath(hiveConnectionParam.getLoginUserKeytabPath());
        hiveDataSourceParamDTO.setJavaSecurityKrb5Conf(hiveConnectionParam.getJavaSecurityKrb5Conf());
        String[] tmpArray = hiveConnectionParam.getAddress().split("//");
        StringBuilder hosts = new StringBuilder();
        for (String hostPort : hostPortArray = tmpArray[tmpArray.length - 1].split(",")) {
            hosts.append(hostPort.split(":")[0]).append(",");
        }
        hosts.deleteCharAt(hosts.length() - 1);
        hiveDataSourceParamDTO.setHost(hosts.toString());
        hiveDataSourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        return hiveDataSourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        HiveDataSourceParamDTO hiveParam = (HiveDataSourceParamDTO)datasourceParam;
        StringBuilder address = new StringBuilder();
        address.append("jdbc:hive2://");
        for (String zkHost : hiveParam.getHost().split(",")) {
            address.append(String.format("%s:%s,", zkHost, hiveParam.getPort()));
        }
        address.deleteCharAt(address.length() - 1);
        String jdbcUrl = address.toString() + "/" + hiveParam.getDatabase();
        HiveConnectionParam hiveConnectionParam = new HiveConnectionParam();
        hiveConnectionParam.setDatabase(hiveParam.getDatabase());
        hiveConnectionParam.setAddress(address.toString());
        hiveConnectionParam.setJdbcUrl(jdbcUrl);
        hiveConnectionParam.setUser(hiveParam.getUserName());
        hiveConnectionParam.setPassword(PasswordUtils.encodePassword(hiveParam.getPassword()));
        hiveConnectionParam.setDriverClassName(this.getDatasourceDriver());
        hiveConnectionParam.setValidationQuery(this.getValidationQuery());
        if (CommonUtils.getKerberosStartupState()) {
            hiveConnectionParam.setPrincipal(hiveParam.getPrincipal());
            hiveConnectionParam.setJavaSecurityKrb5Conf(hiveParam.getJavaSecurityKrb5Conf());
            hiveConnectionParam.setLoginUserKeytabPath(hiveParam.getLoginUserKeytabPath());
            hiveConnectionParam.setLoginUserKeytabUsername(hiveParam.getLoginUserKeytabUsername());
        }
        hiveConnectionParam.setOther(this.transformOther(hiveParam.getOther()));
        hiveConnectionParam.setProps(hiveParam.getOther());
        return hiveConnectionParam;
    }

    @Override
    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, HiveConnectionParam.class);
    }

    @Override
    public String getDatasourceDriver() {
        return "org.apache.hive.jdbc.HiveDriver";
    }

    @Override
    public String getValidationQuery() {
        return "select 1";
    }

    @Override
    public String getJdbcUrl(ConnectionParam connectionParam) {
        HiveConnectionParam hiveConnectionParam = (HiveConnectionParam)connectionParam;
        String jdbcUrl = hiveConnectionParam.getJdbcUrl();
        String otherParams = this.filterOther(hiveConnectionParam.getOther());
        if (StringUtils.isNotEmpty((CharSequence)otherParams) && !"?".equals(otherParams.substring(0, 1))) {
            jdbcUrl = jdbcUrl + ";";
        }
        return jdbcUrl + otherParams;
    }

    @Override
    public Connection getConnection(ConnectionParam connectionParam) throws IOException, ClassNotFoundException, SQLException {
        HiveConnectionParam hiveConnectionParam = (HiveConnectionParam)connectionParam;
        CommonUtils.loadKerberosConf(hiveConnectionParam.getJavaSecurityKrb5Conf(), hiveConnectionParam.getLoginUserKeytabUsername(), hiveConnectionParam.getLoginUserKeytabPath());
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), hiveConnectionParam.getUser(), PasswordUtils.decodePassword(hiveConnectionParam.getPassword()));
    }

    @Override
    public DbType getDbType() {
        return DbType.HIVE;
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        otherMap.forEach((key, value) -> stringBuilder.append(String.format("%s=%s;", key, value)));
        return stringBuilder.toString();
    }

    private String filterOther(String otherParams) {
        String[] otherArray;
        if (StringUtils.isBlank((CharSequence)otherParams)) {
            return "";
        }
        StringBuilder hiveConfListSb = new StringBuilder();
        hiveConfListSb.append("?");
        StringBuilder sessionVarListSb = new StringBuilder();
        for (String conf : otherArray = otherParams.split(";", -1)) {
            sessionVarListSb.append(conf).append(";");
        }
        if (sessionVarListSb.length() > 0) {
            sessionVarListSb.deleteCharAt(sessionVarListSb.length() - 1);
        }
        if (hiveConfListSb.length() > 0) {
            hiveConfListSb.deleteCharAt(hiveConfListSb.length() - 1);
        }
        return sessionVarListSb.toString() + hiveConfListSb.toString();
    }

    private Map<String, String> parseOther(String other) {
        String[] configs;
        if (other == null) {
            return null;
        }
        LinkedHashMap<String, String> otherMap = new LinkedHashMap<String, String>();
        for (String config : configs = other.split(";")) {
            otherMap.put(config.split("=")[0], config.split("=")[1]);
        }
        return otherMap;
    }
}

