/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.provider;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Driver;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCDataSourceProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDBCDataSourceProvider.class);

    public static HikariDataSource createOneSessionJdbcDataSource(BaseConnectionParam properties, DbType dbType) {
        log.info("Creating OneSession HikariDataSource pool for maxActive:{}", (Object)PropertyUtils.getInt((String)"spring.datasource.maxActive", (int)50));
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setDriverClassName(properties.getDriverClassName());
        dataSource.setJdbcUrl(DataSourceUtils.getJdbcUrl(dbType, (ConnectionParam)properties));
        dataSource.setUsername(properties.getUser());
        dataSource.setPassword(PasswordUtils.decodePassword(properties.getPassword()));
        Boolean isOneSession = PropertyUtils.getBoolean((String)"support.hive.oneSession", (Boolean)false);
        dataSource.setMinimumIdle(isOneSession != false ? 1 : PropertyUtils.getInt((String)"spring.datasource.minIdle", (int)5));
        dataSource.setMaximumPoolSize(isOneSession != false ? 1 : PropertyUtils.getInt((String)"spring.datasource.maxActive", (int)50));
        dataSource.setConnectionTestQuery(properties.getValidationQuery());
        if (MapUtils.isNotEmpty((Map)properties.getOther())) {
            properties.getOther().forEach((arg_0, arg_1) -> ((HikariDataSource)dataSource).addDataSourceProperty(arg_0, arg_1));
        }
        log.info("Creating OneSession HikariDataSource pool success.");
        return dataSource;
    }

    protected static void loaderJdbcDriver(ClassLoader classLoader, BaseConnectionParam properties, DbType dbType) {
        String drv = StringUtils.isBlank((CharSequence)properties.getDriverClassName()) ? DataSourceUtils.getDatasourceProcessor(dbType).getDatasourceDriver() : properties.getDriverClassName();
        try {
            Class<?> clazz = Class.forName(drv, true, classLoader);
            Driver driver = (Driver)clazz.newInstance();
            if (!driver.acceptsURL(properties.getJdbcUrl())) {
                log.warn("Jdbc driver loading error. Driver {} cannot accept url.", (Object)drv);
                throw new RuntimeException("Jdbc driver loading error.");
            }
            if (dbType.equals((Object)DbType.MYSQL)) {
                if (driver.getMajorVersion() >= 8) {
                    properties.setDriverClassName(drv);
                } else {
                    properties.setDriverClassName("com.mysql.jdbc.Driver");
                }
            }
        }
        catch (Exception e) {
            log.warn("The specified driver not suitable.");
        }
    }
}

