/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.azuresql.param;

import com.google.auto.service.AutoService;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.azuresql.param.AzureSQLAuthMode;
import org.apache.dolphinscheduler.plugin.datasource.azuresql.param.AzureSQLConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.azuresql.param.AzureSQLDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class AzureSQLDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        AzureSQLDataSourceParamDTO azureSQLDataSourceParamDTO = (AzureSQLDataSourceParamDTO)((Object)JSONUtils.parseObject((String)paramJson, AzureSQLDataSourceParamDTO.class));
        this.checkTrustServerCertificate(azureSQLDataSourceParamDTO);
        return azureSQLDataSourceParamDTO;
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        AzureSQLConnectionParam connectionParams = (AzureSQLConnectionParam)this.createConnectionParams(connectionJson);
        String[] hostSeperator = connectionParams.getAddress().split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        AzureSQLDataSourceParamDTO azureSQLDatasourceParamDTO = new AzureSQLDataSourceParamDTO();
        azureSQLDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        azureSQLDatasourceParamDTO.setUserName(connectionParams.getUser());
        azureSQLDatasourceParamDTO.setOther(connectionParams.getOther());
        azureSQLDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        azureSQLDatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        azureSQLDatasourceParamDTO.setMode(connectionParams.getMode());
        switch (azureSQLDatasourceParamDTO.getMode()) {
            case AD_MSI: {
                if (!StringUtils.isNotEmpty((CharSequence)connectionParams.getMSIClientId())) break;
                azureSQLDatasourceParamDTO.setMSIClientId(connectionParams.getMSIClientId());
                break;
            }
            case ACCESSTOKEN: {
                azureSQLDatasourceParamDTO.setEndpoint(connectionParams.getEndpoint());
                break;
            }
        }
        return azureSQLDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        AzureSQLDataSourceParamDTO azureSQLParam = (AzureSQLDataSourceParamDTO)datasourceParam;
        this.checkTrustServerCertificate(azureSQLParam);
        if (azureSQLParam.mode.equals((Object)AzureSQLAuthMode.ACCESSTOKEN)) {
            return this.createTokenConnectionParams(azureSQLParam);
        }
        String address = String.format("%s%s:%s", "jdbc:sqlserver://", azureSQLParam.getHost(), azureSQLParam.getPort());
        String jdbcUrl = address + ";databaseName=" + azureSQLParam.getDatabase();
        AzureSQLConnectionParam azureSQLConnectionParam = new AzureSQLConnectionParam();
        azureSQLConnectionParam.setAddress(address);
        azureSQLConnectionParam.setDatabase(azureSQLParam.getDatabase());
        azureSQLConnectionParam.setJdbcUrl(this.processAuthMode(jdbcUrl, azureSQLParam));
        azureSQLConnectionParam.setOther(azureSQLParam.getOther());
        azureSQLConnectionParam.setUser(azureSQLParam.getUserName());
        azureSQLConnectionParam.setPassword(PasswordUtils.encodePassword((String)azureSQLParam.getPassword()));
        azureSQLConnectionParam.setDriverClassName(this.getDatasourceDriver());
        azureSQLConnectionParam.setValidationQuery(this.getValidationQuery());
        azureSQLConnectionParam.setMode(azureSQLParam.getMode());
        return azureSQLConnectionParam;
    }

    public BaseConnectionParam createConnectionParams(String connectionJson) {
        return (BaseConnectionParam)JSONUtils.parseObject((String)connectionJson, AzureSQLConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        AzureSQLConnectionParam azureSQLConnectionParam = (AzureSQLConnectionParam)connectionParam;
        if (MapUtils.isNotEmpty((Map)azureSQLConnectionParam.getOther())) {
            return String.format("%s;%s", azureSQLConnectionParam.getJdbcUrl(), azureSQLConnectionParam.getOther());
        }
        return azureSQLConnectionParam.getJdbcUrl();
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        AzureSQLConnectionParam azureSQLConnectionParam = (AzureSQLConnectionParam)connectionParam;
        if (azureSQLConnectionParam.getMode().equals((Object)AzureSQLAuthMode.ACCESSTOKEN)) {
            return AzureSQLDataSourceProcessor.tokenGetConnection(azureSQLConnectionParam);
        }
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), azureSQLConnectionParam.getUser(), PasswordUtils.decodePassword((String)azureSQLConnectionParam.getPassword()));
    }

    public DbType getDbType() {
        return DbType.AZURESQL;
    }

    public DataSourceProcessor create() {
        return new AzureSQLDataSourceProcessor();
    }

    private AzureSQLConnectionParam createTokenConnectionParams(AzureSQLDataSourceParamDTO azureSQLParam) {
        String address = String.format("%s%s:%s", "jdbc:sqlserver://", azureSQLParam.getHost(), azureSQLParam.getPort());
        AzureSQLConnectionParam azureSQLConnectionParam = new AzureSQLConnectionParam();
        azureSQLConnectionParam.setMode(azureSQLParam.getMode());
        azureSQLConnectionParam.setAddress(address);
        azureSQLConnectionParam.setDatabase(azureSQLParam.getDatabase());
        azureSQLConnectionParam.setJdbcUrl(azureSQLParam.getHost());
        azureSQLConnectionParam.setOther(azureSQLParam.getOther());
        azureSQLConnectionParam.setUser(azureSQLParam.getUserName());
        azureSQLConnectionParam.setPassword(PasswordUtils.encodePassword((String)azureSQLParam.getPassword()));
        azureSQLConnectionParam.setDriverClassName(this.getDatasourceDriver());
        azureSQLConnectionParam.setValidationQuery(this.getValidationQuery());
        azureSQLConnectionParam.setEndpoint(azureSQLParam.getEndpoint());
        return azureSQLConnectionParam;
    }

    public static Connection tokenGetConnection(AzureSQLConnectionParam param) {
        IAuthenticationResult authenticationResult;
        ConfidentialClientApplication clientApplication;
        String spn = "https://database.windows.net/";
        String stsURL = param.getEndpoint();
        String clientId = param.getUser();
        String clientSecret = PasswordUtils.decodePassword((String)param.getPassword());
        String scope = spn + "/.default";
        HashSet<String> scopes = new HashSet<String>();
        scopes.add(scope);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        IClientSecret credential = ClientCredentialFactory.createFromSecret((String)clientSecret);
        try {
            clientApplication = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)clientId, (IClientCredential)credential).executorService(executorService)).authority(stsURL)).build();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        CompletableFuture future = clientApplication.acquireToken(ClientCredentialParameters.builder(scopes).build());
        try {
            authenticationResult = (IAuthenticationResult)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        String accessToken = authenticationResult.accessToken();
        SQLServerDataSource ds = new SQLServerDataSource();
        ds.setServerName(param.getJdbcUrl());
        ds.setDatabaseName(param.getDatabase());
        ds.setAccessToken(accessToken);
        ds.setTrustServerCertificate(true);
        try {
            return ds.getConnection();
        }
        catch (SQLServerException e) {
            throw new RuntimeException(e);
        }
    }

    private String processAuthMode(String jdbcUrl, AzureSQLDataSourceParamDTO param) {
        switch (param.getMode()) {
            case SQL_PASSWORD: 
            case AD_PASSWORD: 
            case AD_SERVICE_PRINCIPAL: {
                return String.format("%s;%s=%s", jdbcUrl, "authentication", param.getMode().getDescp());
            }
            case AD_MSI: {
                if (StringUtils.isEmpty((CharSequence)param.getMSIClientId())) {
                    return String.format("%s;%s=%s", jdbcUrl, "authentication", param.getMode().getDescp());
                }
                return String.format("%s;%s=%s;%s=%s", jdbcUrl, "authentication", param.getMode().getDescp(), "MSIClientId", param.getMSIClientId());
            }
        }
        return jdbcUrl;
    }

    private void checkTrustServerCertificate(BaseDataSourceParamDTO paramDTO) {
        Map other = Optional.ofNullable(paramDTO.getOther()).orElseGet(HashMap::new);
        other.put("trustServerCertificate", "true");
        paramDTO.setOther(other);
    }
}

