/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.clickhouse.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.clickhouse.param.ClickHouseConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.clickhouse.param.ClickHouseDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class ClickHouseDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, ClickHouseDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        ClickHouseConnectionParam connectionParams = (ClickHouseConnectionParam)this.createConnectionParams(connectionJson);
        ClickHouseDataSourceParamDTO clickHouseDatasourceParamDTO = new ClickHouseDataSourceParamDTO();
        clickHouseDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        clickHouseDatasourceParamDTO.setUserName(connectionParams.getUser());
        clickHouseDatasourceParamDTO.setOther(this.parseOther(connectionParams.getOther()));
        String[] hostSeperator = connectionParams.getAddress().split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        clickHouseDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        clickHouseDatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        return clickHouseDatasourceParamDTO;
    }

    public ConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        ClickHouseDataSourceParamDTO clickHouseParam = (ClickHouseDataSourceParamDTO)datasourceParam;
        String address = String.format("%s%s:%s", "jdbc:clickhouse://", clickHouseParam.getHost(), clickHouseParam.getPort());
        String jdbcUrl = address + "/" + clickHouseParam.getDatabase();
        ClickHouseConnectionParam clickhouseConnectionParam = new ClickHouseConnectionParam();
        clickhouseConnectionParam.setDatabase(clickHouseParam.getDatabase());
        clickhouseConnectionParam.setAddress(address);
        clickhouseConnectionParam.setJdbcUrl(jdbcUrl);
        clickhouseConnectionParam.setUser(clickHouseParam.getUserName());
        clickhouseConnectionParam.setPassword(PasswordUtils.encodePassword((String)clickHouseParam.getPassword()));
        clickhouseConnectionParam.setDriverClassName(this.getDatasourceDriver());
        clickhouseConnectionParam.setValidationQuery(this.getValidationQuery());
        clickhouseConnectionParam.setOther(this.transformOther(clickHouseParam.getOther()));
        clickhouseConnectionParam.setProps(clickHouseParam.getOther());
        return clickhouseConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, ClickHouseConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "com.clickhouse.jdbc.ClickHouseDriver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        ClickHouseConnectionParam clickhouseConnectionParam = (ClickHouseConnectionParam)connectionParam;
        String jdbcUrl = clickhouseConnectionParam.getJdbcUrl();
        if (!StringUtils.isEmpty((CharSequence)clickhouseConnectionParam.getOther())) {
            jdbcUrl = String.format("%s?%s", jdbcUrl, clickhouseConnectionParam.getOther());
        }
        return jdbcUrl;
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        ClickHouseConnectionParam clickhouseConnectionParam = (ClickHouseConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl((ConnectionParam)clickhouseConnectionParam), clickhouseConnectionParam.getUser(), PasswordUtils.decodePassword((String)clickhouseConnectionParam.getPassword()));
    }

    public DbType getDbType() {
        return DbType.CLICKHOUSE;
    }

    public DataSourceProcessor create() {
        return new ClickHouseDataSourceProcessor();
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        otherMap.forEach((key, value) -> stringBuilder.append(String.format("%s=%s%s", key, value, "&")));
        return stringBuilder.toString();
    }

    private Map<String, String> parseOther(String other) {
        String[] configs;
        if (other == null) {
            return null;
        }
        LinkedHashMap<String, String> otherMap = new LinkedHashMap<String, String>();
        for (String config : configs = other.split("&")) {
            otherMap.put(config.split("=")[0], config.split("=")[1]);
        }
        return otherMap;
    }
}

