/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.db2.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.db2.param.Db2ConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.db2.param.Db2DataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class Db2DataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, Db2DataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        Db2ConnectionParam connectionParams = (Db2ConnectionParam)this.createConnectionParams(connectionJson);
        Db2DataSourceParamDTO db2DatasourceParamDTO = new Db2DataSourceParamDTO();
        db2DatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        db2DatasourceParamDTO.setOther(this.parseOther(connectionParams.getOther()));
        db2DatasourceParamDTO.setUserName(db2DatasourceParamDTO.getUserName());
        String[] hostSeperator = connectionParams.getAddress().split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        db2DatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        db2DatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        return db2DatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        Db2DataSourceParamDTO db2Param = (Db2DataSourceParamDTO)datasourceParam;
        String address = String.format("%s%s:%s", "jdbc:db2://", db2Param.getHost(), db2Param.getPort());
        String jdbcUrl = String.format("%s/%s", address, db2Param.getDatabase());
        Db2ConnectionParam db2ConnectionParam = new Db2ConnectionParam();
        db2ConnectionParam.setAddress(address);
        db2ConnectionParam.setDatabase(db2Param.getDatabase());
        db2ConnectionParam.setJdbcUrl(jdbcUrl);
        db2ConnectionParam.setUser(db2Param.getUserName());
        db2ConnectionParam.setPassword(PasswordUtils.encodePassword((String)db2Param.getPassword()));
        db2ConnectionParam.setDriverClassName(this.getDatasourceDriver());
        db2ConnectionParam.setValidationQuery(this.getValidationQuery());
        db2ConnectionParam.setOther(this.transformOther(db2Param.getOther()));
        db2ConnectionParam.setProps(db2Param.getOther());
        return db2ConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, Db2ConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "com.ibm.db2.jcc.DB2Driver";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        Db2ConnectionParam db2ConnectionParam = (Db2ConnectionParam)connectionParam;
        if (!StringUtils.isEmpty((CharSequence)db2ConnectionParam.getOther())) {
            return String.format("%s;%s", db2ConnectionParam.getJdbcUrl(), db2ConnectionParam.getOther());
        }
        return db2ConnectionParam.getJdbcUrl();
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        Db2ConnectionParam db2ConnectionParam = (Db2ConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl((ConnectionParam)db2ConnectionParam), db2ConnectionParam.getUser(), PasswordUtils.decodePassword((String)db2ConnectionParam.getPassword()));
    }

    public DbType getDbType() {
        return DbType.DB2;
    }

    public DataSourceProcessor create() {
        return new Db2DataSourceProcessor();
    }

    public String getValidationQuery() {
        return "select 1 from sysibm.sysdummy1";
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        otherMap.forEach((key, value) -> stringBuilder.append(String.format("%s=%s%s", key, value, ";")));
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private Map<String, String> parseOther(String other) {
        if (other == null) {
            return null;
        }
        LinkedHashMap<String, String> otherMap = new LinkedHashMap<String, String>();
        for (String config : other.split("&")) {
            otherMap.put(config.split("=")[0], config.split("=")[1]);
        }
        return otherMap;
    }
}

