/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.doris.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.doris.param.DorisConnectionParam;
import org.apache.dolphinscheduler.plugin.doris.param.DorisDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class DorisDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, DorisDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) throws NumberFormatException {
        DorisConnectionParam connectionParams = (DorisConnectionParam)this.createConnectionParams(connectionJson);
        DorisDataSourceParamDTO dorisDataSourceParamDTO = new DorisDataSourceParamDTO();
        dorisDataSourceParamDTO.setUserName(connectionParams.getUser());
        dorisDataSourceParamDTO.setDatabase(connectionParams.getDatabase());
        dorisDataSourceParamDTO.setOther(connectionParams.getOther());
        String address = connectionParams.getAddress();
        String[] hostSeperator = address.split("//");
        CharSequence[] hostPortArrays = hostSeperator[hostSeperator.length - 1].split(",");
        dorisDataSourceParamDTO.setPort(Integer.parseInt(hostPortArrays[0].split(":")[1]));
        for (int i = 0; i < hostPortArrays.length; ++i) {
            hostPortArrays[i] = ((String)hostPortArrays[i]).split(":")[0];
        }
        dorisDataSourceParamDTO.setHost(String.join((CharSequence)",", hostPortArrays));
        return dorisDataSourceParamDTO;
    }

    public ConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        DorisDataSourceParamDTO mysqlDatasourceParam = (DorisDataSourceParamDTO)datasourceParam;
        CharSequence[] hosts = datasourceParam.getHost().split(",");
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = String.format("%s:%s", hosts[i], mysqlDatasourceParam.getPort());
        }
        String address = String.format("%s%s", "jdbc:mysql:loadbalance://", String.join((CharSequence)",", hosts));
        String jdbcUrl = String.format("%s/%s", address, mysqlDatasourceParam.getDatabase());
        DorisConnectionParam mysqlConnectionParam = new DorisConnectionParam();
        mysqlConnectionParam.setJdbcUrl(jdbcUrl);
        mysqlConnectionParam.setDatabase(mysqlDatasourceParam.getDatabase());
        mysqlConnectionParam.setAddress(address);
        mysqlConnectionParam.setUser(mysqlDatasourceParam.getUserName());
        mysqlConnectionParam.setPassword(PasswordUtils.encodePassword((String)mysqlDatasourceParam.getPassword()));
        mysqlConnectionParam.setDriverClassName(this.getDatasourceDriver());
        mysqlConnectionParam.setValidationQuery(this.getValidationQuery());
        mysqlConnectionParam.setOther(mysqlDatasourceParam.getOther());
        return mysqlConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, DorisConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "com.mysql.cj.jdbc.Driver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        DorisConnectionParam mysqlConnectionParam = (DorisConnectionParam)connectionParam;
        String jdbcUrl = mysqlConnectionParam.getJdbcUrl();
        if (MapUtils.isNotEmpty((Map)mysqlConnectionParam.getOther())) {
            return String.format("%s?%s", jdbcUrl, this.transformOther(mysqlConnectionParam.getOther()));
        }
        return String.format("%s", jdbcUrl);
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        DorisConnectionParam dorisConnectionParam = (DorisConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), dorisConnectionParam.getUser(), PasswordUtils.decodePassword((String)dorisConnectionParam.getPassword()));
    }

    public DbType getDbType() {
        return DbType.DORIS;
    }

    public DataSourceProcessor create() {
        return new DorisDataSourceProcessor();
    }

    private String transformOther(Map<String, String> paramMap) {
        if (MapUtils.isEmpty(paramMap)) {
            return null;
        }
        HashMap<String, String> otherMap = new HashMap<String, String>();
        paramMap.forEach((k, v) -> otherMap.put((String)k, (String)v));
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        ArrayList otherList = new ArrayList();
        otherMap.forEach((key, value) -> otherList.add(String.format("%s=%s", key, value)));
        return String.join((CharSequence)"&", otherList);
    }
}

