/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.utils;

import java.io.IOException;
import java.util.Objects;
import org.apache.dolphinscheduler.spi.enums.ResUploadType;
import org.apache.dolphinscheduler.spi.utils.PropertyUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class CommonUtil {
    private CommonUtil() {
    }

    public static boolean getKerberosStartupState() {
        String resUploadStartupType = PropertyUtils.getUpperCaseString((String)"resource.storage.type");
        ResUploadType resUploadType = ResUploadType.valueOf((String)resUploadStartupType);
        Boolean kerberosStartupState = PropertyUtils.getBoolean((String)"hadoop.security.authentication.startup.state", (boolean)false);
        return resUploadType == ResUploadType.HDFS && kerberosStartupState != false;
    }

    public static synchronized UserGroupInformation createUGI(Configuration configuration, String principal, String keyTab, String krb5File, String username) throws IOException {
        if (CommonUtil.getKerberosStartupState()) {
            Objects.requireNonNull(keyTab);
            if (StringUtils.isNotBlank((CharSequence)krb5File)) {
                System.setProperty("java.security.krb5.conf", krb5File);
            }
            return CommonUtil.loginKerberos(configuration, principal, keyTab);
        }
        return UserGroupInformation.createRemoteUser((String)username);
    }

    public static synchronized UserGroupInformation loginKerberos(Configuration config, String principal, String keyTab) throws IOException {
        config.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)config);
        UserGroupInformation.loginUserFromKeytab((String)principal.trim(), (String)keyTab.trim());
        return UserGroupInformation.getCurrentUser();
    }
}

