/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.hive;

import com.zaxxer.hikari.HikariDataSource;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.client.BasePooledDataSourceClient;
import org.apache.dolphinscheduler.plugin.datasource.hive.security.UserGroupInformationFactory;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.krb5.Config;

public class HivePooledDataSourceClient
extends BasePooledDataSourceClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HivePooledDataSourceClient.class);

    public HivePooledDataSourceClient(BaseConnectionParam baseConnectionParam, DbType dbType) {
        super(baseConnectionParam, dbType);
    }

    public HikariDataSource createDataSourcePool(BaseConnectionParam baseConnectionParam, DbType dbType) {
        this.checkKerberosEnv();
        UserGroupInformationFactory.login(baseConnectionParam.getUser());
        return super.createDataSourcePool(baseConnectionParam, dbType);
    }

    private void checkKerberosEnv() {
        String krb5File = PropertyUtils.getString((String)"java.security.krb5.conf.path");
        Boolean kerberosStartupState = PropertyUtils.getBoolean((String)"hadoop.security.authentication.startup.state", (Boolean)false);
        if (kerberosStartupState.booleanValue() && StringUtils.isNotBlank((CharSequence)krb5File)) {
            System.setProperty("java.security.krb5.conf", krb5File);
            try {
                Config.refresh();
                Class<?> kerberosName = Class.forName("org.apache.hadoop.security.authentication.util.KerberosName");
                Field field = kerberosName.getDeclaredField("defaultRealm");
                field.setAccessible(true);
                field.set(null, Config.getInstance().getDefaultRealm());
            }
            catch (Exception e) {
                throw new RuntimeException("Update Kerberos environment failed.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            Class<HikariDataSource> clazz = HikariDataSource.class;
            synchronized (HikariDataSource.class) {
                UserGroupInformationFactory.logout(this.baseConnectionParam.getUser());
                UserGroupInformationFactory.login(this.baseConnectionParam.getUser());
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.dataSource.getConnection();
            }
        }
    }

    public void close() {
        try {
            super.close();
        }
        finally {
            UserGroupInformationFactory.logout(this.baseConnectionParam.getUser());
        }
        log.info("Closed Hive datasource client.");
    }
}

