/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.mysql.param;

import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.mysql.param.MySQLConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.mysql.param.MySQLDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={DataSourceProcessor.class})
public class MySQLDataSourceProcessor
extends AbstractDataSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLDataSourceProcessor.class);
    private static final String ALLOW_LOAD_LOCAL_IN_FILE_NAME = "allowLoadLocalInfile";
    private static final String AUTO_DESERIALIZE = "autoDeserialize";
    private static final String ALLOW_LOCAL_IN_FILE_NAME = "allowLocalInfile";
    private static final String ALLOW_URL_IN_LOCAL_IN_FILE_NAME = "allowUrlInLocalInfile";

    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, MySQLDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        MySQLConnectionParam connectionParams = (MySQLConnectionParam)this.createConnectionParams(connectionJson);
        MySQLDataSourceParamDTO mysqlDatasourceParamDTO = new MySQLDataSourceParamDTO();
        mysqlDatasourceParamDTO.setUserName(connectionParams.getUser());
        mysqlDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        mysqlDatasourceParamDTO.setOther(connectionParams.getOther());
        String address = connectionParams.getAddress();
        String[] hostSeperator = address.split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        mysqlDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        mysqlDatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        return mysqlDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO dataSourceParam) {
        MySQLDataSourceParamDTO mysqlDatasourceParam = (MySQLDataSourceParamDTO)dataSourceParam;
        String address = String.format("%s%s:%s", "jdbc:mysql://", mysqlDatasourceParam.getHost(), mysqlDatasourceParam.getPort());
        String jdbcUrl = String.format("%s/%s", address, mysqlDatasourceParam.getDatabase());
        MySQLConnectionParam mysqlConnectionParam = new MySQLConnectionParam();
        mysqlConnectionParam.setJdbcUrl(jdbcUrl);
        mysqlConnectionParam.setDatabase(mysqlDatasourceParam.getDatabase());
        mysqlConnectionParam.setAddress(address);
        mysqlConnectionParam.setUser(mysqlDatasourceParam.getUserName());
        mysqlConnectionParam.setPassword(PasswordUtils.encodePassword((String)mysqlDatasourceParam.getPassword()));
        mysqlConnectionParam.setDriverClassName(this.getDatasourceDriver());
        mysqlConnectionParam.setValidationQuery(this.getValidationQuery());
        mysqlConnectionParam.setOther(mysqlDatasourceParam.getOther());
        return mysqlConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, MySQLConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "com.mysql.cj.jdbc.Driver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        MySQLConnectionParam mysqlConnectionParam = (MySQLConnectionParam)connectionParam;
        if (MapUtils.isNotEmpty((Map)mysqlConnectionParam.getOther())) {
            return String.format("%s?%s", mysqlConnectionParam.getJdbcUrl(), this.transformOther(mysqlConnectionParam.getOther()));
        }
        return mysqlConnectionParam.getJdbcUrl();
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        String password;
        MySQLConnectionParam mysqlConnectionParam = (MySQLConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        String user = mysqlConnectionParam.getUser();
        if (user.contains(AUTO_DESERIALIZE)) {
            log.warn("sensitive param : {} in username field is filtered", (Object)AUTO_DESERIALIZE);
            user = user.replace(AUTO_DESERIALIZE, "");
        }
        if ((password = PasswordUtils.decodePassword((String)mysqlConnectionParam.getPassword())).contains(AUTO_DESERIALIZE)) {
            log.warn("sensitive param : {} in password field is filtered", (Object)AUTO_DESERIALIZE);
            password = password.replace(AUTO_DESERIALIZE, "");
        }
        Properties connectionProperties = this.getConnectionProperties(mysqlConnectionParam, user, password);
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), connectionProperties);
    }

    private Properties getConnectionProperties(MySQLConnectionParam mysqlConnectionParam, String user, String password) {
        Properties connectionProperties = new Properties();
        connectionProperties.put("user", user);
        connectionProperties.put("password", password);
        Map paramMap = mysqlConnectionParam.getOther();
        if (MapUtils.isNotEmpty((Map)paramMap)) {
            paramMap.forEach((k, v) -> {
                if (!MySQLDataSourceProcessor.checkKeyIsLegitimate(k)) {
                    log.info("Key `{}` is not legitimate for security reason", k);
                    return;
                }
                connectionProperties.put(k, v);
            });
        }
        connectionProperties.put(AUTO_DESERIALIZE, "false");
        connectionProperties.put(ALLOW_LOAD_LOCAL_IN_FILE_NAME, "false");
        connectionProperties.put(ALLOW_LOCAL_IN_FILE_NAME, "false");
        connectionProperties.put(ALLOW_URL_IN_LOCAL_IN_FILE_NAME, "false");
        return connectionProperties;
    }

    public DbType getDbType() {
        return DbType.MYSQL;
    }

    public DataSourceProcessor create() {
        return new MySQLDataSourceProcessor();
    }

    public List<String> splitAndRemoveComment(String sql) {
        return SQLParserUtils.splitAndRemoveComment((String)sql, (com.alibaba.druid.DbType)com.alibaba.druid.DbType.mysql);
    }

    private static boolean checkKeyIsLegitimate(String key) {
        return !key.contains(ALLOW_LOAD_LOCAL_IN_FILE_NAME) && !key.contains(AUTO_DESERIALIZE) && !key.contains(ALLOW_LOCAL_IN_FILE_NAME) && !key.contains(ALLOW_URL_IN_LOCAL_IN_FILE_NAME);
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isNotEmpty(otherMap)) {
            ArrayList list = new ArrayList(otherMap.size());
            otherMap.forEach((key, value) -> list.add(String.format("%s=%s", key, value)));
            return String.join((CharSequence)"&", list);
        }
        return null;
    }
}

