/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.oceanbase.param;

import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.oceanbase.param.OceanBaseConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.oceanbase.param.OceanBaseDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={DataSourceProcessor.class})
public class OceanBaseDataSourceProcessor
extends AbstractDataSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OceanBaseDataSourceProcessor.class);
    private static final String ALLOW_LOAD_LOCAL_IN_FILE_NAME = "allowLoadLocalInfile";
    private static final String AUTO_DESERIALIZE = "autoDeserialize";
    private static final String ALLOW_LOCAL_IN_FILE_NAME = "allowLocalInfile";
    private static final String ALLOW_URL_IN_LOCAL_IN_FILE_NAME = "allowUrlInLocalInfile";
    private static final String APPEND_PARAMS = "allowLoadLocalInfile=false&autoDeserialize=false&allowLocalInfile=false&allowUrlInLocalInfile=false";

    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, OceanBaseDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        OceanBaseConnectionParam connectionParams = (OceanBaseConnectionParam)this.createConnectionParams(connectionJson);
        OceanBaseDataSourceParamDTO dataSourceParamDTO = new OceanBaseDataSourceParamDTO();
        dataSourceParamDTO.setUserName(connectionParams.getUser());
        dataSourceParamDTO.setDatabase(connectionParams.getDatabase());
        dataSourceParamDTO.setOther(connectionParams.getOther());
        String address = connectionParams.getAddress();
        String[] hostSeparator = address.split("//");
        String[] hostPortArray = hostSeparator[hostSeparator.length - 1].split(",");
        dataSourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        dataSourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        return dataSourceParamDTO;
    }

    public ConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        OceanBaseDataSourceParamDTO obDataSourceParamDTO = (OceanBaseDataSourceParamDTO)datasourceParam;
        String address = String.format("%s%s:%s", "jdbc:oceanbase://", obDataSourceParamDTO.getHost(), obDataSourceParamDTO.getPort());
        String jdbcUrl = String.format("%s/%s", address, obDataSourceParamDTO.getDatabase());
        OceanBaseConnectionParam connectionParam = new OceanBaseConnectionParam();
        connectionParam.setJdbcUrl(jdbcUrl);
        connectionParam.setDatabase(obDataSourceParamDTO.getDatabase());
        connectionParam.setAddress(address);
        connectionParam.setUser(obDataSourceParamDTO.getUserName());
        connectionParam.setPassword(PasswordUtils.encodePassword((String)obDataSourceParamDTO.getPassword()));
        connectionParam.setCompatibleMode(obDataSourceParamDTO.getCompatibleMode());
        connectionParam.setDriverClassName(this.getDatasourceDriver());
        connectionParam.setValidationQuery(this.getValidationQuery(connectionParam.getCompatibleMode()));
        connectionParam.setOther(obDataSourceParamDTO.getOther());
        return connectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, OceanBaseConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "com.oceanbase.jdbc.Driver";
    }

    public String getValidationQuery() {
        throw new UnsupportedOperationException("Can't get validation query without compatible mode");
    }

    public String getValidationQuery(String compatibleMode) {
        if (compatibleMode != null) {
            switch (compatibleMode.trim().toLowerCase()) {
                case "mysql": {
                    return "select 1";
                }
                case "oracle": {
                    return "select 1 from dual";
                }
            }
        }
        throw new UnsupportedOperationException("Invalid compatible mode: " + compatibleMode);
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        OceanBaseConnectionParam obConnectionParam = (OceanBaseConnectionParam)connectionParam;
        String jdbcUrl = obConnectionParam.getJdbcUrl();
        if (MapUtils.isNotEmpty((Map)obConnectionParam.getOther())) {
            return String.format("%s?%s&%s", jdbcUrl, this.transformOther(obConnectionParam.getOther()), APPEND_PARAMS);
        }
        return String.format("%s?%s", jdbcUrl, APPEND_PARAMS);
    }

    private String transformOther(Map<String, String> paramMap) {
        if (MapUtils.isEmpty(paramMap)) {
            return null;
        }
        HashMap<String, String> otherMap = new HashMap<String, String>();
        paramMap.forEach((k, v) -> {
            if (!OceanBaseDataSourceProcessor.checkKeyIsLegitimate(k)) {
                return;
            }
            otherMap.put((String)k, (String)v);
        });
        if (MapUtils.isEmpty(otherMap)) {
            return null;
        }
        ArrayList otherList = new ArrayList();
        otherMap.forEach((key, value) -> otherList.add(String.format("%s=%s", key, value)));
        return String.join((CharSequence)"&", otherList);
    }

    private static boolean checkKeyIsLegitimate(String key) {
        return !key.contains(ALLOW_LOAD_LOCAL_IN_FILE_NAME) && !key.contains(AUTO_DESERIALIZE) && !key.contains(ALLOW_LOCAL_IN_FILE_NAME) && !key.contains(ALLOW_URL_IN_LOCAL_IN_FILE_NAME);
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException, IOException {
        String password;
        OceanBaseConnectionParam obConnectionParam = (OceanBaseConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        String user = obConnectionParam.getUser();
        if (user.contains(AUTO_DESERIALIZE)) {
            log.warn("sensitive param : {} in username field is filtered", (Object)AUTO_DESERIALIZE);
            user = user.replace(AUTO_DESERIALIZE, "");
        }
        if ((password = PasswordUtils.decodePassword((String)obConnectionParam.getPassword())).contains(AUTO_DESERIALIZE)) {
            log.warn("sensitive param : {} in password field is filtered", (Object)AUTO_DESERIALIZE);
            password = password.replace(AUTO_DESERIALIZE, "");
        }
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), user, password);
    }

    public DbType getDbType() {
        return DbType.OCEANBASE;
    }

    public DataSourceProcessor create() {
        return new OceanBaseDataSourceProcessor();
    }

    public List<String> splitAndRemoveComment(String sql) {
        return SQLParserUtils.splitAndRemoveComment((String)sql, (com.alibaba.druid.DbType)com.alibaba.druid.DbType.oceanbase);
    }
}

