/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.redshift.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.redshift.param.RedshiftConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.redshift.param.RedshiftDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class RedshiftDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, RedshiftDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        RedshiftConnectionParam connectionParams = (RedshiftConnectionParam)this.createConnectionParams(connectionJson);
        String[] hostSeperator = connectionParams.getAddress().split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        RedshiftDataSourceParamDTO redshiftDatasourceParamDTO = new RedshiftDataSourceParamDTO();
        redshiftDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        redshiftDatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        redshiftDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        redshiftDatasourceParamDTO.setUserName(connectionParams.getUser());
        redshiftDatasourceParamDTO.setOther(this.parseOther(connectionParams.getOther()));
        return redshiftDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        RedshiftDataSourceParamDTO redshiftParam = (RedshiftDataSourceParamDTO)datasourceParam;
        String address = String.format("%s%s:%s", "jdbc:redshift://", redshiftParam.getHost(), redshiftParam.getPort());
        String jdbcUrl = address + "/" + redshiftParam.getDatabase();
        RedshiftConnectionParam redshiftConnectionParam = new RedshiftConnectionParam();
        redshiftConnectionParam.setUser(redshiftParam.getUserName());
        redshiftConnectionParam.setPassword(PasswordUtils.encodePassword((String)redshiftParam.getPassword()));
        redshiftConnectionParam.setOther(this.transformOther(redshiftParam.getOther()));
        redshiftConnectionParam.setAddress(address);
        redshiftConnectionParam.setJdbcUrl(jdbcUrl);
        redshiftConnectionParam.setDatabase(redshiftParam.getDatabase());
        redshiftConnectionParam.setDriverClassName(this.getDatasourceDriver());
        redshiftConnectionParam.setValidationQuery(this.getValidationQuery());
        redshiftConnectionParam.setProps(redshiftParam.getOther());
        return redshiftConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, RedshiftConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "com.amazon.redshift.jdbc42.Driver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        RedshiftConnectionParam redshiftConnectionParam = (RedshiftConnectionParam)connectionParam;
        if (!StringUtils.isEmpty((CharSequence)redshiftConnectionParam.getOther())) {
            return String.format("%s?%s", redshiftConnectionParam.getJdbcUrl(), redshiftConnectionParam.getOther());
        }
        return redshiftConnectionParam.getJdbcUrl();
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        RedshiftConnectionParam redshiftConnectionParam = (RedshiftConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), redshiftConnectionParam.getUser(), PasswordUtils.decodePassword((String)redshiftConnectionParam.getPassword()));
    }

    public DbType getDbType() {
        return DbType.REDSHIFT;
    }

    public DataSourceProcessor create() {
        return new RedshiftDataSourceProcessor();
    }

    private String transformOther(Map<String, String> otherMap) {
        if (MapUtils.isNotEmpty(otherMap)) {
            ArrayList list = new ArrayList(otherMap.size());
            otherMap.forEach((key, value) -> list.add(String.format("%s=%s", key, value)));
            return String.join((CharSequence)";", list);
        }
        return null;
    }

    private Map<String, String> parseOther(String other) {
        String[] configs;
        LinkedHashMap<String, String> otherMap = new LinkedHashMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)other)) {
            return otherMap;
        }
        for (String config : configs = other.split(";")) {
            otherMap.put(config.split("=")[0], config.split("=")[1]);
        }
        return otherMap;
    }
}

