/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.zeppelin;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.zeppelin.client.ClientConfig;
import org.apache.zeppelin.client.ZeppelinClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinClientWrapper
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZeppelinClientWrapper.class);
    private ZeppelinClient zeppelinClient;

    public ZeppelinClientWrapper(String restEndpoint) throws Exception {
        Preconditions.checkNotNull((Object)restEndpoint);
        ClientConfig clientConfig = new ClientConfig(restEndpoint);
        this.zeppelinClient = new ZeppelinClient(clientConfig);
    }

    public boolean checkConnect(String username, String password) {
        try {
            this.zeppelinClient.login(username, password);
            String version = this.zeppelinClient.getVersion();
            log.info("zeppelin client connects to server successfully, version is {}", (Object)version);
            return true;
        }
        catch (Exception e) {
            log.info("zeppelin client failed to connect to the server");
            return false;
        }
    }

    @Override
    public void close() throws Exception {
    }
}

