/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.extract.base.config.NettyServerConfig;
import org.apache.dolphinscheduler.extract.base.exception.RemoteException;
import org.apache.dolphinscheduler.extract.base.protocal.TransporterDecoder;
import org.apache.dolphinscheduler.extract.base.protocal.TransporterEncoder;
import org.apache.dolphinscheduler.extract.base.server.JdkDynamicServerHandler;
import org.apache.dolphinscheduler.extract.base.server.ServerMethodInvoker;
import org.apache.dolphinscheduler.extract.base.utils.NettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRemotingServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyRemotingServer.class);
    private final ServerBootstrap serverBootstrap = new ServerBootstrap();
    private final ExecutorService defaultExecutor = ThreadUtils.newDaemonFixedThreadExecutor((String)"NettyRemotingServerThread", (int)(Runtime.getRuntime().availableProcessors() * 2));
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workGroup;
    private final NettyServerConfig serverConfig;
    private final JdkDynamicServerHandler serverHandler = new JdkDynamicServerHandler(this);
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public NettyRemotingServer(NettyServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        ThreadFactory bossThreadFactory = ThreadUtils.newDaemonThreadFactory((String)(serverConfig.getServerName() + "BossThread_%s"));
        ThreadFactory workerThreadFactory = ThreadUtils.newDaemonThreadFactory((String)(serverConfig.getServerName() + "WorkerThread_%s"));
        if (Epoll.isAvailable()) {
            this.bossGroup = new EpollEventLoopGroup(1, bossThreadFactory);
            this.workGroup = new EpollEventLoopGroup(serverConfig.getWorkerThread(), workerThreadFactory);
        } else {
            this.bossGroup = new NioEventLoopGroup(1, bossThreadFactory);
            this.workGroup = new NioEventLoopGroup(serverConfig.getWorkerThread(), workerThreadFactory);
        }
    }

    public void start() {
        if (this.isStarted.compareAndSet(false, true)) {
            ChannelFuture future;
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.bossGroup, this.workGroup).channel(NettyUtils.getServerSocketChannelClass())).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)this.serverConfig.getSoBacklog())).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.serverConfig.isSoKeepalive()).childOption(ChannelOption.TCP_NODELAY, (Object)this.serverConfig.isTcpNoDelay()).childOption(ChannelOption.SO_SNDBUF, (Object)this.serverConfig.getSendBufferSize()).childOption(ChannelOption.SO_RCVBUF, (Object)this.serverConfig.getReceiveBufferSize()).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    NettyRemotingServer.this.initNettyChannel(ch);
                }
            });
            try {
                future = this.serverBootstrap.bind(this.serverConfig.getListenPort()).sync();
            }
            catch (Exception e) {
                log.error("{} bind fail {}, exit", new Object[]{this.serverConfig.getServerName(), e.getMessage(), e});
                throw new RemoteException(String.format("%s bind %s fail", this.serverConfig.getServerName(), this.serverConfig.getListenPort()));
            }
            if (future.isSuccess()) {
                log.info("{} bind success at port: {}", (Object)this.serverConfig.getServerName(), (Object)this.serverConfig.getListenPort());
                return;
            }
            if (future.cause() != null) {
                throw new RemoteException(String.format("%s bind %s fail", this.serverConfig.getServerName(), this.serverConfig.getListenPort()), future.cause());
            }
            throw new RemoteException(String.format("%s bind %s fail", this.serverConfig.getServerName(), this.serverConfig.getListenPort()));
        }
    }

    private void initNettyChannel(SocketChannel ch) {
        ch.pipeline().addLast("encoder", (ChannelHandler)new TransporterEncoder()).addLast("decoder", (ChannelHandler)new TransporterDecoder()).addLast("server-idle-handle", (ChannelHandler)new IdleStateHandler(0L, 0L, 181000L, TimeUnit.MILLISECONDS)).addLast("handler", (ChannelHandler)this.serverHandler);
    }

    public ExecutorService getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public void registerMethodInvoker(ServerMethodInvoker methodInvoker) {
        this.serverHandler.registerMethodInvoker(methodInvoker);
    }

    public void close() {
        if (this.isStarted.compareAndSet(true, false)) {
            try {
                if (this.bossGroup != null) {
                    this.bossGroup.shutdownGracefully();
                }
                if (this.workGroup != null) {
                    this.workGroup.shutdownGracefully();
                }
                this.defaultExecutor.shutdown();
            }
            catch (Exception ex) {
                log.error("netty server close exception", (Throwable)ex);
            }
            log.info("netty server closed");
        }
    }
}

