/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.server;

import java.lang.reflect.Method;
import lombok.Generated;
import org.apache.dolphinscheduler.extract.base.NettyRemotingServer;
import org.apache.dolphinscheduler.extract.base.RpcMethod;
import org.apache.dolphinscheduler.extract.base.RpcService;
import org.apache.dolphinscheduler.extract.base.server.ServerMethodInvokerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.lang.Nullable;

public class SpringServerMethodInvokerDiscovery
implements BeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringServerMethodInvokerDiscovery.class);
    protected final NettyRemotingServer nettyRemotingServer;

    public SpringServerMethodInvokerDiscovery(NettyRemotingServer nettyRemotingServer) {
        this.nettyRemotingServer = nettyRemotingServer;
    }

    @Nullable
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = bean.getClass().getInterfaces()) {
            if (anInterface.getAnnotation(RpcService.class) == null) continue;
            this.registerRpcMethodInvoker(anInterface, bean, beanName);
        }
        return bean;
    }

    private void registerRpcMethodInvoker(Class<?> anInterface, Object bean, String beanName) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = anInterface.getDeclaredMethods()) {
            RpcMethod rpcMethod = method.getAnnotation(RpcMethod.class);
            if (rpcMethod == null) continue;
            ServerMethodInvokerImpl methodInvoker = new ServerMethodInvokerImpl(bean, method);
            this.nettyRemotingServer.registerMethodInvoker(methodInvoker);
            log.debug("Register ServerMethodInvoker: {} to bean: {}", (Object)methodInvoker.getMethodIdentify(), (Object)beanName);
        }
    }
}

