/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cache.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.springframework.stereotype.Component;

@Component
public class ProcessInstanceExecCacheManagerImpl
implements ProcessInstanceExecCacheManager {
    private final ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceExecMaps = new ConcurrentHashMap();

    @Override
    public WorkflowExecuteThread getByProcessInstanceId(int processInstanceId) {
        return this.processInstanceExecMaps.get(processInstanceId);
    }

    @Override
    public boolean contains(int processInstanceId) {
        return this.processInstanceExecMaps.containsKey(processInstanceId);
    }

    @Override
    public void removeByProcessInstanceId(int processInstanceId) {
        this.processInstanceExecMaps.remove(processInstanceId);
    }

    @Override
    public void cache(int processInstanceId, WorkflowExecuteThread workflowExecuteThread) {
        if (workflowExecuteThread == null) {
            return;
        }
        this.processInstanceExecMaps.put(processInstanceId, workflowExecuteThread);
    }

    @Override
    public Collection<WorkflowExecuteThread> getAll() {
        return ImmutableList.copyOf(this.processInstanceExecMaps.values());
    }
}

