/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor.queue;

import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThreadPool;
import org.apache.dolphinscheduler.server.utils.DataQualityResultOperator;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

@Component
public class TaskExecuteThreadPool
extends ThreadPoolTaskExecutor {
    private static final Logger logger = LoggerFactory.getLogger(TaskExecuteThreadPool.class);
    private final ConcurrentHashMap<String, TaskExecuteThread> multiThreadFilterMap = new ConcurrentHashMap();
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private ProcessService processService;
    @Autowired
    private DataQualityResultOperator dataQualityResultOperator;
    @Autowired
    private WorkflowExecuteThreadPool workflowExecuteThreadPool;
    private final ConcurrentHashMap<Integer, TaskExecuteThread> taskExecuteThreadMap = new ConcurrentHashMap();

    @PostConstruct
    private void init() {
        this.setDaemon(true);
        this.setThreadNamePrefix("Task-Execute-Thread-");
        this.setMaxPoolSize(this.masterConfig.getExecThreads());
        this.setCorePoolSize(this.masterConfig.getExecThreads());
    }

    public void submitTaskEvent(TaskEvent taskEvent) {
        TaskExecuteThread taskExecuteThread;
        if (!this.processInstanceExecCacheManager.contains(taskEvent.getProcessInstanceId())) {
            logger.warn("workflowExecuteThread is null, event: {}", (Object)taskEvent);
            return;
        }
        if (!this.taskExecuteThreadMap.containsKey(taskEvent.getProcessInstanceId())) {
            taskExecuteThread = new TaskExecuteThread(taskEvent.getProcessInstanceId(), this.processService, this.workflowExecuteThreadPool, this.processInstanceExecCacheManager, this.dataQualityResultOperator);
            this.taskExecuteThreadMap.put(taskEvent.getProcessInstanceId(), taskExecuteThread);
        }
        if ((taskExecuteThread = this.taskExecuteThreadMap.get(taskEvent.getProcessInstanceId())) != null) {
            taskExecuteThread.addEvent(taskEvent);
        }
    }

    public void eventHandler() {
        for (TaskExecuteThread taskExecuteThread : this.taskExecuteThreadMap.values()) {
            this.executeEvent(taskExecuteThread);
        }
    }

    public void executeEvent(final TaskExecuteThread taskExecuteThread) {
        if (taskExecuteThread.eventSize() == 0) {
            return;
        }
        if (this.multiThreadFilterMap.containsKey(taskExecuteThread.getKey())) {
            return;
        }
        this.multiThreadFilterMap.put(taskExecuteThread.getKey(), taskExecuteThread);
        ListenableFuture future = this.submitListenable(taskExecuteThread::run);
        future.addCallback(new ListenableFutureCallback(){

            public void onFailure(Throwable ex) {
                logger.error("handle event {} failed: {}", (Object)taskExecuteThread.getProcessInstanceId(), (Object)ex);
                if (!TaskExecuteThreadPool.this.processInstanceExecCacheManager.contains(taskExecuteThread.getProcessInstanceId())) {
                    TaskExecuteThreadPool.this.taskExecuteThreadMap.remove(taskExecuteThread.getProcessInstanceId());
                    logger.info("remove process instance: {}", (Object)taskExecuteThread.getProcessInstanceId());
                }
                TaskExecuteThreadPool.this.multiThreadFilterMap.remove(taskExecuteThread.getKey());
            }

            public void onSuccess(Object result) {
                logger.info("persist events {} succeeded.", (Object)taskExecuteThread.getProcessInstanceId());
                if (!TaskExecuteThreadPool.this.processInstanceExecCacheManager.contains(taskExecuteThread.getProcessInstanceId())) {
                    TaskExecuteThreadPool.this.taskExecuteThreadMap.remove(taskExecuteThread.getProcessInstanceId());
                    logger.info("remove process instance: {}", (Object)taskExecuteThread.getProcessInstanceId());
                }
                TaskExecuteThreadPool.this.multiThreadFilterMap.remove(taskExecuteThread.getKey());
            }
        });
    }
}

