/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;

public class TaskProcessorFactory {
    public static final Map<String, ITaskProcessor> PROCESS_MAP = new ConcurrentHashMap<String, ITaskProcessor>();
    private static final String DEFAULT_PROCESSOR = "common";

    public static ITaskProcessor getTaskProcessor(String type) throws InstantiationException, IllegalAccessException {
        ITaskProcessor iTaskProcessor;
        if (StringUtils.isEmpty((CharSequence)type)) {
            type = DEFAULT_PROCESSOR;
        }
        if (Objects.isNull(iTaskProcessor = PROCESS_MAP.get(type))) {
            iTaskProcessor = PROCESS_MAP.get(DEFAULT_PROCESSOR);
        }
        return (ITaskProcessor)iTaskProcessor.getClass().newInstance();
    }

    static {
        for (ITaskProcessor iTaskProcessor : ServiceLoader.load(ITaskProcessor.class)) {
            PROCESS_MAP.put(iTaskProcessor.getType(), iTaskProcessor);
        }
    }
}

