/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor.queue;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.dolphinscheduler.common.enums.StateEvent;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.remote.command.StateEventResponseCommand;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StateEventResponseService {
    private final Logger logger = LoggerFactory.getLogger(StateEventResponseService.class);
    private final BlockingQueue<StateEvent> eventQueue = new LinkedBlockingQueue<StateEvent>(5000);
    private Thread responseWorker;
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private WorkflowExecuteThreadPool workflowExecuteThreadPool;

    @PostConstruct
    public void start() {
        this.responseWorker = new StateEventResponseWorker();
        this.responseWorker.setName("StateEventResponseWorker");
        this.responseWorker.start();
    }

    @PreDestroy
    public void stop() {
        this.responseWorker.interrupt();
        if (!this.eventQueue.isEmpty()) {
            ArrayList remainEvents = new ArrayList(this.eventQueue.size());
            this.eventQueue.drainTo(remainEvents);
            for (StateEvent event : remainEvents) {
                this.persist(event);
            }
        }
    }

    public void addResponse(StateEvent stateEvent) {
        try {
            this.eventQueue.put(stateEvent);
        }
        catch (InterruptedException e) {
            this.logger.error("put state event : {} error :{}", (Object)stateEvent, (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    private void writeResponse(StateEvent stateEvent, ExecutionStatus status) {
        Channel channel = stateEvent.getChannel();
        if (channel != null) {
            StateEventResponseCommand command = new StateEventResponseCommand(status.getCode(), stateEvent.getKey());
            channel.writeAndFlush((Object)command.convert2Command());
        }
    }

    private void persist(StateEvent stateEvent) {
        try {
            if (!this.processInstanceExecCacheManager.contains(stateEvent.getProcessInstanceId())) {
                this.writeResponse(stateEvent, ExecutionStatus.FAILURE);
                return;
            }
            WorkflowExecuteThread workflowExecuteThread = this.processInstanceExecCacheManager.getByProcessInstanceId(stateEvent.getProcessInstanceId());
            switch (stateEvent.getType()) {
                case TASK_STATE_CHANGE: {
                    workflowExecuteThread.refreshTaskInstance(stateEvent.getTaskInstanceId());
                    break;
                }
                case PROCESS_STATE_CHANGE: {
                    workflowExecuteThread.refreshProcessInstance(stateEvent.getProcessInstanceId());
                    break;
                }
            }
            this.workflowExecuteThreadPool.submitStateEvent(stateEvent);
            this.writeResponse(stateEvent, ExecutionStatus.SUCCESS);
        }
        catch (Exception e) {
            this.logger.error("persist event queue error, event: {}", (Object)stateEvent, (Object)e);
        }
    }

    public void addEvent2WorkflowExecute(StateEvent stateEvent) {
        this.workflowExecuteThreadPool.submitStateEvent(stateEvent);
    }

    class StateEventResponseWorker
    extends Thread {
        StateEventResponseWorker() {
        }

        @Override
        public void run() {
            while (Stopper.isRunning()) {
                try {
                    StateEvent stateEvent = (StateEvent)StateEventResponseService.this.eventQueue.take();
                    StateEventResponseService.this.persist(stateEvent);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            StateEventResponseService.this.logger.info("StateEventResponseWorker stopped");
        }
    }
}

