/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.service.FailoverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FailoverExecuteThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(FailoverExecuteThread.class);
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private FailoverService failoverService;

    @Override
    public synchronized void start() {
        super.setName("FailoverExecuteThread");
        super.start();
    }

    @Override
    public void run() {
        ThreadUtils.sleep((long)10000L);
        logger.info("failover execute thread started");
        while (Stopper.isRunning()) {
            try {
                this.failoverService.checkMasterFailover();
            }
            catch (Exception e) {
                logger.error("failover execute error", (Throwable)e);
            }
            finally {
                ThreadUtils.sleep((long)(1000L * (long)this.masterConfig.getFailoverInterval() * 60L));
            }
        }
    }
}

