/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.StateEvent;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.TaskGroupQueueStatus;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.process.ProcessDag;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.Environment;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.TaskGroupQueue;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.utils.DagHelper;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.DependResult;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.BlockingParameters;
import org.apache.dolphinscheduler.remote.command.HostUpdateCommand;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.dispatch.executor.NettyExecutorManager;
import org.apache.dolphinscheduler.server.master.runner.StateWheelExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.TaskAction;
import org.apache.dolphinscheduler.server.master.runner.task.TaskProcessorFactory;
import org.apache.dolphinscheduler.service.alert.ProcessAlertManager;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.quartz.cron.CronUtils;
import org.apache.dolphinscheduler.service.queue.PeerTaskInstancePriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowExecuteThread {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowExecuteThread.class);
    private MasterConfig masterConfig;
    private ProcessService processService;
    private ProcessAlertManager processAlertManager;
    private NettyExecutorManager nettyExecutorManager;
    private ProcessInstance processInstance;
    private ProcessDefinition processDefinition;
    private DAG<String, TaskNode, TaskNodeRelation> dag;
    private String key;
    private boolean isStart = false;
    private boolean taskFailedSubmit = false;
    private Map<Integer, TaskInstance> taskInstanceMap = new ConcurrentHashMap<Integer, TaskInstance>();
    private final Map<Long, ITaskProcessor> activeTaskProcessorMaps = new ConcurrentHashMap<Long, ITaskProcessor>();
    private Map<Long, Integer> validTaskMap = new ConcurrentHashMap<Long, Integer>();
    private Map<Long, Integer> errorTaskMap = new ConcurrentHashMap<Long, Integer>();
    private Map<Long, Integer> completeTaskMap = new ConcurrentHashMap<Long, Integer>();
    private Map<Long, Integer> dependFailedTaskMap = new ConcurrentHashMap<Long, Integer>();
    private Map<Long, TaskNode> forbiddenTaskMap = new ConcurrentHashMap<Long, TaskNode>();
    private Map<String, TaskNode> skipTaskNodeMap = new ConcurrentHashMap<String, TaskNode>();
    private List<Date> complementListDate = Lists.newLinkedList();
    private ConcurrentLinkedQueue<StateEvent> stateEvents = new ConcurrentLinkedQueue();
    private PeerTaskInstancePriorityQueue readyToSubmitTaskQueue = new PeerTaskInstancePriorityQueue();
    private Map<Long, TaskInstance> waitToRetryTaskInstanceMap = new ConcurrentHashMap<Long, TaskInstance>();
    private StateWheelExecuteThread stateWheelExecuteThread;

    public WorkflowExecuteThread(ProcessInstance processInstance, ProcessService processService, NettyExecutorManager nettyExecutorManager, ProcessAlertManager processAlertManager, MasterConfig masterConfig, StateWheelExecuteThread stateWheelExecuteThread) {
        this.processService = processService;
        this.processInstance = processInstance;
        this.masterConfig = masterConfig;
        this.nettyExecutorManager = nettyExecutorManager;
        this.processAlertManager = processAlertManager;
        this.stateWheelExecuteThread = stateWheelExecuteThread;
    }

    public boolean isStart() {
        return this.isStart;
    }

    public void handleEvents() {
        if (!this.isStart) {
            return;
        }
        while (!this.stateEvents.isEmpty()) {
            try {
                StateEvent stateEvent = this.stateEvents.peek();
                if (!this.stateEventHandler(stateEvent)) continue;
                this.stateEvents.remove(stateEvent);
            }
            catch (Exception e) {
                logger.error("state handle error:", (Throwable)e);
            }
        }
    }

    public String getKey() {
        if (StringUtils.isNotEmpty((String)this.key) || this.processDefinition == null) {
            return this.key;
        }
        this.key = String.format("%d_%d_%d", this.processDefinition.getCode(), this.processDefinition.getVersion(), this.processInstance.getId());
        return this.key;
    }

    public boolean addStateEvent(StateEvent stateEvent) {
        if (this.processInstance.getId() != stateEvent.getProcessInstanceId()) {
            logger.info("state event would be abounded :{}", (Object)stateEvent.toString());
            return false;
        }
        this.stateEvents.add(stateEvent);
        return true;
    }

    public int eventSize() {
        return this.stateEvents.size();
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    private boolean stateEventHandler(StateEvent stateEvent) {
        logger.info("process event: {}", (Object)stateEvent.toString());
        if (!this.checkProcessInstance(stateEvent)) {
            return false;
        }
        boolean result = false;
        switch (stateEvent.getType()) {
            case PROCESS_STATE_CHANGE: {
                result = this.processStateChangeHandler(stateEvent);
                break;
            }
            case TASK_STATE_CHANGE: {
                result = this.taskStateChangeHandler(stateEvent);
                break;
            }
            case PROCESS_TIMEOUT: {
                result = this.processTimeout();
                break;
            }
            case TASK_TIMEOUT: {
                result = this.taskTimeout(stateEvent);
                break;
            }
            case WAIT_TASK_GROUP: {
                result = this.checkForceStartAndWakeUp(stateEvent);
                break;
            }
            case TASK_RETRY: {
                result = this.taskRetryEventHandler(stateEvent);
                break;
            }
            case PROCESS_BLOCKED: {
                result = this.processBlockHandler(stateEvent);
                break;
            }
        }
        if (result) {
            this.stateEvents.remove(stateEvent);
        }
        return result;
    }

    private boolean checkForceStartAndWakeUp(StateEvent stateEvent) {
        boolean acquireTaskGroup;
        TaskGroupQueue taskGroupQueue = this.processService.loadTaskGroupQueue(stateEvent.getTaskInstanceId());
        if (taskGroupQueue.getForceStart() == Flag.YES.getCode()) {
            TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(stateEvent.getTaskInstanceId()));
            ITaskProcessor taskProcessor = this.activeTaskProcessorMaps.get(taskInstance.getTaskCode());
            taskProcessor.action(TaskAction.DISPATCH);
            this.processService.updateTaskGroupQueueStatus(Integer.valueOf(taskGroupQueue.getTaskId()), TaskGroupQueueStatus.ACQUIRE_SUCCESS.getCode());
            return true;
        }
        if (taskGroupQueue.getInQueue() == Flag.YES.getCode() && (acquireTaskGroup = this.processService.acquireTaskGroupAgain(taskGroupQueue))) {
            TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(stateEvent.getTaskInstanceId()));
            ITaskProcessor taskProcessor = this.activeTaskProcessorMaps.get(taskInstance.getTaskCode());
            taskProcessor.action(TaskAction.DISPATCH);
            return true;
        }
        return false;
    }

    private boolean taskTimeout(StateEvent stateEvent) {
        if (!this.checkTaskInstanceByStateEvent(stateEvent)) {
            return true;
        }
        TaskInstance taskInstance = this.taskInstanceMap.get(stateEvent.getTaskInstanceId());
        if (TimeoutFlag.CLOSE == taskInstance.getTaskDefine().getTimeoutFlag()) {
            return true;
        }
        TaskTimeoutStrategy taskTimeoutStrategy = taskInstance.getTaskDefine().getTimeoutNotifyStrategy();
        if (TaskTimeoutStrategy.FAILED == taskTimeoutStrategy || TaskTimeoutStrategy.WARNFAILED == taskTimeoutStrategy) {
            ITaskProcessor taskProcessor = this.activeTaskProcessorMaps.get(taskInstance.getTaskCode());
            taskProcessor.action(TaskAction.TIMEOUT);
        }
        if (TaskTimeoutStrategy.WARN == taskTimeoutStrategy || TaskTimeoutStrategy.WARNFAILED == taskTimeoutStrategy) {
            ProjectUser projectUser = this.processService.queryProjectWithUserByProcessInstanceId(this.processInstance.getId());
            this.processAlertManager.sendTaskTimeoutAlert(this.processInstance, taskInstance, projectUser);
        }
        return true;
    }

    private boolean processTimeout() {
        ProjectUser projectUser = this.processService.queryProjectWithUserByProcessInstanceId(this.processInstance.getId());
        this.processAlertManager.sendProcessTimeoutAlert(this.processInstance, projectUser);
        return true;
    }

    private boolean taskStateChangeHandler(StateEvent stateEvent) {
        if (!this.checkTaskInstanceByStateEvent(stateEvent)) {
            return true;
        }
        TaskInstance task = this.getTaskInstance(stateEvent.getTaskInstanceId());
        if (task.getState() == null) {
            logger.error("task state is null, state handler error: {}", (Object)stateEvent);
            return true;
        }
        if (task.getState().typeIsFinished()) {
            if (this.completeTaskMap.containsKey(task.getTaskCode()) && this.completeTaskMap.get(task.getTaskCode()).intValue() == task.getId()) {
                return true;
            }
            this.taskFinished(task);
            if (task.getTaskGroupId() > 0) {
                this.releaseTaskGroup(task);
            }
            return true;
        }
        if (this.activeTaskProcessorMaps.containsKey(task.getTaskCode())) {
            ITaskProcessor iTaskProcessor = this.activeTaskProcessorMaps.get(task.getTaskCode());
            iTaskProcessor.action(TaskAction.RUN);
            if (iTaskProcessor.taskInstance().getState().typeIsFinished()) {
                if (iTaskProcessor.taskInstance().getState() != task.getState()) {
                    task.setState(iTaskProcessor.taskInstance().getState());
                }
                this.taskFinished(task);
            }
            return true;
        }
        logger.error("state handler error: {}", (Object)stateEvent);
        return true;
    }

    private void taskFinished(TaskInstance taskInstance) {
        logger.info("work flow {} task id:{} code:{} state:{} ", new Object[]{this.processInstance.getId(), taskInstance.getId(), taskInstance.getTaskCode(), taskInstance.getState()});
        this.activeTaskProcessorMaps.remove(taskInstance.getTaskCode());
        this.stateWheelExecuteThread.removeTask4TimeoutCheck(this.processInstance, taskInstance);
        this.stateWheelExecuteThread.removeTask4RetryCheck(this.processInstance, taskInstance);
        this.stateWheelExecuteThread.removeTask4StateCheck(this.processInstance, taskInstance);
        if (taskInstance.getState().typeIsSuccess()) {
            this.completeTaskMap.put(taskInstance.getTaskCode(), taskInstance.getId());
            this.processInstance.setVarPool(taskInstance.getVarPool());
            this.processService.saveProcessInstance(this.processInstance);
            if (!this.processInstance.isBlocked()) {
                this.submitPostNode(Long.toString(taskInstance.getTaskCode()));
            }
        } else if (taskInstance.taskCanRetry() && this.processInstance.getState() != ExecutionStatus.READY_STOP) {
            this.retryTaskInstance(taskInstance);
        } else if (taskInstance.getState().typeIsFailure()) {
            this.completeTaskMap.put(taskInstance.getTaskCode(), taskInstance.getId());
            if (DagHelper.haveAllNodeAfterNode((String)Long.toString(taskInstance.getTaskCode()), this.dag) && this.processInstance.getFailureStrategy() == FailureStrategy.CONTINUE) {
                this.submitPostNode(Long.toString(taskInstance.getTaskCode()));
            } else {
                this.errorTaskMap.put(taskInstance.getTaskCode(), taskInstance.getId());
                if (this.processInstance.getFailureStrategy() == FailureStrategy.END) {
                    this.killAllTasks();
                }
            }
        } else if (taskInstance.getState().typeIsFinished()) {
            this.completeTaskMap.put(taskInstance.getTaskCode(), taskInstance.getId());
        }
        this.updateProcessInstanceState();
    }

    private void releaseTaskGroup(TaskInstance taskInstance) {
        TaskInstance nextTaskInstance;
        if (taskInstance.getTaskGroupId() > 0 && (nextTaskInstance = this.processService.releaseTaskGroup(taskInstance)) != null) {
            if (nextTaskInstance.getProcessInstanceId() == taskInstance.getProcessInstanceId()) {
                StateEvent nextEvent = new StateEvent();
                nextEvent.setProcessInstanceId(this.processInstance.getId());
                nextEvent.setTaskInstanceId(nextTaskInstance.getId());
                nextEvent.setType(StateEventType.WAIT_TASK_GROUP);
                this.stateEvents.add(nextEvent);
            } else {
                ProcessInstance processInstance = this.processService.findProcessInstanceById(nextTaskInstance.getProcessInstanceId());
                this.processService.sendStartTask2Master(processInstance, nextTaskInstance.getId(), org.apache.dolphinscheduler.remote.command.CommandType.TASK_WAKEUP_EVENT_REQUEST);
            }
        }
    }

    private void retryTaskInstance(TaskInstance taskInstance) {
        if (!taskInstance.taskCanRetry()) {
            return;
        }
        TaskInstance newTaskInstance = this.cloneRetryTaskInstance(taskInstance);
        if (newTaskInstance == null) {
            logger.error("retry fail, new taskInstancce is null, task code:{}, task id:{}", (Object)taskInstance.getTaskCode(), (Object)taskInstance.getId());
            return;
        }
        this.waitToRetryTaskInstanceMap.put(newTaskInstance.getTaskCode(), newTaskInstance);
        if (!taskInstance.retryTaskIntervalOverTime()) {
            logger.info("failure task will be submitted: process id: {}, task instance code: {} state:{} retry times:{} / {}, interval:{}", new Object[]{this.processInstance.getId(), newTaskInstance.getTaskCode(), newTaskInstance.getState(), newTaskInstance.getRetryTimes(), newTaskInstance.getMaxRetryTimes(), newTaskInstance.getRetryInterval()});
            this.stateWheelExecuteThread.addTask4TimeoutCheck(this.processInstance, newTaskInstance);
            this.stateWheelExecuteThread.addTask4RetryCheck(this.processInstance, newTaskInstance);
        } else {
            this.addTaskToStandByList(newTaskInstance);
            this.submitStandByTask();
            this.waitToRetryTaskInstanceMap.remove(newTaskInstance.getTaskCode());
        }
    }

    private boolean taskRetryEventHandler(StateEvent stateEvent) {
        TaskInstance taskInstance = this.waitToRetryTaskInstanceMap.get(stateEvent.getTaskCode());
        this.addTaskToStandByList(taskInstance);
        this.submitStandByTask();
        this.waitToRetryTaskInstanceMap.remove(stateEvent.getTaskCode());
        return true;
    }

    public void refreshProcessInstance(int processInstanceId) {
        logger.info("process instance update: {}", (Object)processInstanceId);
        this.processInstance = this.processService.findProcessInstanceById(processInstanceId);
        this.processDefinition = this.processService.findProcessDefinition(this.processInstance.getProcessDefinitionCode(), this.processInstance.getProcessDefinitionVersion());
        this.processInstance.setProcessDefinition(this.processDefinition);
    }

    public void refreshTaskInstance(int taskInstanceId) {
        logger.info("task instance update: {} ", (Object)taskInstanceId);
        TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(taskInstanceId));
        if (taskInstance == null) {
            logger.error("can not find task instance, id:{}", (Object)taskInstanceId);
            return;
        }
        this.processService.packageTaskInstance(taskInstance, this.processInstance);
        this.taskInstanceMap.put(taskInstance.getId(), taskInstance);
        this.validTaskMap.remove(taskInstance.getTaskCode());
        if (Flag.YES == taskInstance.getFlag()) {
            this.validTaskMap.put(taskInstance.getTaskCode(), taskInstance.getId());
        }
    }

    public boolean checkProcessInstance(StateEvent stateEvent) {
        if (this.processInstance.getId() != stateEvent.getProcessInstanceId()) {
            logger.error("mismatch process instance id: {}, state event:{}", (Object)this.processInstance.getId(), (Object)stateEvent);
            return false;
        }
        return true;
    }

    public boolean checkTaskInstanceByStateEvent(StateEvent stateEvent) {
        if (stateEvent.getTaskInstanceId() == 0) {
            logger.error("task instance id null, state event:{}", (Object)stateEvent);
            return false;
        }
        if (!this.taskInstanceMap.containsKey(stateEvent.getTaskInstanceId())) {
            logger.error("mismatch task instance id, event:{}", (Object)stateEvent);
            return false;
        }
        return true;
    }

    public boolean checkTaskInstanceByCode(long taskCode) {
        if (this.taskInstanceMap == null || this.taskInstanceMap.size() == 0) {
            return false;
        }
        for (TaskInstance taskInstance : this.taskInstanceMap.values()) {
            if (taskInstance.getTaskCode() != taskCode) continue;
            return true;
        }
        return false;
    }

    public boolean checkTaskInstanceById(int taskInstanceId) {
        if (this.taskInstanceMap == null || this.taskInstanceMap.size() == 0) {
            return false;
        }
        return this.taskInstanceMap.containsKey(taskInstanceId);
    }

    public TaskInstance getTaskInstance(int taskInstanceId) {
        if (this.taskInstanceMap.containsKey(taskInstanceId)) {
            return this.taskInstanceMap.get(taskInstanceId);
        }
        return null;
    }

    public TaskInstance getTaskInstance(long taskCode) {
        if (this.taskInstanceMap == null || this.taskInstanceMap.size() == 0) {
            return null;
        }
        for (TaskInstance taskInstance : this.taskInstanceMap.values()) {
            if (taskInstance.getTaskCode() != taskCode) continue;
            return taskInstance;
        }
        return null;
    }

    public TaskInstance getActiveTaskInstanceByTaskCode(long taskCode) {
        if (this.activeTaskProcessorMaps.containsKey(taskCode)) {
            return this.activeTaskProcessorMaps.get(taskCode).taskInstance();
        }
        return null;
    }

    public TaskInstance getRetryTaskInstanceByTaskCode(long taskCode) {
        if (this.waitToRetryTaskInstanceMap.containsKey(taskCode)) {
            return this.waitToRetryTaskInstanceMap.get(taskCode);
        }
        return null;
    }

    private boolean processStateChangeHandler(StateEvent stateEvent) {
        try {
            logger.info("process:{} state {} change to {}", new Object[]{this.processInstance.getId(), this.processInstance.getState(), stateEvent.getExecutionStatus()});
            if (stateEvent.getExecutionStatus() == ExecutionStatus.STOP) {
                if (this.processDefinition.getExecutionType().typeIsSerialWait()) {
                    this.endProcess();
                    return true;
                }
                this.updateProcessInstanceState(stateEvent);
                return true;
            }
            if (this.processComplementData()) {
                return true;
            }
            if (stateEvent.getExecutionStatus().typeIsFinished()) {
                this.endProcess();
            }
            if (this.processInstance.getState() == ExecutionStatus.READY_STOP) {
                this.killAllTasks();
            }
            return true;
        }
        catch (Exception e) {
            logger.error("process state change error:", (Throwable)e);
            return true;
        }
    }

    private boolean processBlockHandler(StateEvent stateEvent) {
        try {
            TaskInstance task = this.getTaskInstance(stateEvent.getTaskInstanceId());
            if (!this.checkTaskInstanceByStateEvent(stateEvent)) {
                logger.error("task {} is not a blocking task", (Object)task.getTaskCode());
                return false;
            }
            BlockingParameters parameters = (BlockingParameters)JSONUtils.parseObject((String)task.getTaskParams(), BlockingParameters.class);
            if (parameters.isAlertWhenBlocking()) {
                ProjectUser projectUser = this.processService.queryProjectWithUserByProcessInstanceId(this.processInstance.getId());
                this.processAlertManager.sendProcessBlockingAlert(this.processInstance, projectUser);
                logger.info("processInstance {} block alert send successful!", (Object)this.processInstance.getId());
            }
        }
        catch (Exception e) {
            logger.error("sending blocking message error:", (Throwable)e);
        }
        return true;
    }

    private boolean processComplementData() throws Exception {
        if (!this.needComplementProcess()) {
            return false;
        }
        if (this.processInstance.getState() == ExecutionStatus.READY_STOP) {
            return false;
        }
        Date scheduleDate = this.processInstance.getScheduleTime();
        if (scheduleDate == null) {
            scheduleDate = this.complementListDate.get(0);
        } else if (this.processInstance.getState().typeIsFinished()) {
            this.endProcess();
            if (this.complementListDate.size() <= 0) {
                logger.info("process complement end. process id:{}", (Object)this.processInstance.getId());
                return true;
            }
            int index = this.complementListDate.indexOf(scheduleDate);
            if (index >= this.complementListDate.size() - 1 || !this.processInstance.getState().typeIsSuccess()) {
                logger.info("process complement end. process id:{}", (Object)this.processInstance.getId());
                return true;
            }
            logger.info("process complement continue. process id:{}, schedule time:{} complementListDate:{}", new Object[]{this.processInstance.getId(), this.processInstance.getScheduleTime(), this.complementListDate.toString()});
            scheduleDate = this.complementListDate.get(index + 1);
        }
        int create = this.createComplementDataCommand(scheduleDate);
        if (create > 0) {
            logger.info("create complement data command successfully.");
        }
        return true;
    }

    private int createComplementDataCommand(Date scheduleDate) {
        Command command = new Command();
        command.setScheduleTime(scheduleDate);
        command.setCommandType(CommandType.COMPLEMENT_DATA);
        command.setProcessDefinitionCode(this.processInstance.getProcessDefinitionCode().longValue());
        Map cmdParam = JSONUtils.toMap((String)this.processInstance.getCommandParam());
        if (cmdParam.containsKey("StartNodeIdList")) {
            cmdParam.remove("StartNodeIdList");
        }
        cmdParam.replace("complementStartDate", DateUtils.format((Date)scheduleDate, (String)"yyyy-MM-dd HH:mm:ss", null));
        command.setCommandParam(JSONUtils.toJsonString((Object)cmdParam));
        command.setTaskDependType(this.processInstance.getTaskDependType());
        command.setFailureStrategy(this.processInstance.getFailureStrategy());
        command.setWarningType(this.processInstance.getWarningType());
        command.setWarningGroupId(this.processInstance.getWarningGroupId());
        command.setStartTime(new Date());
        command.setExecutorId(this.processInstance.getExecutorId());
        command.setUpdateTime(new Date());
        command.setProcessInstancePriority(this.processInstance.getProcessInstancePriority());
        command.setWorkerGroup(this.processInstance.getWorkerGroup());
        command.setEnvironmentCode(this.processInstance.getEnvironmentCode());
        command.setDryRun(this.processInstance.getDryRun());
        command.setProcessInstanceId(0);
        command.setProcessDefinitionVersion(this.processInstance.getProcessDefinitionVersion());
        return this.processService.createCommand(command);
    }

    private boolean needComplementProcess() {
        return this.processInstance.isComplementData() && Flag.NO == this.processInstance.getIsSubProcess();
    }

    public void startProcess() {
        if (this.taskInstanceMap.size() > 0) {
            return;
        }
        try {
            this.isStart = false;
            this.buildFlowDag();
            this.initTaskQueue();
            this.submitPostNode(null);
            this.isStart = true;
        }
        catch (Exception e) {
            logger.error("start process error, process instance id:{}", (Object)this.processInstance.getId(), (Object)e);
        }
    }

    public void endProcess() {
        this.stateEvents.clear();
        if (this.processDefinition.getExecutionType().typeIsSerialWait()) {
            this.checkSerialProcess(this.processDefinition);
        }
        if (this.processInstance.getState().typeIsWaitingThread()) {
            this.processService.createRecoveryWaitingThreadCommand(null, this.processInstance);
        }
        if (this.processAlertManager.isNeedToSendWarning(this.processInstance)) {
            ProjectUser projectUser = this.processService.queryProjectWithUserByProcessInstanceId(this.processInstance.getId());
            this.processAlertManager.sendAlertProcessInstance(this.processInstance, this.getValidTaskList(), projectUser);
        }
        if (this.checkTaskQueue()) {
            this.processService.releaseAllTaskGroup(this.processInstance.getId());
        }
    }

    public void checkSerialProcess(ProcessDefinition processDefinition) {
        ProcessInstance nextProcessInstance;
        int nextInstanceId = this.processInstance.getNextProcessInstanceId();
        if (nextInstanceId == 0) {
            nextProcessInstance = this.processService.loadNextProcess4Serial(this.processInstance.getProcessDefinition().getCode(), ExecutionStatus.SERIAL_WAIT.getCode(), this.processInstance.getId());
            if (nextProcessInstance == null) {
                return;
            }
            nextInstanceId = nextProcessInstance.getId();
        }
        if ((nextProcessInstance = this.processService.findProcessInstanceById(nextInstanceId)).getState().typeIsFinished() || nextProcessInstance.getState().typeIsRunning()) {
            return;
        }
        HashMap<String, Integer> cmdParam = new HashMap<String, Integer>();
        cmdParam.put("ProcessInstanceId", nextInstanceId);
        Command command = new Command();
        command.setCommandType(CommandType.RECOVER_SERIAL_WAIT);
        command.setProcessInstanceId(nextProcessInstance.getId());
        command.setProcessDefinitionCode(processDefinition.getCode());
        command.setProcessDefinitionVersion(processDefinition.getVersion());
        command.setCommandParam(JSONUtils.toJsonString(cmdParam));
        this.processService.createCommand(command);
    }

    private void buildFlowDag() throws Exception {
        if (this.dag != null) {
            return;
        }
        this.processDefinition = this.processService.findProcessDefinition(this.processInstance.getProcessDefinitionCode(), this.processInstance.getProcessDefinitionVersion());
        this.processInstance.setProcessDefinition(this.processDefinition);
        List<TaskInstance> recoverNodeList = this.getStartTaskInstanceList(this.processInstance.getCommandParam());
        List processTaskRelations = this.processService.findRelationByCode(this.processDefinition.getCode(), this.processDefinition.getVersion());
        List taskDefinitionLogs = this.processService.getTaskDefineLogListByRelation(processTaskRelations);
        List taskNodeList = this.processService.transformTask(processTaskRelations, taskDefinitionLogs);
        this.forbiddenTaskMap.clear();
        taskNodeList.forEach(taskNode -> {
            if (taskNode.isForbidden().booleanValue()) {
                this.forbiddenTaskMap.put(taskNode.getCode(), (TaskNode)taskNode);
            }
        });
        List<String> recoveryNodeCodeList = this.getRecoveryNodeCodeList(recoverNodeList);
        List<String> startNodeNameList = this.parseStartNodeName(this.processInstance.getCommandParam());
        ProcessDag processDag = this.generateFlowDag(taskNodeList, startNodeNameList, recoveryNodeCodeList, this.processInstance.getTaskDependType());
        if (processDag == null) {
            logger.error("processDag is null");
            return;
        }
        this.dag = DagHelper.buildDagGraph((ProcessDag)processDag);
    }

    private void initTaskQueue() {
        Map cmdParam;
        this.taskFailedSubmit = false;
        this.activeTaskProcessorMaps.clear();
        this.dependFailedTaskMap.clear();
        this.completeTaskMap.clear();
        this.errorTaskMap.clear();
        if (!this.isNewProcessInstance()) {
            List validTaskInstanceList = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.processInstance.getId()));
            for (TaskInstance task : validTaskInstanceList) {
                if (this.validTaskMap.containsKey(task.getTaskCode())) {
                    int oldTaskInstanceId = this.validTaskMap.get(task.getTaskCode());
                    TaskInstance oldTaskInstance = this.taskInstanceMap.get(oldTaskInstanceId);
                    if (!oldTaskInstance.getState().typeIsFinished() && task.getState().typeIsFinished()) {
                        task.setFlag(Flag.NO);
                        this.processService.updateTaskInstance(task);
                        continue;
                    }
                    logger.warn("have same taskCode taskInstance when init task queue, taskCode:{}", (Object)task.getTaskCode());
                }
                this.validTaskMap.put(task.getTaskCode(), task.getId());
                this.taskInstanceMap.put(task.getId(), task);
                if (task.isTaskComplete()) {
                    this.completeTaskMap.put(task.getTaskCode(), task.getId());
                    continue;
                }
                if (task.isConditionsTask() || DagHelper.haveConditionsAfterNode((String)Long.toString(task.getTaskCode()), this.dag)) continue;
                if (task.taskCanRetry()) {
                    if (task.getState() == ExecutionStatus.NEED_FAULT_TOLERANCE) {
                        TaskInstance tolerantTaskInstance = this.cloneTolerantTaskInstance(task);
                        this.addTaskToStandByList(tolerantTaskInstance);
                        continue;
                    }
                    this.retryTaskInstance(task);
                    continue;
                }
                if (!task.getState().typeIsFailure()) continue;
                this.errorTaskMap.put(task.getTaskCode(), task.getId());
            }
        }
        if (this.processInstance.isComplementData() && this.complementListDate.size() == 0 && (cmdParam = JSONUtils.toMap((String)this.processInstance.getCommandParam())) != null && cmdParam.containsKey("complementStartDate")) {
            this.setGlobalParamIfCommanded(this.processDefinition, cmdParam);
            Date start = DateUtils.stringToDate((String)((String)cmdParam.get("complementStartDate")));
            Date end = DateUtils.stringToDate((String)((String)cmdParam.get("complementEndDate")));
            List schedules = this.processService.queryReleaseSchedulerListByProcessDefinitionCode(this.processInstance.getProcessDefinitionCode().longValue());
            if (this.complementListDate.size() == 0 && this.needComplementProcess()) {
                this.complementListDate = CronUtils.getSelfFireDateList((Date)start, (Date)end, (List)schedules);
                logger.info(" process definition code:{} complement data: {}", (Object)this.processInstance.getProcessDefinitionCode(), (Object)this.complementListDate.toString());
                if (this.complementListDate.size() > 0 && Flag.NO == this.processInstance.getIsSubProcess()) {
                    this.processInstance.setScheduleTime(this.complementListDate.get(0));
                    this.processInstance.setGlobalParams(ParameterUtils.curingGlobalParams((Map)this.processDefinition.getGlobalParamMap(), (List)this.processDefinition.getGlobalParamList(), (CommandType)CommandType.COMPLEMENT_DATA, (Date)this.processInstance.getScheduleTime(), (String)((String)cmdParam.get("schedule_timezone"))));
                    this.processService.updateProcessInstance(this.processInstance);
                }
            }
        }
    }

    private TaskInstance submitTaskExec(TaskInstance taskInstance) {
        try {
            boolean submit;
            this.processService.packageTaskInstance(taskInstance, this.processInstance);
            ITaskProcessor taskProcessor = TaskProcessorFactory.getTaskProcessor(taskInstance.getTaskType());
            taskProcessor.init(taskInstance, this.processInstance);
            if (taskInstance.getState() == ExecutionStatus.RUNNING_EXECUTION && taskProcessor.getType().equalsIgnoreCase("common")) {
                this.notifyProcessHostUpdate(taskInstance);
            }
            if (!(submit = taskProcessor.action(TaskAction.SUBMIT))) {
                logger.error("process id:{} name:{} submit standby task id:{} name:{} failed!", new Object[]{this.processInstance.getId(), this.processInstance.getName(), taskInstance.getId(), taskInstance.getName()});
                return null;
            }
            if (this.validTaskMap.containsKey(taskInstance.getTaskCode())) {
                int oldTaskInstanceId = this.validTaskMap.get(taskInstance.getTaskCode());
                if (taskInstance.getId() != oldTaskInstanceId) {
                    TaskInstance oldTaskInstance = this.taskInstanceMap.get(oldTaskInstanceId);
                    oldTaskInstance.setFlag(Flag.NO);
                    this.processService.updateTaskInstance(oldTaskInstance);
                    this.validTaskMap.remove(taskInstance.getTaskCode());
                    this.activeTaskProcessorMaps.remove(taskInstance.getTaskCode());
                }
            }
            this.validTaskMap.put(taskInstance.getTaskCode(), taskInstance.getId());
            this.taskInstanceMap.put(taskInstance.getId(), taskInstance);
            this.activeTaskProcessorMaps.put(taskInstance.getTaskCode(), taskProcessor);
            taskProcessor.action(TaskAction.RUN);
            this.stateWheelExecuteThread.addTask4TimeoutCheck(this.processInstance, taskInstance);
            this.stateWheelExecuteThread.addTask4StateCheck(this.processInstance, taskInstance);
            if (taskProcessor.taskInstance().getState().typeIsFinished()) {
                if (this.processInstance.isBlocked()) {
                    StateEvent processBlockEvent = new StateEvent();
                    processBlockEvent.setProcessInstanceId(this.processInstance.getId());
                    processBlockEvent.setTaskInstanceId(taskInstance.getId());
                    processBlockEvent.setExecutionStatus(taskProcessor.taskInstance().getState());
                    processBlockEvent.setType(StateEventType.PROCESS_BLOCKED);
                    this.stateEvents.add(processBlockEvent);
                }
                StateEvent taskStateChangeEvent = new StateEvent();
                taskStateChangeEvent.setProcessInstanceId(this.processInstance.getId());
                taskStateChangeEvent.setTaskInstanceId(taskInstance.getId());
                taskStateChangeEvent.setExecutionStatus(taskProcessor.taskInstance().getState());
                taskStateChangeEvent.setType(StateEventType.TASK_STATE_CHANGE);
                this.stateEvents.add(taskStateChangeEvent);
            }
            return taskInstance;
        }
        catch (Exception e) {
            logger.error("submit standby task error", (Throwable)e);
            return null;
        }
    }

    private void notifyProcessHostUpdate(TaskInstance taskInstance) {
        if (StringUtils.isEmpty((String)taskInstance.getHost())) {
            return;
        }
        try {
            HostUpdateCommand hostUpdateCommand = new HostUpdateCommand();
            hostUpdateCommand.setProcessHost(NetUtils.getAddr((int)this.masterConfig.getListenPort()));
            hostUpdateCommand.setTaskInstanceId(taskInstance.getId());
            Host host = new Host(taskInstance.getHost());
            this.nettyExecutorManager.doExecute(host, hostUpdateCommand.convert2Command());
        }
        catch (Exception e) {
            logger.error("notify process host update", (Throwable)e);
        }
    }

    private TaskInstance findTaskIfExists(Long taskCode, int taskVersion) {
        List<TaskInstance> validTaskInstanceList = this.getValidTaskList();
        for (TaskInstance taskInstance : validTaskInstanceList) {
            if (taskInstance.getTaskCode() != taskCode.longValue() || taskInstance.getTaskDefinitionVersion() != taskVersion) continue;
            return taskInstance;
        }
        return null;
    }

    private TaskInstance createTaskInstance(ProcessInstance processInstance, TaskNode taskNode) {
        TaskInstance taskInstance = this.findTaskIfExists(taskNode.getCode(), taskNode.getVersion());
        if (taskInstance != null) {
            return taskInstance;
        }
        return this.newTaskInstance(processInstance, taskNode);
    }

    public TaskInstance cloneRetryTaskInstance(TaskInstance taskInstance) {
        TaskNode taskNode = (TaskNode)this.dag.getNode((Object)Long.toString(taskInstance.getTaskCode()));
        if (taskNode == null) {
            logger.error("taskNode is null, code:{}", (Object)taskInstance.getTaskCode());
            return null;
        }
        TaskInstance newTaskInstance = this.newTaskInstance(this.processInstance, taskNode);
        newTaskInstance.setTaskDefine(taskInstance.getTaskDefine());
        newTaskInstance.setProcessDefine(taskInstance.getProcessDefine());
        newTaskInstance.setProcessInstance(this.processInstance);
        newTaskInstance.setRetryTimes(taskInstance.getRetryTimes() + 1);
        newTaskInstance.setState(taskInstance.getState());
        newTaskInstance.setEndTime(taskInstance.getEndTime());
        return newTaskInstance;
    }

    public TaskInstance cloneTolerantTaskInstance(TaskInstance taskInstance) {
        TaskNode taskNode = (TaskNode)this.dag.getNode((Object)Long.toString(taskInstance.getTaskCode()));
        if (taskNode == null) {
            logger.error("taskNode is null, code:{}", (Object)taskInstance.getTaskCode());
            return null;
        }
        TaskInstance newTaskInstance = this.newTaskInstance(this.processInstance, taskNode);
        newTaskInstance.setTaskDefine(taskInstance.getTaskDefine());
        newTaskInstance.setProcessDefine(taskInstance.getProcessDefine());
        newTaskInstance.setProcessInstance(this.processInstance);
        newTaskInstance.setRetryTimes(taskInstance.getRetryTimes());
        newTaskInstance.setState(taskInstance.getState());
        return newTaskInstance;
    }

    public TaskInstance newTaskInstance(ProcessInstance processInstance, TaskNode taskNode) {
        Environment environment;
        Long taskEnvironmentCode;
        TaskInstance taskInstance = new TaskInstance();
        taskInstance.setTaskCode(taskNode.getCode());
        taskInstance.setTaskDefinitionVersion(taskNode.getVersion());
        taskInstance.setName(taskNode.getName());
        taskInstance.setState(ExecutionStatus.SUBMITTED_SUCCESS);
        taskInstance.setProcessInstanceId(processInstance.getId());
        taskInstance.setTaskType(taskNode.getType().toUpperCase());
        taskInstance.setAlertFlag(Flag.NO);
        taskInstance.setStartTime(null);
        taskInstance.setFlag(Flag.YES);
        taskInstance.setDryRun(processInstance.getDryRun());
        taskInstance.setRetryTimes(0);
        taskInstance.setMaxRetryTimes(taskNode.getMaxRetryTimes());
        taskInstance.setRetryInterval(taskNode.getRetryInterval());
        taskInstance.setTaskParams(taskNode.getTaskParams());
        taskInstance.setTaskGroupId(taskNode.getTaskGroupId());
        taskInstance.setTaskGroupPriority(taskNode.getTaskGroupPriority());
        if (taskNode.getTaskInstancePriority() == null) {
            taskInstance.setTaskInstancePriority(Priority.MEDIUM);
        } else {
            taskInstance.setTaskInstancePriority(taskNode.getTaskInstancePriority());
        }
        String processWorkerGroup = processInstance.getWorkerGroup();
        processWorkerGroup = StringUtils.isBlank((String)processWorkerGroup) ? "default" : processWorkerGroup;
        String taskWorkerGroup = StringUtils.isBlank((String)taskNode.getWorkerGroup()) ? processWorkerGroup : taskNode.getWorkerGroup();
        Long processEnvironmentCode = Objects.isNull(processInstance.getEnvironmentCode()) ? -1L : processInstance.getEnvironmentCode();
        Long l = taskEnvironmentCode = Objects.isNull(taskNode.getEnvironmentCode()) ? processEnvironmentCode : taskNode.getEnvironmentCode();
        if (!processWorkerGroup.equals("default") && taskWorkerGroup.equals("default")) {
            taskInstance.setWorkerGroup(processWorkerGroup);
            taskInstance.setEnvironmentCode(processEnvironmentCode);
        } else {
            taskInstance.setWorkerGroup(taskWorkerGroup);
            taskInstance.setEnvironmentCode(taskEnvironmentCode);
        }
        if (!taskInstance.getEnvironmentCode().equals(-1L) && Objects.nonNull(environment = this.processService.findEnvironmentByCode(taskInstance.getEnvironmentCode())) && StringUtils.isNotEmpty((String)environment.getConfig())) {
            taskInstance.setEnvironmentConfig(environment.getConfig());
        }
        taskInstance.setDelayTime(taskNode.getDelayTime());
        return taskInstance;
    }

    public void getPreVarPool(TaskInstance taskInstance, Set<String> preTask) {
        HashMap<String, Property> allProperty = new HashMap<String, Property>();
        HashMap<String, TaskInstance> allTaskInstance = new HashMap<String, TaskInstance>();
        if (CollectionUtils.isNotEmpty(preTask)) {
            for (String preTaskCode : preTask) {
                String preVarPool;
                TaskInstance preTaskInstance;
                Integer taskId = this.completeTaskMap.get(Long.parseLong(preTaskCode));
                if (taskId == null || (preTaskInstance = this.taskInstanceMap.get(taskId)) == null || !StringUtils.isNotEmpty((String)(preVarPool = preTaskInstance.getVarPool()))) continue;
                List properties = JSONUtils.toList((String)preVarPool, Property.class);
                for (Property info : properties) {
                    this.setVarPoolValue(allProperty, allTaskInstance, preTaskInstance, info);
                }
            }
            if (allProperty.size() > 0) {
                taskInstance.setVarPool(JSONUtils.toJsonString(allProperty.values()));
            }
        } else if (StringUtils.isNotEmpty((String)this.processInstance.getVarPool())) {
            taskInstance.setVarPool(this.processInstance.getVarPool());
        }
    }

    private void setVarPoolValue(Map<String, Property> allProperty, Map<String, TaskInstance> allTaskInstance, TaskInstance preTaskInstance, Property thisProperty) {
        thisProperty.setDirect(Direct.IN);
        String proName = thisProperty.getProp();
        if (allProperty.containsKey(proName)) {
            Property otherPro = allProperty.get(proName);
            if (StringUtils.isEmpty((String)thisProperty.getValue())) {
                allProperty.put(proName, otherPro);
            } else if (StringUtils.isNotEmpty((String)otherPro.getValue())) {
                TaskInstance otherTask = allTaskInstance.get(proName);
                if (otherTask.getEndTime().getTime() > preTaskInstance.getEndTime().getTime()) {
                    allProperty.put(proName, thisProperty);
                    allTaskInstance.put(proName, preTaskInstance);
                } else {
                    allProperty.put(proName, otherPro);
                }
            } else {
                allProperty.put(proName, thisProperty);
                allTaskInstance.put(proName, preTaskInstance);
            }
        } else {
            allProperty.put(proName, thisProperty);
            allTaskInstance.put(proName, preTaskInstance);
        }
    }

    private Map<String, TaskInstance> getCompleteTaskInstanceMap() {
        HashMap<String, TaskInstance> completeTaskInstanceMap = new HashMap<String, TaskInstance>();
        for (Integer taskInstanceId : this.completeTaskMap.values()) {
            TaskInstance taskInstance = this.taskInstanceMap.get(taskInstanceId);
            completeTaskInstanceMap.put(Long.toString(taskInstance.getTaskCode()), taskInstance);
        }
        return completeTaskInstanceMap;
    }

    private List<TaskInstance> getValidTaskList() {
        ArrayList<TaskInstance> validTaskInstanceList = new ArrayList<TaskInstance>();
        for (Integer taskInstanceId : this.validTaskMap.values()) {
            validTaskInstanceList.add(this.taskInstanceMap.get(taskInstanceId));
        }
        return validTaskInstanceList;
    }

    private void submitPostNode(String parentNodeCode) {
        TaskInstance endTaskInstance;
        String taskInstanceVarPool;
        Set submitTaskNodeList = DagHelper.parsePostNodes((String)parentNodeCode, this.skipTaskNodeMap, this.dag, this.getCompleteTaskInstanceMap());
        ArrayList<TaskInstance> taskInstances = new ArrayList<TaskInstance>();
        for (String taskNode : submitTaskNodeList) {
            TaskNode taskNodeObject = (TaskNode)this.dag.getNode((Object)taskNode);
            TaskInstance existTaskInstance = this.getTaskInstance(taskNodeObject.getCode());
            if (existTaskInstance != null) {
                taskInstances.add(existTaskInstance);
                continue;
            }
            TaskInstance task = this.createTaskInstance(this.processInstance, taskNodeObject);
            taskInstances.add(task);
        }
        if (StringUtils.isNotEmpty((String)parentNodeCode) && this.dag.getEndNode().contains(parentNodeCode) && StringUtils.isNotEmpty((String)(taskInstanceVarPool = (endTaskInstance = this.taskInstanceMap.get(this.completeTaskMap.get(NumberUtils.toLong((String)parentNodeCode)))).getVarPool()))) {
            Set taskProperties = JSONUtils.toList((String)taskInstanceVarPool, Property.class).stream().collect(Collectors.toSet());
            String processInstanceVarPool = this.processInstance.getVarPool();
            if (StringUtils.isNotEmpty((String)processInstanceVarPool)) {
                Set properties = JSONUtils.toList((String)processInstanceVarPool, Property.class).stream().collect(Collectors.toSet());
                properties.addAll(taskProperties);
                this.processInstance.setVarPool(JSONUtils.toJsonString(properties));
            } else {
                this.processInstance.setVarPool(JSONUtils.toJsonString(taskProperties));
            }
        }
        for (TaskInstance task : taskInstances) {
            if (this.readyToSubmitTaskQueue.contains(task)) continue;
            if (task.getId() > 0 && this.completeTaskMap.containsKey(task.getTaskCode())) {
                logger.info("task {} has already run success", (Object)task.getName());
                continue;
            }
            if (task.getState().typeIsPause() || task.getState().typeIsCancel()) {
                logger.info("task {} stopped, the state is {}", (Object)task.getName(), (Object)task.getState());
                continue;
            }
            this.addTaskToStandByList(task);
        }
        this.submitStandByTask();
        this.updateProcessInstanceState();
    }

    private DependResult isTaskDepsComplete(String taskCode) {
        Collection startNodes = this.dag.getBeginNode();
        if (startNodes.contains(taskCode)) {
            return DependResult.SUCCESS;
        }
        TaskNode taskNode = (TaskNode)this.dag.getNode((Object)taskCode);
        ArrayList<String> indirectDepCodeList = new ArrayList<String>();
        this.setIndirectDepList(taskCode, indirectDepCodeList);
        for (String depsNode : indirectDepCodeList) {
            if (!this.dag.containsNode((Object)depsNode) || this.skipTaskNodeMap.containsKey(depsNode)) continue;
            Long despNodeTaskCode = Long.parseLong(depsNode);
            if (!this.completeTaskMap.containsKey(despNodeTaskCode)) {
                return DependResult.WAITING;
            }
            Integer depsTaskId = this.completeTaskMap.get(despNodeTaskCode);
            ExecutionStatus depTaskState = this.taskInstanceMap.get(depsTaskId).getState();
            if (depTaskState.typeIsPause() || depTaskState.typeIsCancel()) {
                return DependResult.NON_EXEC;
            }
            if (taskNode.isBlockingTask() || taskNode.isConditionsTask() || this.dependTaskSuccess(depsNode, taskCode)) continue;
            return DependResult.FAILED;
        }
        logger.info("taskCode: {} completeDependTaskList: {}", (Object)taskCode, (Object)Arrays.toString(this.completeTaskMap.keySet().toArray()));
        return DependResult.SUCCESS;
    }

    private void setIndirectDepList(String taskCode, List<String> indirectDepCodeList) {
        TaskNode taskNode = (TaskNode)this.dag.getNode((Object)taskCode);
        List depCodeList = taskNode.getDepList();
        for (String depsNode : depCodeList) {
            if (this.forbiddenTaskMap.containsKey(Long.parseLong(depsNode))) {
                this.setIndirectDepList(depsNode, indirectDepCodeList);
                continue;
            }
            indirectDepCodeList.add(depsNode);
        }
    }

    private boolean dependTaskSuccess(String dependNodeName, String nextNodeName) {
        long taskCode;
        Integer taskInstanceId;
        ExecutionStatus depTaskState;
        List nextTaskList;
        return !(((TaskNode)this.dag.getNode((Object)dependNodeName)).isConditionsTask() ? !(nextTaskList = DagHelper.parseConditionTask((String)dependNodeName, this.skipTaskNodeMap, this.dag, this.getCompleteTaskInstanceMap())).contains(nextNodeName) : (depTaskState = this.taskInstanceMap.get(taskInstanceId = this.completeTaskMap.get(taskCode = Long.parseLong(dependNodeName))).getState()).typeIsFailure());
    }

    private List<TaskInstance> getCompleteTaskByState(ExecutionStatus state) {
        ArrayList<TaskInstance> resultList = new ArrayList<TaskInstance>();
        for (Integer taskInstanceId : this.completeTaskMap.values()) {
            TaskInstance taskInstance = this.taskInstanceMap.get(taskInstanceId);
            if (taskInstance == null || taskInstance.getState() != state) continue;
            resultList.add(taskInstance);
        }
        return resultList;
    }

    private ExecutionStatus runningState(ExecutionStatus state) {
        if (state == ExecutionStatus.READY_STOP || state == ExecutionStatus.READY_PAUSE || state == ExecutionStatus.WAITING_THREAD || state == ExecutionStatus.READY_BLOCK || state == ExecutionStatus.DELAY_EXECUTION) {
            return state;
        }
        return ExecutionStatus.RUNNING_EXECUTION;
    }

    private boolean hasFailedTask() {
        if (this.taskFailedSubmit) {
            return true;
        }
        if (this.errorTaskMap.size() > 0) {
            return true;
        }
        return this.dependFailedTaskMap.size() > 0;
    }

    private boolean processFailed() {
        if (this.hasFailedTask()) {
            if (this.processInstance.getFailureStrategy() == FailureStrategy.END) {
                return true;
            }
            if (this.processInstance.getFailureStrategy() == FailureStrategy.CONTINUE) {
                return this.readyToSubmitTaskQueue.size() == 0 && this.activeTaskProcessorMaps.size() == 0 && this.waitToRetryTaskInstanceMap.size() == 0;
            }
        }
        return false;
    }

    private boolean hasWaitingThreadTask() {
        List<TaskInstance> waitingList = this.getCompleteTaskByState(ExecutionStatus.WAITING_THREAD);
        return CollectionUtils.isNotEmpty(waitingList);
    }

    private ExecutionStatus processReadyPause() {
        if (this.hasRetryTaskInStandBy()) {
            return ExecutionStatus.FAILURE;
        }
        List<TaskInstance> pauseList = this.getCompleteTaskByState(ExecutionStatus.PAUSE);
        if (CollectionUtils.isNotEmpty(pauseList) || this.processInstance.isBlocked() || !this.isComplementEnd() || this.readyToSubmitTaskQueue.size() > 0) {
            return ExecutionStatus.PAUSE;
        }
        return ExecutionStatus.SUCCESS;
    }

    private ExecutionStatus processReadyBlock() {
        if (this.activeTaskProcessorMaps.size() > 0) {
            for (ITaskProcessor taskProcessor : this.activeTaskProcessorMaps.values()) {
                if ("BLOCKING".equals(taskProcessor.getType())) continue;
                taskProcessor.action(TaskAction.PAUSE);
            }
        }
        if (this.readyToSubmitTaskQueue.size() > 0) {
            Iterator iter = this.readyToSubmitTaskQueue.iterator();
            while (iter.hasNext()) {
                ((TaskInstance)iter.next()).setState(ExecutionStatus.KILL);
            }
        }
        return ExecutionStatus.BLOCK;
    }

    private ExecutionStatus getProcessInstanceState(ProcessInstance instance) {
        ExecutionStatus state = instance.getState();
        if (this.activeTaskProcessorMaps.size() > 0 || this.hasRetryTaskInStandBy()) {
            return this.runningState(state);
        }
        if (state == ExecutionStatus.READY_BLOCK) {
            return this.processReadyBlock();
        }
        if (this.hasWaitingThreadTask()) {
            return ExecutionStatus.WAITING_THREAD;
        }
        if (state == ExecutionStatus.READY_PAUSE) {
            return this.processReadyPause();
        }
        if (state == ExecutionStatus.READY_STOP) {
            List<TaskInstance> stopList = this.getCompleteTaskByState(ExecutionStatus.STOP);
            List<TaskInstance> killList = this.getCompleteTaskByState(ExecutionStatus.KILL);
            List<TaskInstance> failList = this.getCompleteTaskByState(ExecutionStatus.FAILURE);
            if (CollectionUtils.isNotEmpty(stopList) || CollectionUtils.isNotEmpty(killList) || CollectionUtils.isNotEmpty(failList) || !this.isComplementEnd()) {
                return ExecutionStatus.STOP;
            }
            return ExecutionStatus.SUCCESS;
        }
        if (this.processFailed()) {
            return ExecutionStatus.FAILURE;
        }
        if (state == ExecutionStatus.RUNNING_EXECUTION) {
            List<TaskInstance> killTasks = this.getCompleteTaskByState(ExecutionStatus.KILL);
            if (this.readyToSubmitTaskQueue.size() > 0 || this.waitToRetryTaskInstanceMap.size() > 0) {
                return ExecutionStatus.RUNNING_EXECUTION;
            }
            if (CollectionUtils.isNotEmpty(killTasks)) {
                return ExecutionStatus.FAILURE;
            }
            return ExecutionStatus.SUCCESS;
        }
        return state;
    }

    private boolean isComplementEnd() {
        if (!this.processInstance.isComplementData()) {
            return true;
        }
        try {
            Map cmdParam = JSONUtils.toMap((String)this.processInstance.getCommandParam());
            Date endTime = DateUtils.getScheduleDate((String)((String)cmdParam.get("complementEndDate")));
            return this.processInstance.getScheduleTime().equals(endTime);
        }
        catch (Exception e) {
            logger.error("complement end failed ", (Throwable)e);
            return false;
        }
    }

    private void updateProcessInstanceState() {
        ExecutionStatus state = this.getProcessInstanceState(this.processInstance);
        if (this.processInstance.getState() != state) {
            logger.info("work flow process instance [id: {}, name:{}], state change from {} to {}, cmd type: {}", new Object[]{this.processInstance.getId(), this.processInstance.getName(), this.processInstance.getState(), state, this.processInstance.getCommandType()});
            this.processInstance.setState(state);
            if (state.typeIsFinished()) {
                this.processInstance.setEndTime(new Date());
            }
            this.processService.updateProcessInstance(this.processInstance);
            StateEvent stateEvent = new StateEvent();
            stateEvent.setExecutionStatus(this.processInstance.getState());
            stateEvent.setProcessInstanceId(this.processInstance.getId());
            stateEvent.setType(StateEventType.PROCESS_STATE_CHANGE);
            this.stateEvents.add(stateEvent);
        }
    }

    private void updateProcessInstanceState(StateEvent stateEvent) {
        ExecutionStatus state = stateEvent.getExecutionStatus();
        if (this.processInstance.getState() != state) {
            logger.info("work flow process instance [id: {}, name:{}], state change from {} to {}, cmd type: {}", new Object[]{this.processInstance.getId(), this.processInstance.getName(), this.processInstance.getState(), state, this.processInstance.getCommandType()});
            this.processInstance.setState(state);
            if (state.typeIsFinished()) {
                this.processInstance.setEndTime(new Date());
            }
            this.processService.updateProcessInstance(this.processInstance);
        }
    }

    private DependResult getDependResultForTask(TaskInstance taskInstance) {
        return this.isTaskDepsComplete(Long.toString(taskInstance.getTaskCode()));
    }

    private void addTaskToStandByList(TaskInstance taskInstance) {
        try {
            if (this.readyToSubmitTaskQueue.contains(taskInstance)) {
                logger.warn("task was found in ready submit queue, task code:{}", (Object)taskInstance.getTaskCode());
                return;
            }
            logger.info("add task to stand by list, task name:{}, task id:{}, task code:{}", new Object[]{taskInstance.getName(), taskInstance.getId(), taskInstance.getTaskCode()});
            this.readyToSubmitTaskQueue.put(taskInstance);
        }
        catch (Exception e) {
            logger.error("add task instance to readyToSubmitTaskQueue, taskName:{}, task id:{}", new Object[]{taskInstance.getName(), taskInstance.getId(), e});
        }
    }

    private void removeTaskFromStandbyList(TaskInstance taskInstance) {
        logger.info("remove task from stand by list, id: {} name:{}", (Object)taskInstance.getId(), (Object)taskInstance.getName());
        try {
            this.readyToSubmitTaskQueue.remove(taskInstance);
        }
        catch (Exception e) {
            logger.error("remove task instance from readyToSubmitTaskQueue error, task id:{}, Name: {}", new Object[]{taskInstance.getId(), taskInstance.getName(), e});
        }
    }

    private boolean hasRetryTaskInStandBy() {
        Iterator iter = this.readyToSubmitTaskQueue.iterator();
        while (iter.hasNext()) {
            if (!((TaskInstance)iter.next()).getState().typeIsFailure()) continue;
            return true;
        }
        return false;
    }

    private void killAllTasks() {
        logger.info("kill called on process instance id: {}, num: {}", (Object)this.processInstance.getId(), (Object)this.activeTaskProcessorMaps.size());
        if (this.readyToSubmitTaskQueue.size() > 0) {
            this.readyToSubmitTaskQueue.clear();
        }
        for (long taskCode : this.activeTaskProcessorMaps.keySet()) {
            TaskInstance taskInstance;
            ITaskProcessor taskProcessor = this.activeTaskProcessorMaps.get(taskCode);
            Integer taskInstanceId = this.validTaskMap.get(taskCode);
            if (taskInstanceId == null || taskInstanceId.equals(0) || (taskInstance = this.processService.findTaskInstanceById(taskInstanceId)) == null || taskInstance.getState().typeIsFinished()) continue;
            taskProcessor.action(TaskAction.STOP);
            if (!taskProcessor.taskInstance().getState().typeIsFinished()) continue;
            StateEvent stateEvent = new StateEvent();
            stateEvent.setType(StateEventType.TASK_STATE_CHANGE);
            stateEvent.setProcessInstanceId(this.processInstance.getId());
            stateEvent.setTaskInstanceId(taskInstance.getId());
            stateEvent.setExecutionStatus(taskProcessor.taskInstance().getState());
            this.addStateEvent(stateEvent);
        }
    }

    public boolean workFlowFinish() {
        return this.processInstance.getState().typeIsFinished();
    }

    private void submitStandByTask() {
        try {
            int length = this.readyToSubmitTaskQueue.size();
            for (int i = 0; i < length; ++i) {
                DependResult dependResult;
                TaskInstance retryTask;
                TaskInstance task = this.readyToSubmitTaskQueue.peek();
                if (task == null) continue;
                if (task.taskCanRetry() && (retryTask = this.processService.findTaskInstanceById(Integer.valueOf(task.getId()))) != null && retryTask.getState().equals((Object)ExecutionStatus.FORCED_SUCCESS)) {
                    task.setState(retryTask.getState());
                    logger.info("task: {} has been forced success, put it into complete task list and stop retrying", (Object)task.getName());
                    this.removeTaskFromStandbyList(task);
                    this.completeTaskMap.put(task.getTaskCode(), task.getId());
                    this.taskInstanceMap.put(task.getId(), task);
                    this.submitPostNode(Long.toString(task.getTaskCode()));
                    continue;
                }
                if (task.isFirstRun()) {
                    Set preTask = this.dag.getPreviousNodes((Object)Long.toString(task.getTaskCode()));
                    this.getPreVarPool(task, preTask);
                }
                if (DependResult.SUCCESS == (dependResult = this.getDependResultForTask(task))) {
                    TaskInstance taskInstance = this.submitTaskExec(task);
                    if (taskInstance == null) {
                        this.taskFailedSubmit = true;
                        this.removeTaskFromStandbyList(task);
                        this.completeTaskMap.put(task.getTaskCode(), task.getId());
                        this.errorTaskMap.put(task.getTaskCode(), task.getId());
                        logger.error("process {}, task {}, code:{} submit task failed.", new Object[]{task.getProcessInstanceId(), task.getName(), task.getTaskCode()});
                        continue;
                    }
                    this.removeTaskFromStandbyList(task);
                    continue;
                }
                if (DependResult.FAILED == dependResult) {
                    this.dependFailedTaskMap.put(task.getTaskCode(), task.getId());
                    this.removeTaskFromStandbyList(task);
                    logger.info("task {},id:{} depend result : {}", new Object[]{task.getName(), task.getId(), dependResult});
                    continue;
                }
                if (DependResult.NON_EXEC != dependResult) continue;
                this.removeTaskFromStandbyList(task);
                logger.info("remove task {},id:{} , because depend result : {}", new Object[]{task.getName(), task.getId(), dependResult});
            }
        }
        catch (Exception e) {
            logger.error("submit standby task error", (Throwable)e);
        }
    }

    private List<TaskInstance> getRecoverTaskInstanceList(String[] taskIdArray) {
        if (taskIdArray == null || taskIdArray.length == 0) {
            return new ArrayList<TaskInstance>();
        }
        ArrayList<Integer> taskIdList = new ArrayList<Integer>(taskIdArray.length);
        for (String taskId : taskIdArray) {
            try {
                Integer id = Integer.valueOf(taskId);
                taskIdList.add(id);
            }
            catch (Exception e) {
                logger.error("get recovery task instance failed ", (Throwable)e);
            }
        }
        return this.processService.findTaskInstanceByIdList(taskIdList);
    }

    private List<TaskInstance> getStartTaskInstanceList(String cmdParam) {
        List<TaskInstance> instanceList = new ArrayList<TaskInstance>();
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap != null && paramMap.containsKey("StartNodeIdList")) {
            String[] idList = ((String)paramMap.get("StartNodeIdList")).split(",");
            instanceList = this.getRecoverTaskInstanceList(idList);
        }
        return instanceList;
    }

    private List<String> parseStartNodeName(String cmdParam) {
        List<String> startNodeNameList = new ArrayList<String>();
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap == null) {
            return startNodeNameList;
        }
        if (paramMap.containsKey("StartNodeList")) {
            startNodeNameList = Arrays.asList(((String)paramMap.get("StartNodeList")).split(","));
        }
        return startNodeNameList;
    }

    private List<String> getRecoveryNodeCodeList(List<TaskInstance> recoverNodeList) {
        ArrayList<String> recoveryNodeCodeList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(recoverNodeList)) {
            for (TaskInstance task : recoverNodeList) {
                recoveryNodeCodeList.add(Long.toString(task.getTaskCode()));
            }
        }
        return recoveryNodeCodeList;
    }

    public ProcessDag generateFlowDag(List<TaskNode> totalTaskNodeList, List<String> startNodeNameList, List<String> recoveryNodeCodeList, TaskDependType depNodeType) throws Exception {
        return DagHelper.generateFlowDag(totalTaskNodeList, startNodeNameList, recoveryNodeCodeList, (TaskDependType)depNodeType);
    }

    private boolean checkTaskQueue() {
        AtomicBoolean result = new AtomicBoolean(false);
        this.taskInstanceMap.forEach((id, taskInstance) -> {
            if (taskInstance != null && taskInstance.getTaskGroupId() > 0) {
                result.set(true);
            }
        });
        return result.get();
    }

    private boolean isNewProcessInstance() {
        if (ExecutionStatus.RUNNING_EXECUTION == this.processInstance.getState() && this.processInstance.getRunTimes() == 1) {
            return true;
        }
        if (this.processInstance.getRecovery().equals((Object)Flag.YES)) {
            return false;
        }
        return false;
    }

    private void setGlobalParamIfCommanded(ProcessDefinition processDefinition, Map<String, String> cmdParam) {
        Map startParamMap = new HashMap();
        if (cmdParam.containsKey("StartParams")) {
            String startParamJson = cmdParam.get("StartParams");
            startParamMap = JSONUtils.toMap((String)startParamJson);
        }
        Map fatherParamMap = new HashMap();
        if (cmdParam.containsKey("fatherParams")) {
            String fatherParamJson = cmdParam.get("fatherParams");
            fatherParamMap = JSONUtils.toMap((String)fatherParamJson);
        }
        startParamMap.putAll(fatherParamMap);
        Map globalMap = processDefinition.getGlobalParamMap();
        List globalParamList = processDefinition.getGlobalParamList();
        if (startParamMap.size() > 0 && globalMap != null) {
            for (Map.Entry entry : globalMap.entrySet()) {
                String val = (String)startParamMap.get(entry.getKey());
                if (val == null) continue;
                entry.setValue(val);
            }
            for (Map.Entry entry : startParamMap.entrySet()) {
                if (globalMap.containsKey(entry.getKey())) continue;
                globalMap.put(entry.getKey(), entry.getValue());
                globalParamList.add(new Property((String)entry.getKey(), Direct.IN, DataType.VARCHAR, (String)entry.getValue()));
            }
        }
    }
}

