/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cache.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import lombok.NonNull;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.metrics.ProcessInstanceMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.springframework.stereotype.Component;

@Component
public class ProcessInstanceExecCacheManagerImpl
implements ProcessInstanceExecCacheManager {
    private final ConcurrentHashMap<Integer, WorkflowExecuteRunnable> processInstanceExecMaps = new ConcurrentHashMap();

    @PostConstruct
    public void registerMetrics() {
        ProcessInstanceMetrics.registerProcessInstanceRunningGauge(this.processInstanceExecMaps::size);
    }

    @Override
    public WorkflowExecuteRunnable getByProcessInstanceId(int processInstanceId) {
        return this.processInstanceExecMaps.get(processInstanceId);
    }

    @Override
    public boolean contains(int processInstanceId) {
        return this.processInstanceExecMaps.containsKey(processInstanceId);
    }

    @Override
    public void removeByProcessInstanceId(int processInstanceId) {
        this.processInstanceExecMaps.remove(processInstanceId);
    }

    @Override
    public void cache(int processInstanceId, @NonNull WorkflowExecuteRunnable workflowExecuteThread) {
        if (workflowExecuteThread == null) {
            throw new NullPointerException("workflowExecuteThread is marked non-null but is null");
        }
        this.processInstanceExecMaps.put(processInstanceId, workflowExecuteThread);
    }

    @Override
    public Collection<WorkflowExecuteRunnable> getAll() {
        return ImmutableList.copyOf(this.processInstanceExecMaps.values());
    }
}

