/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import com.google.auto.service.AutoService;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleError;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.metrics.TaskMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.apache.dolphinscheduler.server.master.runner.task.TaskAction;

@AutoService(value={StateEventHandler.class})
public class TaskTimeoutStateEventHandler
implements StateEventHandler {
    @Override
    public boolean handleStateEvent(WorkflowExecuteRunnable workflowExecuteRunnable, StateEvent stateEvent) throws StateEventHandleError {
        TaskMetrics.incTaskTimeout();
        workflowExecuteRunnable.checkTaskInstanceByStateEvent(stateEvent);
        TaskInstance taskInstance = workflowExecuteRunnable.getTaskInstance(stateEvent.getTaskInstanceId()).get();
        if (TimeoutFlag.CLOSE == taskInstance.getTaskDefine().getTimeoutFlag()) {
            return true;
        }
        TaskTimeoutStrategy taskTimeoutStrategy = taskInstance.getTaskDefine().getTimeoutNotifyStrategy();
        Map<Long, ITaskProcessor> activeTaskProcessMap = workflowExecuteRunnable.getActiveTaskProcessMap();
        if (TaskTimeoutStrategy.FAILED == taskTimeoutStrategy || TaskTimeoutStrategy.WARNFAILED == taskTimeoutStrategy) {
            ITaskProcessor taskProcessor = activeTaskProcessMap.get(taskInstance.getTaskCode());
            taskProcessor.action(TaskAction.TIMEOUT);
        }
        if (TaskTimeoutStrategy.WARN == taskTimeoutStrategy || TaskTimeoutStrategy.WARNFAILED == taskTimeoutStrategy) {
            workflowExecuteRunnable.processTimeout();
            workflowExecuteRunnable.taskTimeout(taskInstance);
        }
        return true;
    }

    @Override
    public StateEventType getEventType() {
        return StateEventType.TASK_TIMEOUT;
    }
}

