/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import com.google.auto.service.AutoService;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.plugin.task.api.enums.ExecutionStatus;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleException;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.metrics.ProcessInstanceMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={StateEventHandler.class})
public class WorkflowStateEventHandler
implements StateEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowStateEventHandler.class);

    @Override
    public boolean handleStateEvent(WorkflowExecuteRunnable workflowExecuteRunnable, StateEvent stateEvent) throws StateEventHandleException {
        this.measureProcessState(stateEvent);
        ProcessInstance processInstance = workflowExecuteRunnable.getProcessInstance();
        ProcessDefinition processDefinition = processInstance.getProcessDefinition();
        logger.info("Handle workflow instance state event, the current workflow instance state {} will be changed to {}", (Object)processInstance.getState(), (Object)stateEvent.getExecutionStatus());
        if (stateEvent.getExecutionStatus() == ExecutionStatus.STOP) {
            if (processDefinition.getExecutionType().typeIsSerialWait() || processDefinition.getExecutionType().typeIsSerialPriority()) {
                workflowExecuteRunnable.endProcess();
                return true;
            }
            workflowExecuteRunnable.updateProcessInstanceState(stateEvent);
            return true;
        }
        if (workflowExecuteRunnable.processComplementData()) {
            return true;
        }
        if (stateEvent.getExecutionStatus().typeIsFinished()) {
            workflowExecuteRunnable.endProcess();
        }
        if (processInstance.getState() == ExecutionStatus.READY_STOP) {
            workflowExecuteRunnable.killAllTasks();
        }
        return true;
    }

    @Override
    public StateEventType getEventType() {
        return StateEventType.PROCESS_STATE_CHANGE;
    }

    private void measureProcessState(StateEvent processStateEvent) {
        if (processStateEvent.getExecutionStatus().typeIsFinished()) {
            ProcessInstanceMetrics.incProcessInstanceFinish();
        }
        switch (processStateEvent.getExecutionStatus()) {
            case STOP: {
                ProcessInstanceMetrics.incProcessInstanceStop();
                break;
            }
            case SUCCESS: {
                ProcessInstanceMetrics.incProcessInstanceSuccess();
                break;
            }
            case FAILURE: {
                ProcessInstanceMetrics.incProcessInstanceFailure();
                break;
            }
        }
    }
}

