/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class ProcessInstanceMetrics {
    private static final Timer COMMAND_QUERY_TIMETER = Timer.builder((String)"ds.workflow.command.query.duration").description("Command query duration").register((MeterRegistry)Metrics.globalRegistry);
    private static final Timer PROCESS_INSTANCE_GENERATE_TIMER = Timer.builder((String)"ds.workflow.instance.generate.duration").description("Process instance generated duration").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter PROCESS_INSTANCE_SUBMIT_COUNTER = Counter.builder((String)"ds.workflow.instance.submit.count").description("Process instance submit total count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter PROCESS_INSTANCE_TIMEOUT_COUNTER = Counter.builder((String)"ds.workflow.instance.timeout.count").description("Process instance timeout total count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter PROCESS_INSTANCE_FINISH_COUNTER = Counter.builder((String)"dolphinscheduler_process_instance_finish_count").description("Process instance finish total count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter PROCESS_INSTANCE_SUCCESS_COUNTER = Counter.builder((String)"dolphinscheduler_process_instance_success_count").description("Process instance success total count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter PROCESS_INSTANCE_FAILURE_COUNTER = Counter.builder((String)"dolphinscheduler_process_instance_failure_count").description("Process instance failure total count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter PROCESS_INSTANCE_STOP_COUNTER = Counter.builder((String)"ds.workflow.instance.stop.count").description("Process instance stop total count").register((MeterRegistry)Metrics.globalRegistry);
    private static final Counter PROCESS_INSTANCE_FAILOVER_COUNTER = Counter.builder((String)"ds.workflow.instance.failover.count").description("Process instance failover total count").register((MeterRegistry)Metrics.globalRegistry);

    private ProcessInstanceMetrics() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void recordCommandQueryTime(long milliseconds) {
        COMMAND_QUERY_TIMETER.record(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static void recordProcessInstanceGenerateTime(long milliseconds) {
        PROCESS_INSTANCE_GENERATE_TIMER.record(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static synchronized void registerProcessInstanceRunningGauge(Supplier<Number> function) {
        Gauge.builder((String)"ds.workflow.instance.running", function).description("The current running process instance count").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static synchronized void registerProcessInstanceResubmitGauge(Supplier<Number> function) {
        Gauge.builder((String)"ds.workflow.instance.resubmit", function).description("The current process instance need to resubmit count").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void incProcessInstanceSubmit() {
        PROCESS_INSTANCE_SUBMIT_COUNTER.increment();
    }

    public static void incProcessInstanceTimeout() {
        PROCESS_INSTANCE_TIMEOUT_COUNTER.increment();
    }

    public static void incProcessInstanceFinish() {
        PROCESS_INSTANCE_FINISH_COUNTER.increment();
    }

    public static void incProcessInstanceSuccess() {
        PROCESS_INSTANCE_SUCCESS_COUNTER.increment();
    }

    public static void incProcessInstanceFailure() {
        PROCESS_INSTANCE_FAILURE_COUNTER.increment();
    }

    public static void incProcessInstanceStop() {
        PROCESS_INSTANCE_STOP_COUNTER.increment();
    }

    public static void incProcessInstanceFailover() {
        PROCESS_INSTANCE_FAILOVER_COUNTER.increment();
    }
}

