/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor.queue;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskExecuteThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskEventService {
    private final Logger logger = LoggerFactory.getLogger(TaskEventService.class);
    private final BlockingQueue<TaskEvent> eventQueue = new LinkedBlockingQueue<TaskEvent>();
    private Thread taskEventThread;
    private Thread taskEventHandlerThread;
    @Autowired
    private TaskExecuteThreadPool taskExecuteThreadPool;

    @PostConstruct
    public void start() {
        this.taskEventThread = new TaskEventDispatchThread();
        this.logger.info("TaskEvent dispatch thread starting");
        this.taskEventThread.start();
        this.logger.info("TaskEvent dispatch thread started");
        this.taskEventHandlerThread = new TaskEventHandlerThread();
        this.logger.info("TaskEvent handle thread staring");
        this.taskEventHandlerThread.start();
        this.logger.info("TaskEvent handle thread started");
    }

    @PreDestroy
    public void stop() {
        try {
            this.taskEventThread.interrupt();
            this.taskEventHandlerThread.interrupt();
            if (!this.eventQueue.isEmpty()) {
                ArrayList remainEvents = new ArrayList(this.eventQueue.size());
                this.eventQueue.drainTo(remainEvents);
                for (TaskEvent taskEvent : remainEvents) {
                    this.taskExecuteThreadPool.submitTaskEvent(taskEvent);
                }
                this.taskExecuteThreadPool.eventHandler();
            }
        }
        catch (Exception e) {
            this.logger.error("TaskEventService stop error:", (Throwable)e);
        }
    }

    public void addEvent(TaskEvent taskEvent) {
        this.eventQueue.add(taskEvent);
    }

    class TaskEventDispatchThread
    extends BaseDaemonThread {
        protected TaskEventDispatchThread() {
            super("TaskEventLoopThread");
        }

        public void run() {
            while (Stopper.isRunning()) {
                try {
                    TaskEvent taskEvent = (TaskEvent)TaskEventService.this.eventQueue.take();
                    TaskEventService.this.taskExecuteThreadPool.submitTaskEvent(taskEvent);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    TaskEventService.this.logger.error("persist task error", (Throwable)e);
                }
            }
            TaskEventService.this.logger.info("StateEventResponseWorker stopped");
        }
    }

    class TaskEventHandlerThread
    extends BaseDaemonThread {
        protected TaskEventHandlerThread() {
            super("TaskEventHandlerThread");
        }

        public void run() {
            TaskEventService.this.logger.info("event handler thread started");
            while (Stopper.isRunning()) {
                try {
                    TaskEventService.this.taskExecuteThreadPool.eventHandler();
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    TaskEventService.this.logger.warn("TaskEvent handle thread interrupted, will return this loop");
                    break;
                }
                catch (Exception e) {
                    TaskEventService.this.logger.error("event handler thread error", (Throwable)e);
                }
            }
        }
    }
}

