/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.rpc;

import javax.annotation.PostConstruct;
import org.apache.dolphinscheduler.remote.NettyRemotingServer;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.log.LoggerRequestProcessor;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.processor.CacheProcessor;
import org.apache.dolphinscheduler.server.master.processor.StateEventProcessor;
import org.apache.dolphinscheduler.server.master.processor.TaskEventProcessor;
import org.apache.dolphinscheduler.server.master.processor.TaskExecuteResponseProcessor;
import org.apache.dolphinscheduler.server.master.processor.TaskExecuteRunningProcessor;
import org.apache.dolphinscheduler.server.master.processor.TaskKillResponseProcessor;
import org.apache.dolphinscheduler.server.master.processor.WorkflowExecutingDataRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MasterRPCServer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MasterRPCServer.class);
    private NettyRemotingServer nettyRemotingServer;
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private TaskExecuteRunningProcessor taskExecuteRunningProcessor;
    @Autowired
    private TaskExecuteResponseProcessor taskExecuteResponseProcessor;
    @Autowired
    private TaskEventProcessor taskEventProcessor;
    @Autowired
    private StateEventProcessor stateEventProcessor;
    @Autowired
    private CacheProcessor cacheProcessor;
    @Autowired
    private TaskKillResponseProcessor taskKillResponseProcessor;
    @Autowired
    private LoggerRequestProcessor loggerRequestProcessor;
    @Autowired
    private WorkflowExecutingDataRequestProcessor workflowExecutingDataRequestProcessor;

    @PostConstruct
    private void init() {
        NettyServerConfig serverConfig = new NettyServerConfig();
        serverConfig.setListenPort(this.masterConfig.getListenPort());
        this.nettyRemotingServer = new NettyRemotingServer(serverConfig);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_RUNNING, (NettyRequestProcessor)this.taskExecuteRunningProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_RESULT, (NettyRequestProcessor)this.taskExecuteResponseProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_KILL_RESPONSE, (NettyRequestProcessor)this.taskKillResponseProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.STATE_EVENT_REQUEST, (NettyRequestProcessor)this.stateEventProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_FORCE_STATE_EVENT_REQUEST, (NettyRequestProcessor)this.taskEventProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_WAKEUP_EVENT_REQUEST, (NettyRequestProcessor)this.taskEventProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.CACHE_EXPIRE, (NettyRequestProcessor)this.cacheProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.WORKFLOW_EXECUTING_DATA_REQUEST, (NettyRequestProcessor)this.workflowExecutingDataRequestProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.GET_LOG_BYTES_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.ROLL_VIEW_LOG_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.VIEW_WHOLE_LOG_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.registerProcessor(CommandType.REMOVE_TAK_LOG_REQUEST, (NettyRequestProcessor)this.loggerRequestProcessor);
        this.nettyRemotingServer.start();
    }

    public void start() {
        logger.info("Starting Master RPC Server...");
        this.nettyRemotingServer.start();
        logger.info("Started Master RPC Server...");
    }

    @Override
    public void close() {
        logger.info("Closing Master RPC Server...");
        this.nettyRemotingServer.close();
        logger.info("Closed Master RPC Server...");
    }
}

