/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.service.MasterFailoverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FailoverExecuteThread
extends BaseDaemonThread {
    private static final Logger logger = LoggerFactory.getLogger(FailoverExecuteThread.class);
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private MasterFailoverService masterFailoverService;

    protected FailoverExecuteThread() {
        super("FailoverExecuteThread");
    }

    public synchronized void start() {
        logger.info("Master failover thread staring");
        super.start();
        logger.info("Master failover thread stared");
    }

    public void run() {
        ThreadUtils.sleep((long)10000L);
        while (Stopper.isRunning()) {
            try {
                this.masterFailoverService.checkMasterFailover();
            }
            catch (Exception e) {
                logger.error("Master failover thread execute error", (Throwable)e);
            }
            finally {
                ThreadUtils.sleep((long)this.masterConfig.getFailoverInterval().toMillis());
            }
        }
    }
}

