/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskProcessorFactory {
    private static final Logger logger = LoggerFactory.getLogger(TaskProcessorFactory.class);
    public static final Map<String, Constructor<ITaskProcessor>> PROCESS_MAP = new ConcurrentHashMap<String, Constructor<ITaskProcessor>>();
    private static final String DEFAULT_PROCESSOR = "common";

    public static ITaskProcessor getTaskProcessor(String type) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor<ITaskProcessor> iTaskProcessorConstructor;
        if (StringUtils.isEmpty((CharSequence)type)) {
            type = DEFAULT_PROCESSOR;
        }
        if ((iTaskProcessorConstructor = PROCESS_MAP.get(type)) == null) {
            iTaskProcessorConstructor = PROCESS_MAP.get(DEFAULT_PROCESSOR);
        }
        return iTaskProcessorConstructor.newInstance(new Object[0]);
    }

    public static boolean isMasterTask(String type) {
        return PROCESS_MAP.containsKey(type);
    }

    private TaskProcessorFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (ITaskProcessor iTaskProcessor : ServiceLoader.load(ITaskProcessor.class)) {
            try {
                PROCESS_MAP.put(iTaskProcessor.getType(), iTaskProcessor.getClass().getConstructor(new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("The task processor should has a no args constructor", e);
            }
        }
    }
}

