/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskRejectCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEventService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskRecallProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskRecallProcessor.class);
    @Autowired
    private TaskEventService taskEventService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_REJECT == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskRejectCommand recallCommand = (TaskRejectCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskRejectCommand.class);
        TaskEvent taskEvent = TaskEvent.newRecallEvent(recallCommand, channel);
        try {
            LoggerUtils.setWorkflowAndTaskInstanceIDMDC((int)recallCommand.getProcessInstanceId(), (int)recallCommand.getTaskInstanceId());
            this.logger.info("Receive task recall command: {}", (Object)recallCommand);
            this.taskEventService.addEvent(taskEvent);
        }
        finally {
            LoggerUtils.removeWorkflowAndTaskInstanceIdMDC();
        }
    }
}

