/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor.queue;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.remote.command.StateEventResponseCommand;
import org.apache.dolphinscheduler.server.master.cache.ProcessInstanceExecCacheManager;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StateEventResponseService {
    private final Logger logger = LoggerFactory.getLogger(StateEventResponseService.class);
    private final BlockingQueue<StateEvent> eventQueue = new LinkedBlockingQueue<StateEvent>(5000);
    private Thread responseWorker;
    @Autowired
    private ProcessInstanceExecCacheManager processInstanceExecCacheManager;
    @Autowired
    private WorkflowExecuteThreadPool workflowExecuteThreadPool;

    @PostConstruct
    public void start() {
        this.responseWorker = new StateEventResponseWorker();
        this.responseWorker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stop() {
        this.responseWorker.interrupt();
        if (!this.eventQueue.isEmpty()) {
            ArrayList remainEvents = new ArrayList(this.eventQueue.size());
            this.eventQueue.drainTo(remainEvents);
            for (StateEvent event : remainEvents) {
                try {
                    LoggerUtils.setWorkflowAndTaskInstanceIDMDC((int)event.getProcessInstanceId(), (int)event.getTaskInstanceId());
                    this.persist(event);
                }
                finally {
                    LoggerUtils.removeWorkflowAndTaskInstanceIdMDC();
                }
            }
        }
    }

    public void addStateChangeEvent(StateEvent stateEvent) {
        try {
            this.eventQueue.put(stateEvent);
        }
        catch (InterruptedException e) {
            this.logger.error("Put state event : {} error", (Object)stateEvent, (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    private void writeResponse(StateEvent stateEvent) {
        Channel channel = stateEvent.getChannel();
        if (channel != null) {
            StateEventResponseCommand command = new StateEventResponseCommand(stateEvent.getKey());
            channel.writeAndFlush((Object)command.convert2Command());
        }
    }

    private void persist(StateEvent stateEvent) {
        try {
            if (!this.processInstanceExecCacheManager.contains(stateEvent.getProcessInstanceId())) {
                this.logger.warn("Persist event into workflow execute thread error, cannot find the workflow instance from cache manager, event: {}", (Object)stateEvent);
                this.writeResponse(stateEvent);
                return;
            }
            WorkflowExecuteRunnable workflowExecuteThread = this.processInstanceExecCacheManager.getByProcessInstanceId(stateEvent.getProcessInstanceId());
            switch (stateEvent.getType()) {
                case TASK_STATE_CHANGE: {
                    workflowExecuteThread.refreshTaskInstance(stateEvent.getTaskInstanceId());
                    break;
                }
                case PROCESS_STATE_CHANGE: {
                    workflowExecuteThread.refreshProcessInstance(stateEvent.getProcessInstanceId());
                    break;
                }
            }
            this.workflowExecuteThreadPool.submitStateEvent(stateEvent);
            this.writeResponse(stateEvent);
        }
        catch (Exception e) {
            this.logger.error("Persist event queue error, event: {}", (Object)stateEvent, (Object)e);
        }
    }

    public void addEvent2WorkflowExecute(StateEvent stateEvent) {
        this.workflowExecuteThreadPool.submitStateEvent(stateEvent);
    }

    class StateEventResponseWorker
    extends BaseDaemonThread {
        protected StateEventResponseWorker() {
            super("StateEventResponseWorker");
        }

        public void run() {
            StateEventResponseService.this.logger.info("State event loop service started");
            while (!ServerLifeCycleManager.isStopped()) {
                try {
                    StateEvent stateEvent = (StateEvent)StateEventResponseService.this.eventQueue.take();
                    LoggerUtils.setWorkflowAndTaskInstanceIDMDC((int)stateEvent.getProcessInstanceId(), (int)stateEvent.getTaskInstanceId());
                    StateEventResponseService.this.persist(stateEvent);
                }
                catch (InterruptedException e) {
                    StateEventResponseService.this.logger.warn("State event loop service interrupted, will stop this loop", (Throwable)e);
                    Thread.currentThread().interrupt();
                    break;
                }
                finally {
                    LoggerUtils.removeWorkflowAndTaskInstanceIdMDC();
                }
            }
            StateEventResponseService.this.logger.info("State event loop service stopped");
        }
    }
}

