/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;

public class TaskInstanceKey {
    private final int processInstanceId;
    private final long taskCode;
    private final int taskVersion;

    public static TaskInstanceKey getTaskInstanceKey(@NonNull ProcessInstance processInstance, @NonNull TaskInstance taskInstance) {
        if (processInstance == null) {
            throw new NullPointerException("processInstance is marked non-null but is null");
        }
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        return new TaskInstanceKey(processInstance.getId(), taskInstance.getTaskCode(), taskInstance.getTaskDefinitionVersion());
    }

    @Generated
    public int getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Generated
    public long getTaskCode() {
        return this.taskCode;
    }

    @Generated
    public int getTaskVersion() {
        return this.taskVersion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskInstanceKey)) {
            return false;
        }
        TaskInstanceKey other = (TaskInstanceKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProcessInstanceId() != other.getProcessInstanceId()) {
            return false;
        }
        if (this.getTaskCode() != other.getTaskCode()) {
            return false;
        }
        return this.getTaskVersion() == other.getTaskVersion();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskInstanceKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProcessInstanceId();
        long $taskCode = this.getTaskCode();
        result = result * 59 + (int)($taskCode >>> 32 ^ $taskCode);
        result = result * 59 + this.getTaskVersion();
        return result;
    }

    @Generated
    public String toString() {
        return "TaskInstanceKey(processInstanceId=" + this.getProcessInstanceId() + ", taskCode=" + this.getTaskCode() + ", taskVersion=" + this.getTaskVersion() + ")";
    }

    @Generated
    public TaskInstanceKey(int processInstanceId, long taskCode, int taskVersion) {
        this.processInstanceId = processInstanceId;
        this.taskCode = taskCode;
        this.taskVersion = taskVersion;
    }
}

