/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.utils;

import java.math.BigDecimal;
import org.apache.dolphinscheduler.dao.entity.DqExecuteResult;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.CheckType;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.DqFailureStrategy;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.DqTaskState;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.OperatorType;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskEvent;
import org.apache.dolphinscheduler.service.alert.ProcessAlertManager;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataQualityResultOperator {
    private final Logger logger = LoggerFactory.getLogger(DataQualityResultOperator.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ProcessAlertManager alertManager;

    public void operateDqExecuteResult(TaskEvent taskResponseEvent, TaskInstance taskInstance) {
        if ("DATA_QUALITY".equals(taskInstance.getTaskType())) {
            ProcessInstance processInstance = this.processService.findProcessInstanceDetailById(Integer.parseInt(String.valueOf(taskInstance.getProcessInstanceId())));
            if (taskResponseEvent.getState().isFailure() || taskResponseEvent.getState().isKill()) {
                this.processService.deleteDqExecuteResultByTaskInstanceId(taskInstance.getId().intValue());
                this.processService.deleteTaskStatisticsValueByTaskInstanceId(taskInstance.getId().intValue());
                this.sendDqTaskErrorAlert(taskInstance, processInstance);
                return;
            }
            this.processService.updateDqExecuteResultUserId(taskInstance.getId().intValue());
            DqExecuteResult dqExecuteResult = this.processService.getDqExecuteResultByTaskInstanceId(taskInstance.getId().intValue());
            if (dqExecuteResult != null) {
                this.checkDqExecuteResult(taskResponseEvent, dqExecuteResult, processInstance);
            }
        }
    }

    private void checkDqExecuteResult(TaskEvent taskResponseEvent, DqExecuteResult dqExecuteResult, ProcessInstance processInstance) {
        if (this.isFailure(dqExecuteResult)) {
            DqFailureStrategy dqFailureStrategy = DqFailureStrategy.of((Integer)dqExecuteResult.getFailureStrategy());
            if (dqFailureStrategy != null) {
                dqExecuteResult.setState(DqTaskState.FAILURE.getCode());
                this.sendDqTaskResultAlert(dqExecuteResult, processInstance);
                switch (dqFailureStrategy) {
                    case ALERT: {
                        this.logger.info("task is failure, continue and alert");
                        break;
                    }
                    case BLOCK: {
                        taskResponseEvent.setState(TaskExecutionStatus.FAILURE);
                        this.logger.info("task is failure, end and alert");
                        break;
                    }
                }
            }
        } else {
            dqExecuteResult.setState(DqTaskState.SUCCESS.getCode());
        }
        this.processService.updateDqExecuteResultState(dqExecuteResult);
    }

    private boolean isFailure(DqExecuteResult dqExecuteResult) {
        CheckType checkType = CheckType.of((Integer)dqExecuteResult.getCheckType());
        double statisticsValue = dqExecuteResult.getStatisticsValue();
        double comparisonValue = dqExecuteResult.getComparisonValue();
        double threshold = dqExecuteResult.getThreshold();
        OperatorType operatorType = OperatorType.of((Integer)dqExecuteResult.getOperator());
        boolean isFailure = false;
        if (operatorType != null) {
            double srcValue = 0.0;
            switch (checkType) {
                case COMPARISON_MINUS_STATISTICS: {
                    srcValue = comparisonValue - statisticsValue;
                    isFailure = this.getCompareResult(operatorType, srcValue, threshold);
                    break;
                }
                case STATISTICS_MINUS_COMPARISON: {
                    srcValue = statisticsValue - comparisonValue;
                    isFailure = this.getCompareResult(operatorType, srcValue, threshold);
                    break;
                }
                case STATISTICS_COMPARISON_PERCENTAGE: {
                    if (comparisonValue > 0.0) {
                        srcValue = statisticsValue / comparisonValue * 100.0;
                    }
                    isFailure = this.getCompareResult(operatorType, srcValue, threshold);
                    break;
                }
                case STATISTICS_COMPARISON_DIFFERENCE_COMPARISON_PERCENTAGE: {
                    if (comparisonValue > 0.0) {
                        srcValue = Math.abs(comparisonValue - statisticsValue) / comparisonValue * 100.0;
                    }
                    isFailure = this.getCompareResult(operatorType, srcValue, threshold);
                    break;
                }
            }
        }
        return isFailure;
    }

    private void sendDqTaskResultAlert(DqExecuteResult dqExecuteResult, ProcessInstance processInstance) {
        this.alertManager.sendDataQualityTaskExecuteResultAlert(dqExecuteResult, processInstance);
    }

    private void sendDqTaskErrorAlert(TaskInstance taskInstance, ProcessInstance processInstance) {
        this.alertManager.sendTaskErrorAlert(taskInstance, processInstance);
    }

    private boolean getCompareResult(OperatorType operatorType, double srcValue, double targetValue) {
        BigDecimal src = BigDecimal.valueOf(srcValue);
        BigDecimal target = BigDecimal.valueOf(targetValue);
        switch (operatorType) {
            case EQ: {
                return src.compareTo(target) == 0;
            }
            case LT: {
                return src.compareTo(target) <= -1;
            }
            case LE: {
                return src.compareTo(target) == 0 || src.compareTo(target) <= -1;
            }
            case GT: {
                return src.compareTo(target) >= 1;
            }
            case GE: {
                return src.compareTo(target) == 0 || src.compareTo(target) >= 1;
            }
            case NE: {
                return src.compareTo(target) != 0;
            }
        }
        return true;
    }
}

