/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host.assign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.AbstractSelector;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostWorker;
import org.springframework.stereotype.Service;

@Service
public class RoundRobinSelector
extends AbstractSelector<HostWorker> {
    private ConcurrentMap<String, ConcurrentMap<String, WeightedRoundRobin>> workGroupWeightMap = new ConcurrentHashMap<String, ConcurrentMap<String, WeightedRoundRobin>>();
    private static final int RECYCLE_PERIOD = 100000;
    private AtomicBoolean updateLock = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostWorker doSelect(Collection<HostWorker> source) {
        ArrayList<HostWorker> hosts = new ArrayList<HostWorker>(source);
        String key = ((HostWorker)((Object)hosts.get(0))).getWorkerGroup();
        ConcurrentMap map = (ConcurrentMap)this.workGroupWeightMap.get(key);
        if (map == null) {
            this.workGroupWeightMap.putIfAbsent(key, new ConcurrentHashMap());
            map = (ConcurrentMap)this.workGroupWeightMap.get(key);
        }
        int totalWeight = 0;
        long maxCurrent = Long.MIN_VALUE;
        long now = System.currentTimeMillis();
        HostWorker selectedHost = null;
        WeightedRoundRobin selectWeightRoundRobin = null;
        for (HostWorker host : hosts) {
            String workGroupHost = host.getWorkerGroup() + host.getAddress();
            WeightedRoundRobin weightedRoundRobin = (WeightedRoundRobin)map.get(workGroupHost);
            int weight = host.getHostWeight();
            if (weight < 0) {
                weight = 0;
            }
            if (weightedRoundRobin == null) {
                weightedRoundRobin = new WeightedRoundRobin();
                weightedRoundRobin.setWeight(weight);
                map.putIfAbsent(workGroupHost, weightedRoundRobin);
                weightedRoundRobin = (WeightedRoundRobin)map.get(workGroupHost);
            }
            if (weight != weightedRoundRobin.getWeight()) {
                weightedRoundRobin.setWeight(weight);
            }
            long cur = weightedRoundRobin.increaseCurrent();
            weightedRoundRobin.setLastUpdate(now);
            if (cur > maxCurrent) {
                maxCurrent = cur;
                selectedHost = host;
                selectWeightRoundRobin = weightedRoundRobin;
            }
            totalWeight += weight;
        }
        if (!this.updateLock.get() && hosts.size() != map.size() && this.updateLock.compareAndSet(false, true)) {
            try {
                ConcurrentHashMap newMap = new ConcurrentHashMap(map);
                newMap.entrySet().removeIf(item -> now - ((WeightedRoundRobin)item.getValue()).getLastUpdate() > 100000L);
                this.workGroupWeightMap.put(key, newMap);
            }
            finally {
                this.updateLock.set(false);
            }
        }
        if (selectedHost != null) {
            selectWeightRoundRobin.sel(totalWeight);
            return selectedHost;
        }
        return (HostWorker)((Object)hosts.get(0));
    }

    protected static class WeightedRoundRobin {
        private int weight;
        private AtomicLong current = new AtomicLong(0L);
        private long lastUpdate;

        protected WeightedRoundRobin() {
        }

        int getWeight() {
            return this.weight;
        }

        void setWeight(int weight) {
            this.weight = weight;
            this.current.set(0L);
        }

        long increaseCurrent() {
            return this.current.addAndGet(this.weight);
        }

        void sel(int total) {
            this.current.addAndGet(-1L * (long)total);
        }

        long getLastUpdate() {
            return this.lastUpdate;
        }

        void setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
        }
    }
}

