/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.event;

import com.google.auto.service.AutoService;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.server.master.event.StateEvent;
import org.apache.dolphinscheduler.server.master.event.StateEventHandleException;
import org.apache.dolphinscheduler.server.master.event.StateEventHandler;
import org.apache.dolphinscheduler.server.master.event.WorkflowStateEvent;
import org.apache.dolphinscheduler.server.master.metrics.ProcessInstanceMetrics;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={StateEventHandler.class})
public class WorkflowStateEventHandler
implements StateEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowStateEventHandler.class);

    @Override
    public boolean handleStateEvent(WorkflowExecuteRunnable workflowExecuteRunnable, StateEvent stateEvent) throws StateEventHandleException {
        WorkflowStateEvent workflowStateEvent = (WorkflowStateEvent)stateEvent;
        this.measureProcessState(workflowStateEvent);
        ProcessInstance processInstance = workflowExecuteRunnable.getProcessInstance();
        ProcessDefinition processDefinition = processInstance.getProcessDefinition();
        logger.info("Handle workflow instance state event, the current workflow instance state {} will be changed to {}", (Object)processInstance.getState(), (Object)workflowStateEvent.getStatus());
        if (workflowStateEvent.getStatus().isStop()) {
            if (processDefinition.getExecutionType().typeIsSerialWait() || processDefinition.getExecutionType().typeIsSerialPriority()) {
                workflowExecuteRunnable.endProcess();
                return true;
            }
            workflowExecuteRunnable.updateProcessInstanceState(workflowStateEvent);
            return true;
        }
        if (workflowExecuteRunnable.processComplementData()) {
            return true;
        }
        if (workflowStateEvent.getStatus().isFinished()) {
            workflowExecuteRunnable.endProcess();
        }
        if (processInstance.getState().isReadyStop()) {
            workflowExecuteRunnable.killAllTasks();
        }
        return true;
    }

    @Override
    public StateEventType getEventType() {
        return StateEventType.PROCESS_STATE_CHANGE;
    }

    private void measureProcessState(WorkflowStateEvent processStateEvent) {
        if (processStateEvent.getStatus().isFinished()) {
            ProcessInstanceMetrics.incProcessInstanceByState("finish");
        }
        switch (processStateEvent.getStatus()) {
            case STOP: {
                ProcessInstanceMetrics.incProcessInstanceByState("stop");
                break;
            }
            case SUCCESS: {
                ProcessInstanceMetrics.incProcessInstanceByState("success");
                break;
            }
            case FAILURE: {
                ProcessInstanceMetrics.incProcessInstanceByState("fail");
                break;
            }
        }
    }
}

