/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskExecuteStartCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.master.runner.StreamTaskExecuteRunnable;
import org.apache.dolphinscheduler.server.master.runner.StreamTaskExecuteThreadPool;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskExecuteStartProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskExecuteStartProcessor.class);
    @Autowired
    private StreamTaskExecuteThreadPool streamTaskExecuteThreadPool;
    @Autowired
    private ProcessService processService;

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_EXECUTE_START == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskExecuteStartCommand taskExecuteStartCommand = (TaskExecuteStartCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskExecuteStartCommand.class);
        this.logger.info("taskExecuteStartCommand: {}", (Object)taskExecuteStartCommand);
        TaskDefinition taskDefinition = this.processService.findTaskDefinition(taskExecuteStartCommand.getTaskDefinitionCode(), taskExecuteStartCommand.getTaskDefinitionVersion());
        if (taskDefinition == null) {
            this.logger.error("Task definition can not be found, taskDefinitionCode:{}, taskDefinitionVersion:{}", (Object)taskExecuteStartCommand.getTaskDefinitionCode(), (Object)taskExecuteStartCommand.getTaskDefinitionVersion());
            return;
        }
        this.streamTaskExecuteThreadPool.execute(new StreamTaskExecuteRunnable(taskDefinition, taskExecuteStartCommand));
        Command response = new Command(command.getOpaque());
        response.setType(CommandType.TASK_EXECUTE_START);
        response.setBody(new byte[0]);
        channel.writeAndFlush((Object)response);
    }
}

